<?php if (!defined('BASEPATH')) exit('No direct script access allowed');

class c_template_agama_pk extends CI_Controller {
    function index() {
         if($this->session->userdata('is_logged_in')==FALSE){
            redirect('login');
        }  
    }

    function popup_akta_pk(){   
        if($this->session->userdata('is_logged_in')==FALSE){
            redirect('login');
        }   
        $data['enc']=$this->uri->segment('3');
        $idperkara=$this->encrypt->decode(base64_decode($data['enc']));
        if(!is_numeric($idperkara) OR !intval($idperkara)>0){
            show_404();
            exit();
        }

        $data['pihakasal']=$this->uri->segment('4');        
        //$pihakasal=$this->encrypt->decode(base64_decode($data['pihakasal']));

        $data['encpemohon']=$this->uri->segment('5');
        $idpemohon=$this->encrypt->decode(base64_decode($data['encpemohon']));
        if(!is_numeric($idpemohon) OR !intval($idpemohon)>0){
            show_404();
            exit();
        }


        $this->load->model('generate_template/m_template_agama_pk','template');
        $data['dataPutusan']=$this->template->getDataPutusan($idperkara);
        $data['listPembuatAkta'] = $this->template->pembuatAkta($idperkara);
        $info=$this->template->getInfo($idperkara,$idpemohon);

         if($info != ''){
             $data['namapihak'] = '';
             if($info->num_rows>0){
                 foreach ($info->result() as $row) {                                
                     $diwakili = FALSE;
                     $data['namapihak'] .= $this->templatehelper->standradnaming($row->pihak_nama);
                     if($row->diwakili=='Y'){
                         $diwakili = TRUE;
                         $data['namapihak'] .= "</br>Diwakili oleh: ".$this->templatehelper->standradnaming($row->pemohon_nama);
                     }
                 }
             }
         }


        $data['jenisaktapk']=$this->uri->segment('6');
        if(!is_numeric($data['jenisaktapk']) OR !intval($data['jenisaktapk'])>=1){
            show_404();
            exit();
        }
        
        if ($data['jenisaktapk']==1) {
            $data['template']=$this->template->getDataDocumentTemplate('15','40','510','1','');
        }elseif($data['jenisaktapk']==2){
            $data['template']=$this->template->getDataDocumentTemplate('15','40','521','1','');
        }elseif($data['jenisaktapk']==3){
            $data['template']=$this->template->getDataDocumentTemplate('15','40','523','1','');
        }        

        
        $this->load->view('generate_template/peradilan_agama/popup_akta_pk',$data,FALSE);
    }

    function cetak_akta_pk(){
        if($this->session->userdata('is_logged_in')==FALSE){
            redirect('login');
        }       
        $data['enc'] = $this->input->post('enc',TRUE);
        $idperkara=$this->encrypt->decode(base64_decode($data['enc']));
        if(!is_numeric($idperkara) OR !intval($idperkara)>0){
             echo 'idperkara';
             show_404();
             exit();
        }           
        $encpemohon = $this->input->post('encpemohon',TRUE);
        $idpemohon=$this->encrypt->decode(base64_decode($encpemohon));
        if(!is_numeric($idpemohon) OR !intval($idpemohon)>0){
             echo 'idpemohon';
             show_404();
             exit();
        }
               
        $data['jenisAkta'] = $this->input->post('jenisAkta',TRUE);
        if(empty($data['jenisAkta']) OR intval($data['jenisAkta'])<1){
            echo 'idakta';
            show_404();
        }
        
        $encputusan = $this->input->post('putusan',TRUE);
        $idputusan=$this->encrypt->decode(base64_decode($encputusan));

        if(empty($idputusan) OR intval($idputusan)<1){
            echo 'idputusan';
            show_404();
        }

        $data['penandatangan'] = $this->input->post('penandaT',TRUE);
        $penandatangan=$this->encrypt->decode(base64_decode($data['penandatangan']));
        

        $this->load->model('generate_template/m_template_agama_pk','template');
        $data['dataPN'] = $this->template->getDataPN($idperkara);
        $data['dataPemohonpk']=$this->template->listAllPemohonpk($idperkara);
        $data['dataTermohonpk']=$this->template->listAllTermohonpk($idperkara);
        $data['idTerhadapPutusan']=$this->template->listAllTermohonpk($idperkara);

        $data['dataTemplate'] = $this->template->cetak_AktaPermohonanPK($idperkara,$penandatangan,$idpemohon,$idputusan);
        
        if($data['jenisAkta']=='1'){
            $data['template']=$this->template->getDataDocumentTemplate('15','40','510','1','');  
        }elseif($data['jenisAkta']=='2'){
            $data['template']=$this->template->getDataDocumentTemplate('15','40','510','2','');  
        }elseif($data['jenisAkta']=='3'){
            $data['template']=$this->template->getDataDocumentTemplate('15','40','510','3','');  
        }elseif($data['jenisAkta']=='4'){
            $data['template']=$this->template->getDataDocumentTemplate('15','40','510','4','');  
        }elseif($data['jenisAkta']=='21'){
            $data['template']=$this->template->getDataDocumentTemplate('15','40','521','1','');  
        }elseif($data['jenisAkta']=='31'){
            $data['template']=$this->template->getDataDocumentTemplate('15','40','523','1','');  
        }elseif($data['jenisAkta']=='41'){
            $data['template']=$this->template->getDataDocumentTemplate('15','40','570','1','');  
        }elseif($data['jenisAkta']=='42'){
            $data['template']=$this->template->getDataDocumentTemplate('15','40','570','2','');  
        }else{
            show_404();
        }
        $this->load->view('generate_template/peradilan_agama/cetak_akta_pk',$data,FALSE);
    }

    function popup_relaas_pk(){
        if($this->session->userdata('is_logged_in')==FALSE){
            redirect('login');
        } 

        $data['enc']=$this->uri->segment('3');
        $idperkara=$this->encrypt->decode(base64_decode($data['enc']));
        if(!is_numeric($idperkara) OR !intval($idperkara)>0){
            show_404();
            exit();
        }

        $data['pihakasal']=$this->encrypt->decode(base64_decode($this->uri->segment('4')));        
        if(!is_numeric($data['pihakasal']) OR !intval($data['pihakasal'])>0){
            show_404();
            exit();
        }


        $data['$encpihak']=$this->uri->segment('5');
        $idpihak=$this->encrypt->decode(base64_decode($data['$encpihak']));
        if(!is_numeric($idpihak) OR !intval($idpihak)>0){
            show_404();
            exit();
        }

        $data['jenisrelas']=$this->uri->segment('6');

        $data['current_date'] = date('d/m/Y');

        $this->load->model('generate_template/peradilan_agama/m_template_agama_relaas_pk','template');
        $data['listTerdakwa'] = $this->template->getDataTerdakwa($idperkara,$idpihak);
        $data['listKuasaP'] = $this->template->getKuasaPenggugat($idperkara,$idpihak);
        $data['listKuasaT'] = $this->template->getKuasaTergugat($idperkara,$idpihak);
        $data['listKuasaInter'] = $this->template->getKuasaIntervensi($idperkara,$idpihak);     
        $data['listPenuntut'] = $this->template->getInfoPihak($idperkara,$idpihak);                                 
        $data['listJurusita'] = $this->template->getAllJurusita($idperkara);        
        $data['listTglPK'] = $this->template->infoTglPKAll($idperkara);
        $data['listTglMemori'] = $this->template->infoTglTerimaMemori($idperkara);
        $data['listTglKontraMemori'] = $this->template->infoTglTerimaKontraMemori($idperkara);              
        $data['listPT'] = $this->template->infoPT();
        $data['listPN'] = $this->template->infoPN();
        $data['ttdKetua'] = $this->template->ttdKetua();
        $data['listBiayaPemberitahuan'] = $this->template->listBiayaPemberitahuan($idperkara);      

        $data['infotglpemberitahuan'] = $this->template->getTanggalPemberitahuanPK($idperkara,$idpihak);
        foreach ($data['infotglpemberitahuan']->result() as $row) {
            if($data['jenisrelas']==1){
                $data['tglpemberitahuan'] = $row->pemberitahuan;
                $data['tglpemberitahuanindo'] = $this->templatehelper->convertKeTglIndo($row->pemberitahuan);           
            }
            if($data['jenisrelas']==2){
                $data['tglpemberitahuan'] = $row->penyerahan_memori_pk;
                $data['tglpemberitahuanindo'] = $this->templatehelper->convertKeTglIndo($row->penyerahan_memori_pk);           
            }
            if($data['jenisrelas']==3){
                $data['tglpemberitahuan'] = $row->penyerahan_kontra_pk;
                $data['tglpemberitahuanindo'] = $this->templatehelper->convertKeTglIndo($row->penyerahan_kontra_pk);           
            }
            if($data['jenisrelas']==4){
                $data['tglpemberitahuan'] = $row->pemberitahuan_inzage;
                $data['tglpemberitahuanindo'] = $this->templatehelper->convertKeTglIndo($row->pemberitahuan_inzage);        
            }
            if($data['jenisrelas']==5){
                $data['tglpemberitahuan'] = $row->pemberitahuan_putusan_PK;
                $data['tglpemberitahuanindo'] = $this->templatehelper->convertKeTglIndo($row->pemberitahuan_putusan_PK);           
            }
        }

        
        $data['judul']='';
        $data['jnsperkara']='Gugatan';
        
        $idalurperkara = $this->tanggalhelper->getIDAlurPerkara($idperkara);       
        if($data['jenisrelas']==1){
            $data['judul'] = "PEMBERITAHUAN PERNYATAAN PK";
        }elseif($data['jenisrelas']==2){
            $data['judul'] = "PEMBERITAHUAN DAN PENYERAHAN MEMORI PK";
        }elseif($data['jenisrelas']==3){
            $data['judul'] = "PEMBERITAHUAN DAN PENYERAHAN KONTRA MEMORI PK";
        }elseif($data['jenisrelas']==4){
            $data['judul'] = "RELAAS PEMBERITAHUAN INZAGE";
        }elseif($data['jenisrelas']==5){
            $data['judul'] = "RELAAS PEMBERITAHUAN PUTUSAN PK";
        }else{
            $data['judul'] = "RELAAS PEMBERITAHUAN";
        }
        $this->load->view('generate_template/peradilan_agama/popup_relaas_pk',$data,FALSE);
    }

    function cetak_relaas_pk(){
        if($this->session->userdata('is_logged_in')==FALSE){
            redirect('login');
        } 
        $data['enc'] = $this->input->post('enc',TRUE);
        $idperkara=$this->encrypt->decode(base64_decode($data['enc']));
        if(!is_numeric($idperkara) OR !intval($idperkara)>0){
             show_404();
             exit();
        }
        
        $data['idterdakwa'] = $this->input->post('terdakwa',TRUE);
        $idterdakwa=$this->encrypt->decode(base64_decode($data['idterdakwa']));                 
        $data['idjurusita'] = $this->input->post('jurusita',TRUE);
        $idjurusita=$this->encrypt->decode(base64_decode($data['idjurusita']));                                    
        $data['penasihat'] = $this->input->post('idpenasihat',TRUE);
        $penasihat=$this->encrypt->decode(base64_decode($data['penasihat']));       
        $data['jenisAkta'] = $this->input->post('jenisAkta',TRUE);
        if(empty($data['jenisAkta']) OR intval($data['jenisAkta'])<1){
            show_404();
            exit();
        }                     
        $idPengadilan = $this->input->post('namaPN',TRUE);  
        $data['tgldelegasi'] = $this->tanggalhelper->convertToMysqlDate($this->input->post('tglPanggil',TRUE));
                
        $idPK = $this->encrypt->decode(base64_decode($this->input->post('tglPK',TRUE)));        
        $idpenandatangan = $this->input->post('penandaT',TRUE);   
        $data['idpenandatangan'] = $this->encrypt->decode(base64_decode($idpenandatangan));    
        $data['tglpemberitahuan'] = $this->input->post('tglpemberitahuan',TRUE);
        $data['tglPenerimaan'] = $this->input->post('tglPenerimaan',TRUE);      
        $data['biayapemberitahuan'] = $this->input->post('biayapemberitahuan',TRUE);
		
        $this->load->model('generate_template/peradilan_agama/m_template_agama_relaas_pk','template');       
        $data['dataPerkara'] = $this->template->getDataPerkara($idperkara);
        $data['dataPN'] = $this->template->getDataPN($idperkara);
        $data['tanggalPutus'] = $this->template->getTanggalPutusan($idperkara);
        $data['infoPihak'] = $this->template->infoPihak($idperkara,$idterdakwa);
        $data['infoallpemohonpk'] = $this->template->infoAllPemohonPK($idperkara);            
        $data['infoalltermohonPK'] = $this->template->infoAllTermohonPK($idperkara);
        $data['infoKuasaPihak'] = $this->template->infoKuasaPihak($idperkara,$penasihat);
        $data['cetakJurusita'] = $this->template->cetakJurusita($idjurusita);                      
        
		if($data['jenisAkta']>=1 && $data['jenisAkta']<=19){		                
        	$data['cetaktglpk'] = $this->template->cetaktglpk($idPK);
        } 
		
        if($data['jenisAkta']==7 OR $data['jenisAkta']==9 OR $data['jenisAkta']==11 OR $data['jenisAkta']==15 OR $data['jenisAkta']==18 OR $data['jenisAkta']==21){
            $data['cetakNamaPN'] = $this->template->cetakNamaPN($idPengadilan);         
        }

        if(($data['jenisAkta']==1)||($data['jenisAkta']==3)){          
            $data['template']=$this->template->getDataDocumentTemplate('15','40','520','201','');
        }elseif(($data['jenisAkta']==7)||($data['jenisAkta']==9)||($data['jenisAkta']==11)){
            $data['template']=$this->template->getDataDocumentTemplate('15','40','520','202','');
        }elseif(($data['jenisAkta']==8)||($data['jenisAkta']==10)||($data['jenisAkta']==12)){
            $data['template']=$this->template->getDataDocumentTemplate('15','40','522','201','');
        }elseif(($data['jenisAkta']==13)||($data['jenisAkta']==16)||($data['jenisAkta']==19)){
            $data['template']=$this->template->getDataDocumentTemplate('15','40','524','201','');
        }else{
            show_404();
        }

    $this->load->view('generate_template/peradilan_agama/cetak_relaas_pk',$data,FALSE);
    }
}