<?php defined('BASEPATH') OR exit('No direct script access allowed');

class C_agama extends CI_Controller {    
    
    function __construct() {
        parent::__construct();
        $this->load->model('generate_template/m_new_template', 'temp');
    }

    function filename_fixed($url){
      $parts = parse_url($url);
      $path_parts = array_map('rawurldecode', explode('/', $parts['path']));
      return $parts['scheme'] . '://' . $parts['host'] . implode('/', array_map('rawurlencode', $path_parts));
    }

    function index($file,$perkara_id=111,$tahapan_id,$proses_id,$pihak_id,$jadwalsidang_id=3004,$jurusita_id=NULL){
        echo '<pre>';
        $source_file = $this->filename_fixed(base_url("resources/template/new_template/".base64_decode($file)));      
        $data['target_file']    = 'template_hasil.rtf';
        $data['Template'] = file_get_contents($source_file);
        $variabel   = array('var_general',
                            'var_perkara',
                            'var_jadwal_sidang',
                            // 'var_penetapan',
                            // 'var_diversi',
                            'var_dismissal',
                            // 'var_mediasi',
                            // 'var_bas',
                            'var_penetapan_hari_sidang',
                            // 'var_persidangan',
                            // 'var_putusan_sela',
                            'var_putusan_akhir',
                            'var_putusan_akhir',
                            // 'var_pihak',
                            // 'var_keuangan',
                            'var_putusan_sela',
                            'var_penetapan_persiapan'
                            );

        $data_id = array ('perkara_id'=>$perkara_id,
                          'pihak_id'=>$pihak_id,
                          'tahapan_id'=>$tahapan_id,
                          'proses_id'=>$proses_id,
                          'pihak_ke'=>$pihak_ke,
                          'keterangan_ph'=>$keterangan_ph,
                          'mengerti_dakwaan'=>$mengerti_dakwaan,
                          'jurusita_id'=>$jurusita_id,
                          'ditetapkan_oleh'=>2);


        // variabel yang sama
        $item['#tanggal_penetapan_phs#']=$item['#tanggal_phs#'];
        $item['#jenis_perkara#']        = $item['#jenis_perkara_text#'];



        foreach ($variabel as $key => $value) {
            $get='get_'.$value;
            if($value=='var_general'){
                $perkara = $this->temp->$get($data_id);
            }else{
                $perkara = $this->temp->$get();
            }
            if ($perkara->num_rows() == 0 ) $item['__']=":D";
            $field_perkara = array_keys($perkara->result_array()[0]);
            foreach ($perkara->result() as $row) {
                for($i = 0; $i <count($field_perkara) ; $i++) {
                    if($row->$field_perkara[$i]==''){
                        $val='.....';
                    }else{
                        $val=$row->$field_perkara[$i];
                    }
                    $item["#".$field_perkara[$i]."#"]=$val;
                }   
            }
        }

        // special request
        $item['#satker#']               = ucwords(strtolower($item['satker_kapital']));
        $item['#nama_kota#']            = ucwords(strtolower($this->templatehelper->namaKota($item['satker_kapital'])));
        $item['#nama_kota_kapital#']    = strtoupper($this->templatehelper->namaKota($item['satker_kapital']));
        $item['#pengadilan_negeri#']    = ucwords(strtolower($item['pengadilan_negeri_kapital']));

        if ($data_id['ditetapkan_oleh']=="2"){
            $item['#nama_ketua#']               =  $item["#nama_wakil#"];
        }else if ($data_id['ditetapkan_oleh']=="4"){
            $item['#nama_panitera#']            =  $item["#nama_wapan#"];
        }


        
        $field_var = array_keys($item);
        for($i = 0; $i <count($field_var) ; $i++) {
            $kolom=$field_var[$i];
            if(stristr($kolom, 'hijriah')){
                $item[$kolom]=$this->templatehelper->convertToHijriah($item[$kolom]);    
            }
            $item[$kolom]="\highlight7 ".$this->templatehelper->cleanHtmlTagSpecial($item[$kolom]);
        }
        print_r($item);exit();
        $data['variabel'] = $item; 
        $this->load->view('generate_template/cetak_new_template.php',$data);
    }

    function var_penetapan(){
        $hakim = $this->temp->get_var_penetapan_hakim();
        $n=0;
        foreach ($hakim->result() as $row) {
            if($row->jabatan_hakim_id==1){   
                $item['#ketua_majelis#']=$row->hakim_nama;
            }elseif($row->jabatan_hakim_id==2){
                $item['#nama_hakim_anggota_'.++$n.'#'] =$row->hakim_nama;
                $item['#hakim_anggota_'.++$n.'#'] =$row->hakim_nama;
                $item['#nrp_hakim_anggota_'.++$n.'#'] =$row->nip;
                $item['#pangkat_hakim_anggota_'.++$n.'#'] =$row->pangkat;
            }
            if($row->jabatan_hakim_id==3){
                $penetapan_majelis =$this->templatehelper->standradnaming($row->hakim_nama)." \\tab Hakim;\\par".PHP_EOL;
            }else{
                $penetapan_majelis .=$this->templatehelper->standradnaming($row->hakim_nama)." \\tab ".$row->jabatan_hakim_nama.";\\par".PHP_EOL;
            }         
        }
        $item['#penetapan_majelis#']                = $penetapan_majelis;

        $panitera = $this->temp->get_var_penetapan_panitera();
        foreach ($panitera->result() as $row) {
            $penetapan_pp .= $this->templatehelper->standradnaming($row->nama_pp)." \\tab ".$row->jabatan_pp.";\\par".PHP_EOL;  
        }

        $jurusita = $this->temp->get_var_penetapan_jurusita();
        $no=0;
        foreach ($jurusita->result() as $row) {
            if($no==0){
                $temp.='';
            }elseif($no==$jurusita->num_rows()-1){
                $temp.=' dan ';
            }else{
                $temp.=', ';
            }
            
            $temp .= $this->templatehelper->standradnaming($row->nama_jurusita);

            if($row->jurusita==1){
                $js='Jurusita';
            }
            if($row->jurusita==2){
                if(isset($js)){
                    $js.=' dan '; 
                }
                $js.='Jurusita Pengganti';
            }
        }      

        if ($hakim->num_rows()==1 ){  
            $majelis_hakim_atau_hakim = " Hakim ";
            $hakim_ketua_hakim         =" Hakim ";
        }else {  
            $majelis_hakim_atau_hakim = " Majelis Hakim ";
            $hakim_ketua_hakim         =" Hakim Ketua ";
        }

        $item['#hakim_ketua_hakim#']                = $hakim_ketua_hakim;
        $item['#majelis_hakim_atau_hakim#']         = $majelis_hakim_atau_hakim;
        $item['#panitera#']                         = $item['#jabatan_pp#'];
        $item['#penetapan_pp#']                     = $penetapan_pp;
        $item['#penetapan_jaksa#']                  = $this->penetapan_jaksa();       

       
        return $item;
    }
    function var_bas($data_id){
         $item['#keterangan_ph#']   = $data_id['keterangan_ph'];
         $item['#mengerti_dakwaan#'] = $data_id['mengerti_dakwaan'];
         return $item;
    }
    function var_diversi(){
         $item['------ diversi --------- ']="";
         return $item;
    }


    function looping_terdakwa_penahanan(){
        $perkara = $this->temp->get_var_penahanan();
        if ($perkara->num_rows() == 0 ) $item['__']=":D";
        $field_perkara = array_keys($perkara->result_array()[0]);
        foreach ($perkara->result() as $row) {
              $item['#jenis_tahanan#'] = $row->jenis_tahanan;
        }
        return $item;
    }

    function var_mediasi(){
       $item['------ medi asi --------- ']="";
        return $item;
    }

    
    
    function var_pihak(){
        $item['#looping_pihak1#']             = $this->looping_pihak(1);
        $item['#looping_pihak1_dkk#']         = $this->looping_pihak_dkk(1);
        $item['#looping_nama_pihak1#']        = $this->looping_nama_pihak(1);
        $item['#looping_pihak1_tt#']          = $this->looping_pihak_tt(1);
        $item['#is_kuasa_pihak1#']            = '';
        $item['#looping_pihak2#']             = $this->looping_pihak(2);
        $item['#looping_pihak2_dkk#']         = $this->looping_pihak_dkk(2);
        $item['#looping_nama_pihak2#']        = $this->looping_nama_pihak(2);
        $item['#looping_pihak2_tt#']          = $this->looping_pihak_tt(2);
        $item['#is_kuasa_pihak2#']            = '';
        $item['#terdakwa_para_terdakwa#']     = $this->get_terdakwa('para_or_terdakwa');
        $item['#looping_terdakwa_dkk#']       = $this->looping_terdakwa_dkk();
        $item['#looping_terdakwa#']           = $this->looping_terdakwa();    
        $item = array_merge($item, $this->looping_terdakwa_penahanan());
        print_r($item);exit();
        $item['#terdakwa_dkk#']               = $this->get_terdakwa('dkk');
        $item['#pemohon_prapid#']             = $this->looping_prapid(1);
        $item['#termohon_prapid#']            = $this->looping_prapid(2); 
        

        return $item;
    }

    function var_keuangan(){
       $item['------ keuangan --------- ']="";
         return $item;
    }
    
    function var_global($data_id){
        $item["#SEBAGAI_PIHAK1#"]   =' PEMOHON ';
        $item["#sebagai_pihak1#"]   =' Pemohon ';
        $item["#SEBAGAI_P#"]        =' PEMOHON ';
        $item["#sebagai_p#"]        =' Pemohon ';
        $item["#SEBAGAI_PIHAK2#"]   =' TERMOHON ';
        $item["#sebagai_pihak2#"]   =' Termohon ';
        $item["#SEBAGAI_T#"]        =' TERMOHON ';
        $item["#sebagai_t#"]        =' Termohon ';
        return $item;    
    }

    function penetapan_jaksa($var){
        $dataPihak = $this->temp->get_var_pihak(1);    
        foreach($dataPihak->result() as $row){
            $jaksa .= $this->CI->templatehelper->standradnaming($row->nama)." "." \\tab ".$row->pekerjaan." \\par ";
        }
        return $jaksa;

    }

    function get_terdakwa($var){
        $dataPihak = $this->temp->get_var_pihak(2);
        if ($dataPihak->num_rows > 0 ) {
            $para_or_terdakwa=" Para Terdakwa ";
            $dkk=" Dkk ";
        } else {
            $para_or_terdakwa=" Terdakwa ";
            $dkk=" ";
        }

        
        $terdakwa_dkk = $para_or_terdakwa. $this->CI->templatehelper->standradnaming($dataPihak->result()[0]->nama)." ".$dkk;
    
        
        if ($var=='dkk') {
            return $terdakwa_dkk;
        }else if ($var=="para_or_terdakwa"){
            return $para_or_terdakwa;
        }

    }

    function looping_terdakwa(){
        $dataterdakwa = $this->temp->get_var_pihak(2);
        if($dataterdakwa->num_rows > 1){
           $no=1;     
        }else{
           $no=" ";
        }
            foreach ($dataterdakwa->result() as $row){
                    if(empty($row->nama)){
                        $row->nama = '......'; 
                    }

                    $namaterdakwa = '\listid1'.$this->CI->templatehelper->standradnaming($row->nama);

                    if(empty($row->tempat_lahir)){
                        $row->tempat_lahir = '......'; 
                    }

                    $tempatlahir = '\listid1'.$row->tempat_lahir;   
                    if(empty($row->tanggal_lahir) OR $row->tanggal_lahir==NULL){
                        $tgllahir="................";
                        $umur=".............";
                    }else{
                        $tgllahir = '\listid1'.' '.$row->hari_lahir." ".$this->CI->templatehelper->convertKeTglIndo($row->tanggal_lahir);
                        $umur = $this->CI->tanggalhelper->getSelisihTahun($row->tanggal_lahir,date('Y-m-d'));
                    }
                    

                    if(empty($row->warga_negara)){
                        $row->warga_negara = '......'; 
                    }

                    $kebangsaan = '\listid1'.$this->CI->templatehelper->standradnaming($row->warga_negara);

                    if(empty($row->alamat)){
                        $row->alamat = '......'; 
                    }
                    $alamat = '\listid1'.$row->alamat;

                    if(empty($row->agama_nama)){
                        $row->agama_nama = '......'; 
                    }
                    $agama = '\listid1'.$this->CI->templatehelper->standradnaming($row->agama_nama);
                    
                    if(empty($row->pekerjaan)){
                        $row->pekerjaan = '......'; 
                    }

                    $pekerjaan = '\listid1'.$this->CI->templatehelper->standradnaming($row->pekerjaan);
                    
                    if ($row->jenis_kelamin=='P') {
                        $sex = 'Perempuan';
                    } else{
                        $sex = 'Laki-laki';
                    }
                
                     $identitas .= $this->CI->templatehelper->converToAngkaRomawi($no)." ".
                                             'Nama lengkap          \\tab :\\tab '.$namaterdakwa.$dkk.'; \\par '.
                                             'Tempat lahir          \\tab :\\tab '.$tempatlahir.'; \\par '.
                                             'Umur/tanggal lahir    \\tab :\\tab '.$umur.' Tahun / '.$tgllahir.'; \\par '.
                                             'Jenis Kelamin         \\tab :\\tab '.$sex.'; \\par '.
                                             'Kebangsaan            \\tab :\\tab '.$kebangsaan.'; \\par '.
                                             'Tempat tinggal        \\tab :\\tab '.$alamat.'; \\par '.
                                             'Agama                 \\tab :\\tab '.$agama.'; \\par '.
                                             'Pekerjaan             \\tab :\\tab '.$pekerjaan.'; \\par ';
                    $no++;
            }

            return $identitas;

    }

    
    function looping_terdakwa_dkk(){ 
        $counter = 1;
        $dataterdakwa = $this->temp->get_var_pihak(2);
        if($dataterdakwa->num_rows > 0){
            $dkk='; Dan kawan-kawan';
        }else{
            $dkk='';
        }
        foreach ($dataterdakwa->result() as $row){
                if($counter==1){
                    if(empty($row->nama)){
                        $row->nama = '......'; 
                    }

                    $namaterdakwa = '\listid1'.$this->CI->templatehelper->standradnaming($row->nama);

                    if(empty($row->tempat_lahir)){
                        $row->tempat_lahir = '......'; 
                    }

                    $tempatlahir = '\listid1'.$row->tempat_lahir;   
                    if(empty($row->tanggal_lahir) OR $row->tanggal_lahir==NULL){
                        $tgllahir="................";
                        $umur=".............";
                    }else{
                        $tgllahir = '\listid1'.' '.$row->hari_lahir." ".$this->CI->templatehelper->convertKeTglIndo($row->tanggal_lahir);
                        $umur = $this->CI->tanggalhelper->getSelisihTahun($row->tanggal_lahir,date('Y-m-d'));
                    }
                    

                    if(empty($row->warga_negara)){
                        $row->warga_negara = '......'; 
                    }

                    $kebangsaan = '\listid1'.$this->CI->templatehelper->standradnaming($row->warga_negara);

                    if(empty($row->alamat)){
                        $row->alamat = '......'; 
                    }
                    $alamat = '\listid1'.$row->alamat;

                    if(empty($row->agama_nama)){
                        $row->agama_nama = '......'; 
                    }
                    $agama = '\listid1'.$this->CI->templatehelper->standradnaming($row->agama_nama);
                    
                    if(empty($row->pekerjaan)){
                        $row->pekerjaan = '......'; 
                    }

                    $pekerjaan = '\listid1'.$this->CI->templatehelper->standradnaming($row->pekerjaan);
                    
                    if ($row->jenis_kelamin=='P') {
                        $sex = 'Perempuan';
                    } else{
                        $sex = 'Laki-laki';
                    }
                }
                $counter++;
            }

            $namaKejaksaan =  ((!empty($namaKejaksaan)) ? $this->CI->templatehelper->standradnaming($namaKejaksaan) : 'Kejaksaan ...........' );
            $identitas = 'Nama lengkap          \\tab :\\tab '.$namaterdakwa.$dkk.'; \\par '.
                         'Tempat lahir          \\tab :\\tab '.$tempatlahir.'; \\par '.
                         'Umur/tanggal lahir    \\tab :\\tab '.$umur.' Tahun / '.$tgllahir.'; \\par '.
                         'Jenis Kelamin         \\tab :\\tab '.$sex.'; \\par '.
                         'Kebangsaan            \\tab :\\tab '.$kebangsaan.'; \\par '.
                         'Tempat tinggal        \\tab :\\tab '.$alamat.'; \\par '.
                         'Agama                 \\tab :\\tab '.$agama.'; \\par '.
                         'Pekerjaan             \\tab :\\tab '.$pekerjaan.'; \\par ';

            return $identitas;

    }

    function looping_prapid($pihak){ 
        $counter = 1;
        $dataterdakwa = $this->temp->get_var_pihak($pihak);
        if($dataterdakwa->num_rows > 1){
            $dkk='; Dan kawan-kawan';
            $lawan='Lawan:';
        }else{
            $dkk='';
            $lawan='Lawan';
        }
        foreach ($dataterdakwa->result() as $row){
                if($counter==1){
                    if(empty($row->nama)){
                        $row->nama = '......'; 
                    }

                    $namaterdakwa = '\listid1'.$this->CI->templatehelper->standradnaming($row->nama);

                    if(empty($row->tempat_lahir)){
                        $row->tempat_lahir = '......'; 
                    }

                    $tempatlahir = '\listid1'.$row->tempat_lahir;   
                    if(empty($row->tanggal_lahir) OR $row->tanggal_lahir==NULL){
                        $tgllahir="................";
                        $umur=".............";
                    }else{
                        $tgllahir = '\listid1'.' '.$row->hari_lahir." ".$this->CI->templatehelper->convertKeTglIndo($row->tanggal_lahir);
                        $umur = $this->CI->tanggalhelper->getSelisihTahun($row->tanggal_lahir,date('Y-m-d'));
                    }
                    

                    if(empty($row->warga_negara)){
                        $row->warga_negara = '......'; 
                    }

                    $kebangsaan = '\listid1'.$this->CI->templatehelper->standradnaming($row->warga_negara);

                    if(empty($row->alamat)){
                        $row->alamat = '......'; 
                    }
                    $alamat = '\listid1'.$row->alamat;

                    if(empty($row->agama_nama)){
                        $row->agama_nama = '......'; 
                    }
                    $agama = '\listid1'.$this->CI->templatehelper->standradnaming($row->agama_nama);
                    
                    if(empty($row->pekerjaan)){
                        $row->pekerjaan = '......'; 
                    }

                    $pekerjaan = '\listid1'.$this->CI->templatehelper->standradnaming($row->pekerjaan);
                    
                    if ($row->jenis_kelamin=='P') {
                        $sex = 'Perempuan';
                    } else{
                        $sex = 'Laki-laki';
                    }
                }
                $counter++;
            }

            $namaKejaksaan =  ((!empty($namaKejaksaan)) ? $this->CI->templatehelper->standradnaming($namaKejaksaan) : 'Kejaksaan ...........' );
            if ($pihak==1){
                $identitas = 'Nama lengkap          \\tab :\\tab '.$namaterdakwa.$dkk.'; \\par '.
                             'Tempat lahir          \\tab :\\tab '.$tempatlahir.'; \\par '.
                             'Umur/tanggal lahir    \\tab :\\tab '.$umur.' Tahun / '.$tgllahir.'; \\par '.
                             'Jenis Kelamin         \\tab :\\tab '.$sex.'; \\par '.
                             'Kebangsaan            \\tab :\\tab '.$kebangsaan.'; \\par '.
                             'Tempat tinggal        \\tab :\\tab '.$alamat.'; \\par '.
                             'Agama                 \\tab :\\tab '.$agama.'; \\par '.
                             'Pekerjaan             \\tab :\\tab '.$pekerjaan.'; \\par ';

            }else{
                $identitas = ' '.$namaterdakwa.$dkk.', beralamat di '.$alamat.' ; \\par ';
            }
            return $identitas;

    }

    function looping_pihak_dkk($pihak_ke=1){
        $dataPihak = $this->temp->get_var_pihak($pihak_ke);
        switch ($pihak_ke) {
                case '1':
                    $sebagai="#sebagai_p#";
                    break;
                case '2':
                    $sebagai="#sebagai_t#";
                    break;
                default:
                    # code...
                    break;
            }
        $i=1;
        foreach ($dataPihak->result() as $row) {
            if ($dataPihak->num_rows>1){
                $dkk=" Dkk "; 
            }else{
                $dkk=" ";
            }   
            $pihak = $this->CI->templatehelper->standradnaming($row->nama)." ".$dkk."\\tab #".$sebagai."# ".PHP_EOL;
        }
        return $pihak;
    }


    function looping_pihak_tt($pihak_ke=1){
         $dataPihak = $this->temp->get_var_pihak($pihak_ke);
        switch ($pihak_ke) {
                case '1':
                    $sebagai="#sebagai_p#";
                    break;
                case '2':
                    $sebagai="#sebagai_t#";
                    break;
                default:
                    # code...
                    break;
            }
       $no=0;
        $temp_pihak='';
        $pihak_array='';
        if($dataPihak->num_rows>0){
            foreach ($dataPihak->result() as $row) {
                if ($dataPihak->num_rows()<=1){
                        $pihak_array.=' '.$this->CI->templatehelper->standradnaming($row->nama).' \\par \\par \\par \\par';  
                }else{
                        $pihak_array.=' '.++$no.'. '.$row->nama.' \\par \\par \\par \\par';  
                }
            }
        }else{
            $pihak_array = "Data Pihak Tidak Ada dalam Database!!!";
        }
        return $pihak_array;
    }


    function looping_pihak($pihak_ke=1){      
            $dataPihak = $this->temp->get_var_pihak($pihak_ke);
            switch ($pihak_ke) {
                case '1':
                    $sebagai="#SEBAGAI_P#";
                    break;
                case '2':
                    $sebagai="#SEBAGAI_T#";
                    break;
                default:
                    # code...
                    break;
            }
            $arr_pengacara_pihak.$pihak_ke='';
            $i=0;
            $temp_pihak='';
            $temp_kuasa='';
            $pihak_array='';
            if($dataPihak->num_rows>0){
                foreach ($dataPihak->result() as $row) {
                    if($temp_pihak != $row->pihak_id){
                        $temp_pihak=$row->pihak_id;
                        if($i>0){
                            $pihak_array = str_replace(" #ke# ",' '.$this->CI->templatehelper->converToAngkaRomawi($i), $pihak_array);
                        }
                        
                        $pihak_array.=$this->CI->templatehelper->standradnaming($row->nama).' agama '.$row->agama.
                                ', pekerjaan '.$row->pekerjaan.', Pendidikan '.$row->pendidikan.
                                ', alamat '.$row->alamat;  
                                    
                        if($row->id_kuasa != ''){
                            $arr_pengacara_pihak1='--';
                            if($i>0){$pihak_array= str_replace("#DKK#",'', $pihak_array);}
                            $pihak_array.=' dalam hal ini memberikan kuasa khusus kepada '.$row->nama_kuasa.
                                ', #DKK# advokat/penasehat hukum dari '.$row->nama.
                                ' yang berkantor di '.$row->alamat_kuasa.' berdasarkan surat kuasa khusus tanggal '.$this->CI->templatehelper->convertKeTglIndo($row->tgl_kuasa).
                                ' sebagai '.$sebagai.' #ke# #par#';            
                        }else{
                            $pihak_array.=' sebagai '.$sebagai.' #ke# #par# ';    
                        }
                        $i++;
                    }else{
                         $pihak_array = str_replace("#DKK#",'dan kawan kawan', $pihak_array);
                    }
                }
                if($i>1){
                    $pihak_array = str_replace(" #ke# ",' '.$this->CI->templatehelper->converToAngkaRomawi($i).'; ', $pihak_array);
                    $pihak_array = str_replace(" #par# ",' \\par ', $pihak_array);
                }else{
                    $pihak_array = str_replace(" #ke# ",'', $pihak_array);
                    $pihak_array = str_replace("#par#",'', $pihak_array);
                }
                $pihak_array = str_replace(" #DKK#",'', $pihak_array);
            }else{
                $pihak_array = "Data Pihak Tidak Ada dalam Database!!!";
            }
            return $pihak_array;
    }

    function looping_nama_pihak($pihak_ke=1){
            $dataPihak = $this->temp->get_var_pihak($pihak_ke);
            switch ($pihak_ke) {
                case '1':
                    $sebagai="#sebagai_p#";
                    break;
                case '2':
                    $sebagai="#sebagai_t#";
                    break;
                default:
                    # code...
                    break;
            }
            $i=1;
            $pihak_array='';
            foreach ($dataPihak->result() as $row) {
                if ($dataPihak->num_rows>1){
                    $no=$i++;
                    $ke= $this->CI->templatehelper->converToAngkaRomawi($no);    
                }else{
                    $no="";
                    $ke="";
                }
                $pihak_array.= $no.'. '.$this->CI->templatehelper->standradnaming($row->nama)." \\tab ".$sebagai.$ke."\\par \\tab \\tab ".$dkk.PHP_EOL;
            }
            return $pihak_array;
       
    }
}
