<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Arsip_list extends CI_Controller {
	public function __construct(){
		parent::__construct();
		if($this->session->userdata('is_logged_in')==FALSE){
			redirect('login');
		}
	}

	function index(){
		$this->session->set_userdata('asc_desc','DESC');
		$this->session->set_userdata('total_rows',-1);
		$functions = $this->nativesession->get_flash_session('function');
		$enc = $this->nativesession->get_flash_session('enc');
		$idalurperkara=0;
		if($functions == 'sort'){
			$col = $this->nativesession->get_flash_session('col');
			$keyword = $this->nativesession->get_flash_session('keyword');
			$this->sort($col,$enc,$keyword);
		}elseif($functions == 'type'){
			$this->session->set_userdata('asc_desc','DESC');
			$this->session->set_userdata('total_rows',-1);
			$this->showData($enc,$idalurperkara);
		}elseif($functions == 'page'){
			$page = $this->nativesession->get_flash_session('page');
			$keyword = $this->nativesession->get_flash_session('keyword');
			$column_sorted = $this->nativesession->get_flash_session('col');
			$this->showData($enc,$idalurperkara,$column_sorted,$page,$keyword);
		}elseif($functions == 'search'){
			$keyword ='';
			$keyword = $this->nativesession->get_flash_session('keyword');
			$this->session->set_userdata('keyword',$keyword);

			$page = $this->nativesession->get_flash_session('page');
			$this->session->set_userdata('total_rows',-1);
			$this->showData($enc,$idalurperkara,2,$page,$keyword);

		}elseif($functions == 'search_detail'){
			$keyword ='search_detail';
			$page = $this->nativesession->get_flash_session('page');
			$this->session->set_userdata('total_rows',-1);
			$where=$this->nativesession->get_flash_session('where');
			$this->nativesession->set_flash_session('where', $where);
			$this->showData($enc,$idalurperkara,2,$page, $keyword, $where);
		}else{
			$this->session->set_userdata('asc_desc','DESC');
			$this->session->set_userdata('total_rows',-1);
			$this->showData();
		}
	}

	function sort($col=null,$enc=null,$keyword=null){
		if($this->session->userdata('asc_desc')){
			if($this->session->userdata('asc_desc')=="DESC"){
				$this->session->set_userdata('asc_desc','ASC');
			}else{
				$this->session->set_userdata('asc_desc','DESC');
			}
		}else{
			$this->session->set_userdata('asc_desc','ASC');
		}
		$idalurperkara='';
		$this->showData($enc,$idalurperkara,$col,0,$keyword);
	}

	function showData($enc='',$idalurperkara='',$col=7,$start_page=0,$keyword='',$where=''){
		$asc_desc = $this->session->userdata('asc_desc');
		$this->load->model('arsip/arsip_m', 'arsip');
		if($start_page>0){
			$begin_limit = ($start_page-1)*50;
		}else{
			$begin_limit = 0;
			$start_page = 1;
		}
		if ($where==''){
			$query = $this->arsip->getArsipList($col,$asc_desc,$begin_limit,$keyword);	
		}else{
			$query = $this->arsip->getArsipList_search_detail($col,$asc_desc,$begin_limit,$where);
		}
		$data['list_arsip'] = $query;
		if($this->session->userdata('total_rows')){
			if($this->session->userdata('total_rows')==-1){
				$data['total_rows'] = $this->arsip->fecth_data_num();
				$this->session->set_userdata('total_rows',$data['total_rows']);
			}else{
				$data['total_rows'] = $this->session->userdata('total_rows');
			}
		}else{
			$data['total_rows'] = $this->arsip->fecth_data_num();
			$this->session->set_userdata('total_rows',$data['total_rows']);
		}
		
		$data['page_active'] = $begin_limit;
		$data['page_title'] = 'DAFTAR ARSIP PERKARA';
		
		$data['main_body'] = 'arsip_list/arsip_list';
		$data['enc'] = 'enc';
		
		$data['page_number'] = $start_page;
		$data['page_url'] = 'list_arsip';
		if(!empty($keyword))
			$data['keyword'] = base64_encode($this->encrypt->encode($keyword));
		else
			$data['keyword'] = $keyword;
		$data['column_sorted'] = $col;
		$this->load->vars($data);
		$this->load->view('header');
		$this->load->view('body/body');
	}
}