<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Add_perlawanan extends CI_Controller {
	function index(){
		#prevent direct access to page
		#the user should only access the page through menu
		if($this->nativesession->get_flash_session('security')==FALSE){
			redirect('main');
		}
		$sec = $this->nativesession->get_flash_session('security');

		if($this->session->userdata('is_logged_in')==FALSE){
			redirect('login');
		}

		$idalurperkara = $this->nativesession->get_flash_session('alur_perkara_id');
		if (!$this->authorization->HasRuleAddPendaftaran($idalurperkara)){
			show_404();
		}
		$idtahapan = $this->nativesession->get_flash_session('tahapan_id');
		if($idtahapan==10){
			$this->show_data($idalurperkara,$idtahapan);
		}
	}

	function show_data($idalurperkara,$idtahapan){
		$this->load->model('perkara/new_perdata','perkara');
		$data['page_title'] = 'TAMBAH - DATA PERKARA GUGATAN PERLAWANAN (DERDEN VERZET) - DALAM TAHAP PERBAIKAN';
		$data['main_body'] = 'perkara/new_perlawanan';
		$data['previous'] = $this->nativesession->get_flash_session('url_requested');
		$data['biaya'] = $this->perkara->getBiayaPerkara($idalurperkara,$idtahapan);
		$data['current_date'] = date('d/m/Y');
		$data['enc'] = base64_encode($this->encrypt->encode($idalurperkara));
		$this->load->vars($data);
		$this->load->view('header');
		$this->load->view('body/body_new');
	}

	function getFormat(){
		if(empty($_POST)){
			show_404();
		}
		$nomorperkara = $this->input->post('enc',TRUE);
		
		if(empty($nomorperkara)){
			echo json_encode(array('st'=>0,'msg'=>'Error, Nomor Perkara Tidak Ditemukans'));
			return;
		}
		
		$generate = $this->input->post('generate',TRUE);
		if(empty($generate) OR intval($generate)<1){
			echo json_encode(array('st'=>0,'msg'=>'Error, Data Tidak Valid'));
			return;
		}

		$this->load->model('perkara/new_perdata','perkara');
		$dataperkara = $this->perkara->isValidPerlawanan($nomorperkara);
		$status = FALSE;
		$msg = 'Error, Nomor Perkara Tidak Ditemukan Atau Perkara Belum Dinyatakan Putus';
		$jenis = 'Error, Klasifikasi Perkara Tidak Ditemukan';
		if($dataperkara!=''){
			if($dataperkara->num_rows>0){
				foreach ($dataperkara->result() as $row) {
					if($row->alur_perkara_id>100){
						$msg = 'Error, Perkara Pidana Tidak Dapat Didaftarkan Sebagai Perkara Perlawanan / DERDEN VERZET';
						break;
					}

					if($row->putusan_verstek=='Y'){
						$msg = 'Apakah Yang Anda Maksud Adalah VERZET? Perlawanan/VERZET Tidak dimasukan Melalui Menu ini. Silahkan Memasukan Data Perkara Verzet Pada detil perkara yang dimaksudkan melalui Menu Register Perkara.';
					}else{
						$msg = '';
					}
					$jenis = $row->jenis_perkara_nama;
					$idperkara = $row->perkara_id;
					$idalurperkara = $row->alur_perkara_id;
					$status = TRUE;
					$idjenisperkara = base64_encode($this->encrypt->encode($row->jenis_perkara_id));
				}
			}
		}else{
			echo json_encode(array('st'=>0,'msg'=>'Perkara Yang diMohonkan Belum dinyatakan Putus Atau Tidak Ada'));
			return;
		}
		$nomorperlawanan = '';
		if($generate==1 AND $status==TRUE){
			$tmp = explode('/', $nomorperkara);
			$replacestring = $tmp[1];
			$nomorperlawanan = str_replace($replacestring,'Pdt.Plw',$nomorperkara);
		}
		

		if($status==FALSE){
			echo json_encode(array('st'=>0,'msg'=>$msg));
			return;
		}else{
			echo json_encode(array('st'=>1,'msg'=>$msg,'nomorperkara'=>$nomorperlawanan,'jenis'=>$jenis,'enc_klasifikasi'=>$idjenisperkara));
			return;
		}
	}


	function validateInput(){
		if($this->session->userdata('is_logged_in')==FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Anda Belum Login, Silahkan Login Terlebih Dahulu.'));
			return;
		}
		if(empty($_POST)){
			show_404();
		}
		$idalurperkara = $this->encrypt->decode(base64_decode($this->input->post('enc',TRUE)));
		if(!is_numeric($idalurperkara) AND $idalurperkara<0){
			echo json_encode(array('st'=>0,'msg'=>'Data Tidak Valid.'));
			return;
		}
		if (!$this->authorization->HasRuleAddPendaftaran($idalurperkara)){
			echo json_encode(array('st'=>0,'msg'=>'Anda Tidak Punya Otoritas Mendaftarkan Perkara.'));
			return;
		}

		$klas_perkara = $this->encrypt->decode(base64_decode($this->input->post('enc_klasifikasi',TRUE)));
		if(!is_numeric($klas_perkara) AND $klas_perkara<0){
			echo json_encode(array('st'=>0,'msg'=>'Data Tidak Valid.'));
			return;
		}

		$this->form_validation->set_rules('tgl_pendaftaran', 'Tanggal Pendaftaran', 'trim|required|xss_clean|exact_length[10]');
		#$this->form_validation->set_rules('klas_perkara', 'Klasifikasi Perkara', 'trim|required|numeric|greater_than[0]|xss_clean');
		#$this->form_validation->set_rules('no_urut', 'Nomor Urut', 'trim|required|numeric|xss_clean');
		
		$this->form_validation->set_rules('generate', 'Generate Nomor Perkara', 'trim|required|numeric|xss_clean');
		$generate = $this->input->post('generate',TRUE);
		if($generate==1){
			$this->form_validation->set_rules('no_perkara_perlawanan', 'Nomor Perkara', 'trim|required|xss_clean|is_unique[perkara.nomor_perkara]');
		}elseif ($generate==0) {
			$this->form_validation->set_rules('no_urutan_manual', 'Nomor Urut Register', 'trim|required|numeric|xss_clean');
			$this->form_validation->set_rules('no_perkara_manual', 'Nomor Perkara', 'trim|required|xss_clean');
		}else{
			show_404();
		}

		$this->form_validation->set_rules('prodeo', 'Prodeo', 'trim|required|numeric|xss_clean');
		$prodeo = $this->input->post('prodeo',TRUE);
		if($prodeo==1){
			$this->form_validation->set_rules('jenis_prodeo', 'Jenis Prodeo', 'trim|required|numeric|xss_clean');
			$jenis_prodeo = $this->input->post('jenis_prodeo',TRUE);
			if($jenis_prodeo!=2 OR $jenis_prodeo!=3){
				echo json_encode(array('st'=>0,'msg'=>'Silahkan Pilih Jenis Prodeo'));
				return;
			}
			$id_pembiayaan = $jenis_prodeo;
		}else{
			$id_pembiayaan = 1;
		}

		$this->form_validation->set_rules('b_panjar', 'Biaya Panjar Perkara', 'trim|required|xss_clean');
		$this->form_validation->set_rules('b_pendaftaran', 'Biaya Pendaftaran Perkara', 'trim|required|xss_clean');
		$this->form_validation->set_rules('b_atk', 'Biaya Alat Tulis Kantor', 'trim|required|xss_clean');

		if ($this->form_validation->run() === FALSE){
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Berhasil'.validation_errors()));
		}else{
			$this->load->model('perkara/new_perdata','perkara');
			$date = $this->input->post('tgl_pendaftaran',TRUE);
			$tmp = explode("/", $date);
			$tahun = $tmp[2];
			$bulan = $tmp[1];
			$noUrutReg= $this->perkara->getNomorUrutRegister($idalurperkara,$tahun.'-'.$bulan);

			#$noUrutReg = $this->input->post('no_urut',TRUE);
			
			$idalurperkara = $this->encrypt->decode(base64_decode($this->input->post('enc',TRUE)));
			$isNoUrutRegisterExists = $this->perkara->isNomorUrutRegisterExists($this->input->post('tgl_pendaftaran',TRUE),$idalurperkara,$noUrutReg);
			if($isNoUrutRegisterExists==TRUE OR $isNoUrutRegisterExists==-2){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Nomor Urut Register Sudah Ada'.$isNoUrutRegisterExists));
				return;
			}

			$tgl_pendaftaran = $this->tanggalhelper->convertToMysqlDate($this->input->post('tgl_pendaftaran',TRUE));
			$tglPendaftaran = $this->tanggalhelper->convertToMysqlDate($this->input->post('tgl_pendaftaran',TRUE));
			if($tglPendaftaran==false){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Format Tanggal Tidak Benar. Format tanggal hari/bulan/tahun. Contoh 20/01/2015.'));
				return;
			}
			
			$curr_date = date('Y-m-d');
			$todayDate = date('d/m/Y');

			$selisih = $this->tanggalhelper->getSelisihHari($tgl_pendaftaran,$curr_date);
			if($selisih<0){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Pendaftaran Tidak Boleh Melebihi Hari Ini. Hari ini Tanggal '.$todayDate));
				return;
			}
			if($generate==1){
				$noPerkara = $this->input->post('no_perkara_perlawanan',TRUE);
			}elseif ($generate==0) {
				$noPerkara =$this->input->post('no_urutan_manual',TRUE).$this->input->post('no_perkara_manual',TRUE);
			}


			$tmp = explode("/", $noPerkara);
			if(count($tmp)!=4){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Please Refresh Your Browser'));
				return;
			}
			
			$nomor_urut_perkara = $tmp[0];
			$tmpIndexs = $tmp[0];
			if($tmpIndexs<10){
				$tmpIndexs = '000'.$tmpIndexs;
			}elseif($tmpIndexs>9 and $tmpIndexs <1000){
				$tmpIndexs = '00'.$tmpIndexs;
			}
			$nomorIndexs = $tmp[3].'_'.$tmp[2].'_'.$tmp[1].'_'.$tmpIndexs;
			$isPerkaraExists = $this->perkara->isNomorPerkaraExist($noPerkara);
			if($isPerkaraExists===TRUE){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Nomor Perkara Sudah Ada Didalam System'));
				return;
			}
			$no_ref = $this->input->post('no_ref',TRUE);
			$b_panjar = str_replace('.','',$this->input->post('b_panjar',TRUE));
			$b_pendaftaran = str_replace('.','',$this->input->post('b_pendaftaran',TRUE));
			$b_atk = str_replace('.','',$this->input->post('b_atk',TRUE));
			if($b_panjar<($b_pendaftaran+$b_atk)){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Biaya Panjar Tidak Boleh Kurang dari Biaya Pendaftaran ditambah Biaya ATK'));
				return;
			}elseif ($b_panjar==0) {
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Biaya Panjar Tidak Boleh Kosong'));
				return;
			}

			#masukan ke db
			#
			$jenisPerkara = $this->perkara->getJenisPerkaraNama($klas_perkara);
			if($jenisPerkara->num_rows>0){
				foreach ($jenisPerkara->result() as $row) {
					$kode = $row->kode;
					$jenisPerkaraNama = $row->nama;
					$jenisPerkaraText = $row->nama_lengkap;
				}
			}else{
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Please Refresh Your Browser'));
				return;
			}
			$dayName = $this->tanggalhelper->getDayName($tgl_pendaftaran);
			if($dayName=="Sunday" OR $dayName=="Saturday"){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Dapat memilih diluar hari kerja (Sabtu - Minggu).'));
				return;
			}

			

			$data_perkara = array(
				'nomor_perkara' => $noPerkara,
				'alur_perkara_id' => $idalurperkara,
				'tanggal_pendaftaran' => $tglPendaftaran,
				'jenis_perkara_id' => $klas_perkara,
				'jenis_perkara_kode' => $kode,
				'jenis_perkara_nama' => $jenisPerkaraNama,
				'jenis_perkara_text' => $jenisPerkaraText,
				'nomor_urut_register' => $noUrutReg,
				'nomor_urut_perkara' => $nomor_urut_perkara,
				'nomor_indeks' => $nomorIndexs,
				'tahapan_terakhir_id' => 10,
				'tahapan_terakhir_text' => 'Pendaftaran',
				'proses_terakhir_id' => 10,
				'proses_terakhir_text' => 'Pendaftaran Perkara',
				'diinput_oleh' => $this->session->userdata('username'),
				'diinput_tanggal' => date("Y-m-d h:i:s",time())
			);
			$data_keuangan_perkara = array(
				array(
					'id_pembiayaan' => $id_pembiayaan,
					'tahapan_id' => 10,
					'kategori_id' => 1,
					'jenis_biaya_id' => 1,
					'urutan' => 1,
					'jenis_transaksi' => 1,
					'tanggal_transaksi' => $tglPendaftaran,
					'uraian' => 'Panjar Biaya Perkara',
					'jumlah' => $b_panjar,
					'diinput_oleh' => $this->session->userdata('username'),
					'diinput_tanggal' => date("Y-m-d h:i:s",time())
				),
				array(
					'id_pembiayaan' => $id_pembiayaan,
					'tahapan_id' => 10,
					'kategori_id' => 11,
					'jenis_biaya_id' => 61,
					'urutan' => 2,
					'jenis_transaksi' => -1,
					'tanggal_transaksi' => $tglPendaftaran,
					'uraian' => 'Biaya Pendaftaran/PNBP',
					'jumlah' => $b_pendaftaran,
					'diinput_oleh' => $this->session->userdata('username'),
					'diinput_tanggal' => date("Y-m-d h:i:s",time())
				),
				array(
					'id_pembiayaan' => $id_pembiayaan,
					'tahapan_id' => 10,
					'kategori_id' => 12,
					'jenis_biaya_id' => 155,
					'urutan' => 3,
					'jenis_transaksi' => -1,
					'tanggal_transaksi' => $tglPendaftaran,
					'uraian' => 'Biaya Pemberkasan/ATK',
					'jumlah' => $b_atk,
					'diinput_oleh' => $this->session->userdata('username'),
					'diinput_tanggal' => date("Y-m-d h:i:s",time())
				)
			);
			if($this->perkara->add_data($data_perkara,$data_keuangan_perkara)){
				echo json_encode(array('st'=>1,'msg'=>'Berhasil Disimpan'));
			}else{
				echo json_encode(array('st'=>0,'msg'=>'Database Error, Pendaftaran Perkara Tidak Berhasil'));
			}	
		}
	}
}