<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Add_ijin_cerai_c extends CI_Controller {
	public function __construct(){
		parent::__construct();
		if($this->session->userdata('is_logged_in')==FALSE){
			redirect('login');
		}
	}

	function show_form(){
		$segment=$this->uri->segment_array();
		$enc=$segment[3];
		$data['pihak']=$segment[4];
		$idpihak = $segment[5];
		$perkara_id=$this->encrypt->decode(base64_decode($enc));
		if(!is_numeric($perkara_id)){
			show_404();
		}
		$pihak_id=$this->encrypt->decode(base64_decode($idpihak));
		if(!is_numeric($pihak_id)){
			show_404();
		}
		$this->load->model('perkara/info_perkara_agama', 'perkara');
		$info_ijin_cerai=$this->perkara->get_info_ijin_cerai($perkara_id,$pihak_id)->row();
		$info_pihak1=$this->perkara->getInfoPihakPertama($perkara_id)->row();
		$info_pihak2=$this->perkara->getInfoPihakKedua($perkara_id)->row();
		if (empty($info_ijin_cerai)){
			$data['status_id']=0;
			$data['tgl_surat']=date('d-m-Y');
			$data['nomor_surat']='';
			$data['nama_pejabat']='';
			$data['jabatan']='';
			$data['act']='add';
		}else{
			$data['status_id']=$info_ijin_cerai->status;
			$data['tgl_surat']=$info_ijin_cerai->tanggal_surat;
			$data['nomor_surat']=$info_ijin_cerai->nomor_surat;
			$data['nama_pejabat']=$info_ijin_cerai->nama_pejabat;
			$data['jabatan']=$info_ijin_cerai->jabatan_pejabat;
			$data['act']='edit';
		}
		if($data['pihak']==1)		
			$data['pihak1_text']=$info_pihak1->nama;
		elseif($data['pihak']==2)
			$data['pihak1_text']=$info_pihak2->nama;
		$data['enc']=$enc;
		$data['perkara_id']=$perkara_id;
		$data['today']=date('d-m-Y');
		$this->load->view('perkara_tab/ijin_cerai/form_ijin_cerai_v', $data);
	}

	function validateInputAddIjinCerai(){
		if(empty($_POST)){
			show_404();
		}
		$act=$this->input->post('act',true);
		$status_id=$this->input->post('status_id',true);
		$this->form_validation->set_rules('status_id', 'Status', 'trim|required|xss_clean');
		if ($status_id==1){
			$this->form_validation->set_rules('tgl_surat', 'Tanggal Surat', 'trim|required|exact_length[10]|xss_clean');
			$this->form_validation->set_rules('nomor_surat', 'No Surat', 'trim|required|xss_clean|max_length[30]');
			$this->form_validation->set_rules('nama_pejabat', 'Nama Pejabat', 'trim|required|xss_clean|max_length[50]');
			$this->form_validation->set_rules('jabatan', 'Jabatan Pejabat', 'trim|required|xss_clean|max_length[50]');
		}
		if ($this->form_validation->run() === FALSE){
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Berhasil'.validation_errors()));
			return;
		}else{
			$data['status']=$status_id;
			$enc=$this->input->post('enc',true);
			$pihakke=$this->input->post('pihak',true);
			$perkara_id=$this->encrypt->decode(base64_decode($enc));
			if(!is_numeric($perkara_id)){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Berhasil'));
				return;
			}
		
				$data['tanggal_surat']=$this->tanggalhelper->convertToMysqlDate($this->input->post('tgl_surat',true));
				$data['nomor_surat']=$this->input->post('nomor_surat',true);
				$data['nama_pejabat']=$this->input->post('nama_pejabat',true);
				$data['jabatan_pejabat']=$this->input->post('jabatan',true);
			
			$this->load->model('perkara/info_perkara_agama', 'perkara');
			$info_pihak1=$this->perkara->getInfoPihakPertama($perkara_id)->row();
			$info_pihak2=$this->perkara->getInfoPihakKedua($perkara_id)->row();
			if($pihakke==1)
				$data['pihak_id']=$info_pihak1->pihak_id;
			elseif($pihakke==2)
				$data['pihak_id']=$info_pihak2->pihak_id;
			$this->load->model('perkara/ijin_cerai_m', 'cerai');
			switch ($act) {
				case 'add':
					$data['perkara_id'] = $perkara_id;
					$data['diinput_oleh'] = $this->session->userdata('username');
					$data['diinput_tanggal'] = date("Y-m-d h:i:s",time());
					if($this->cerai->add_ijin_cerai($data)){
						echo json_encode(array('st'=>1,'msg'=>'Data Berhasil Disimpan'));
					}
					# code...
				break;
				case 'edit':
					$data['diperbaharui_oleh'] = $this->session->userdata('username');
					$data['diperbaharui_tanggal'] = date("Y-m-d h:i:s",time());
					if($this->cerai->edit_ijin_cerai($data['pihak_id'],$data)){
						echo json_encode(array('st'=>1,'msg'=>'Data Berhasil Disimpan'));
					}
					# code...
				break;
			}
		}
	}

}