<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Add_eksekusi_hak_tanggungan extends CI_Controller {
	function index(){
		#prevent direct access to page
		#the user should only access the page through menu
		if($this->nativesession->is_flash_session('security')===FALSE){
			redirect('main');
		}
		$sec = $this->nativesession->get_flash_session('security');

		if($this->session->userdata('is_logged_in')===FALSE){
			redirect('login');
		}

		
		$idalurperkara=0;
		$idtahapan = $this->nativesession->get_flash_session('tahapan_id');
		$this->show_data($idalurperkara,$idtahapan);
	}
	function show_data($idalurperkara,$idtahapan){
		$data['page_title'] = 'TAMBAH PERMOHONAN EKSEKUSI HAK TANGGUNGAN ';
		$data['main_body'] = 'perkara/new_eksekusi_hak_tanggungan';
		$data['previous'] = $this->nativesession->get_flash_session('url_requested');
		$data['tgl_sekarang'] = date('d/m/Y');
		$data['idalurperkara']=base64_encode($this->encrypt->encode($idalurperkara));
		$data['idtahapan']=base64_encode($this->encrypt->encode($idtahapan));
		
		$this->load->model('perkara/new_eksekusi_ht','eksekusi');
		$biaya_pendaftaran = $this->eksekusi->get_biaya_pendaftaran();

		$no_urut_eks = $this->eksekusi->getNomorUrutRegisterEks(date("Y-m"));
		$no_urut_eksht = $this->eksekusi->getNomorUrutRegisterEksHt(date("Y-m"));

		if($no_urut_eks>$no_urut_eksht){
			$data['no_urut']=$no_urut_eks;
		}else{
			$data['no_urut']=$no_urut_eksht;
		}

		$no_perkara_eks = $this->eksekusi->getNomorPerkaraEks(date("Y"));
		$no_perkara_eksht = $this->eksekusi->getNomorPerkaraEksHt(date("Y"));

		if($no_perkara_eks>$no_perkara_eksht){
			$no_urut_perkara=$no_perkara_eks;
		}else{
			$no_urut_perkara=$no_perkara_eksht;
		}

		$format_no_eksekusi='Pdt.Eks';
		$tahun_perkara=date('Y');		
		$jenis_pengadilan = $this->session->userdata('jenis_pengadilan');
		$kode_pengadilan = $this->eksekusi->getKodePN();
		if($jenis_pengadilan==1){
			$kode_pengadilan='PN '.$kode_pengadilan;
		}else if($jenis_pengadilan==3){
			$kode_pengadilan='PTUN.'.$kode_pengadilan;
		}else if($jenis_pengadilan==4){
			$kode_pengadilan=$kode_pengadilan;
		}

		$data['no_urut_perkara']=$no_urut_perkara;
		$data['no_perkara_eksekusi_auto']=$no_urut_perkara.'/'.$format_no_eksekusi.'/'.$tahun_perkara.'/'.$kode_pengadilan;
		$data['no_perkara_eksekusi_man']='/'.$format_no_eksekusi.'/'.$tahun_perkara.'/'.$kode_pengadilan;

		if($biaya_pendaftaran->num_rows>0){
			$data['pendaftaran'] = $biaya_pendaftaran->row()->jumlah;
		}

		$biaya_atk = $this->eksekusi->get_biaya_atk();
		if($biaya_atk->num_rows>0){
			$data['atk'] = $biaya_atk->row()->jumlah;
		}

		$this->load->vars($data);
		$this->load->view('header');
		$this->load->view('body/body_new');
	}


	function get_nomor_perkara_eksekusi(){
		$is_generate = $this->input->post('val',TRUE);
		$this->load->model('perkara/new_eksekusi_ht','eksekusi');

		$no_urut_eks = $this->eksekusi->getNomorUrutRegisterEks(date("Y-m"));
		$no_urut_eksht = $this->eksekusi->getNomorUrutRegisterEksHt(date("Y-m"));

		if($no_urut_eks>$no_urut_eksht){
			$no_urut_reg_eks=$no_urut_eks;
		}else{
			$no_urut_reg_eks=$no_urut_eksht;
		}

		$no_perkara_eks = $this->eksekusi->getNomorPerkaraEks(date("Y"));
		$no_perkara_eksht = $this->eksekusi->getNomorPerkaraEksHt(date("Y"));

		if($no_perkara_eks>$no_perkara_eksht){
			$no_urut_perkara=$no_perkara_eks;
		}else{
			$no_urut_perkara=$no_perkara_eksht;
		}

		$format_no_eksekusi='Pdt.Eks';
		$tahun_perkara=date('Y');		
		$jenis_pengadilan = $this->session->userdata('jenis_pengadilan');
		$kode_pengadilan = $this->eksekusi->getKodePN();
		if($jenis_pengadilan==1){
			$kode_pengadilan='PN '.$kode_pengadilan;
		}else if($jenis_pengadilan==4){
			$kode_pengadilan='PA '.$kode_pengadilan;
		}

		
		if($is_generate==1){
			$no_eksekusi = $no_perkara_eksekusi_auto=$no_urut_perkara.'/'.$format_no_eksekusi.'/'.$tahun_perkara.'/'.$kode_pengadilan;
			$no_urut_reg = $no_urut_reg_eks;
			echo json_encode(array('st'=>1,'msg'=>$no_eksekusi,'nourutregister'=>$no_urut_reg));
		}else{
			echo json_encode(array('st'=>0,'msg'=>"Error, Please refresh your Page",'nourutregister'=>"Error, Please refresh your Page"));
		}
	
	}


	function show_cari_eksekusi(){
		if(empty($_POST)){ show_404(); }

		if($this->session->userdata('is_logged_in')===FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Anda Belum Login, Silahkan Login Terlebih Dahulu'));
			return;
		}

		$nomor_perkara = trim($this->input->post('val',FALSE));
		if(empty($nomor_perkara)){
			echo json_encode(array('st'=>0,'msg'=>'Silahkan Isikan Nomor Perkara Terlebih Dahulu'));
			return;
		}

		$this->load->model('perkara/new_eksekusi','eksekusi');

		$row_perkara =  $this->eksekusi->getPerkara($nomor_perkara);
		if($row_perkara->num_rows==1){
			$perkara_id = $row_perkara->row()->perkara_id;
			$alurperkaraid = $row_perkara->row()->alur_perkara_id;
		}elseif($row_perkara->num_rows>1){
			echo json_encode(array('st'=>0,'msg'=>'Error; Ditemukan Lebih dari satu nomor perkara '.$nomorPerkara.' yang anda masukan'));
			return;
		}else{
			echo json_encode(array('st'=>0,'msg'=>'Error Nomor Perkara Tidak Ditemukan'));
			return;
		}
		$putusan_pn = $this->eksekusi->data_putusan_pn($perkara_id);


		if($putusan_pn->num_rows>0){
			$tgl_putusan_pn = $this->tanggalhelper->convertToInputDate($putusan_pn->row()->tanggal_putusan);
			$amar_pn = $putusan_pn->row()->amar_putusan;
		}else{
			echo json_encode(array('st'=>0,'msg'=>'Perkara Belum Tersebut Putus'));
			return;
		}


		$putusan_banding = $this->eksekusi->data_banding($perkara_id);
		if($putusan_banding->num_rows>0){
			$nomor_perkara_banding = $putusan_banding->row()->nomor_perkara_banding;
			$tgl_putusan_banding = $this->tanggalhelper->convertToInputDate($putusan_banding->row()->putusan_banding);
			$amar_banding = $putusan_banding->row()->amar_putusan_banding;
			if(!empty($tgl_putusan_banding)){
			}
		} else {
			$nomor_perkara_banding = "";
			$tgl_putusan_banding = "";
			$amar_banding="";
		}
				
		$putusan_kasasi = $this->eksekusi->data_kasasi($perkara_id);
		
		if($putusan_kasasi->num_rows>0){
			$nomor_perkara_kasasi = $putusan_kasasi->row()->nomor_perkara_kasasi;
			$tgl_putusan_kasasi = $this->tanggalhelper->convertToInputDate($putusan_kasasi->row()->putusan_kasasi);
			$amar_kasasi = $putusan_kasasi->row()->amar_putusan_kasasi;
			if(!empty($tgl_putusan_kasasi)){
			}
		} else {
			$nomor_perkara_kasasi = "";
			$tgl_putusan_kasasi = "";
			$amar_kasasi="";
		}


		$putusan_pk = $this->eksekusi->data_pk($perkara_id);
		if($putusan_pk->num_rows>0){
			$nomor_perkara_pk = $putusan_pk->row()->nomor_perkara_pk;
			$tgl_putusan_pk =$this->tanggalhelper->convertToInputDate($putusan_pk->row()->putusan_pk);
			$amar_pk = $putusan_pk->row()->amar_putusan_pk;
			if(!empty($tgl_putusan_pk)){
			}
		} else {
			$nomor_perkara_pk = "";
			$tgl_putusan_pk = "";
			$amar_pk="";
		}

		$penggugatHtml ='<td style="padding:0px;padding-left:5px;" id="td_penggugat">';
		$parapenggugat = $this->eksekusi->data_penggugat($perkara_id);
		$y=1;
		if($parapenggugat->num_rows>0){
			foreach ($parapenggugat->result() as $row) {
				$penggugatHtml .=' <input class="c_penggugat" type="checkbox" value="'.$row->pihak_id.';'.$row->nama.'" id="penggugat'.$y.'" name="penggugat[]">'.$row->nama;
				$y++;
			}
		}
		$penggugatHtml .='</td>';

		$tergugatHtml ='<td style="padding:0px;padding-left:5px;" id="td_tergugat">';
		$paratergugat = $this->eksekusi->data_tergugat($perkara_id);
		$y=1;
		if($paratergugat->num_rows>0){
			foreach ($paratergugat->result() as $row) {
				$tergugatHtml .=' <input class="c_tergugat" type="checkbox" value="'.$row->pihak_id.';'.$row->nama.'" id="tergugat'.$y.'" name="tergugat[]">'.$row->nama.'<br>';
				$y++;
			}
		}

		$tergugatHtml .='</td>';
		
		$amarpnHtml ='<td style="padding:0px;padding-left:5px;" id="td_amar">';
		$amarpnHtml .='<textarea rows="8" cols="80" id="amar_yg_dieksekusi" name="amar_yg_dieksekusi">'.$amar_pn.'</textarea>';
		$amarpnHtml .='</td>';

		$amarbandingHtml ='<td style="padding:0px;padding-left:5px;" id="td_amar">';
		$amarbandingHtml .='<textarea rows="8" cols="80" id="amar_yg_dieksekusi" name="amar_yg_dieksekusi">'.$amar_banding.'</textarea>';
		$amarbandingHtml .='</td>';	
		
		$amarkasasiHtml ='<td style="padding:0px;padding-left:5px;" id="td_amar">';
		$amarkasasiHtml .='<textarea rows="8" cols="80" id="amar_yg_dieksekusi" name="amar_yg_dieksekusi">'.$amar_kasasi.'</textarea>';
		$amarkasasiHtml .='</td>';

		$amarpkHtml ='<td style="padding:0px;padding-left:5px;" id="td_amar">';
		$amarpkHtml .='<textarea rows="8" cols="80" id="amar_yg_dieksekusi" name="amar_yg_dieksekusi">'.$amar_pk.'</textarea>';
		$amarpkHtml .='</td>';


		echo json_encode(array(
			'st'=>1,
			'msg'=>'Perkara ditemukan ',
			'tgl_putusan_pn'=>$tgl_putusan_pn,
			'nomor_perkara_banding'=>$nomor_perkara_banding,
			'tgl_putusan_banding'=>$tgl_putusan_banding,
			'nomor_perkara_kasasi'=>$nomor_perkara_kasasi,
			'tgl_putusan_kasasi'=>$tgl_putusan_kasasi,
			'nomor_perkara_pk'=>$nomor_perkara_pk,
			'tgl_putusan_pk'=>$tgl_putusan_pk,
			'perkara_id'=>base64_encode($this->encrypt->encode($perkara_id)),
			'alur_perkara_id'=>base64_encode($this->encrypt->encode($alurperkaraid)),	
			'amarpnHtml' => $amarpnHtml,
			'amarbandingHtml' => $amarbandingHtml,
			'amarkasasiHtml' => $amarkasasiHtml,
			'amarpkHtml' => $amarpkHtml,
			'penggugatHtml' => $penggugatHtml,
			'tergugatHtml' => $tergugatHtml,			
		));
		return;
		}

	function validateInput(){
		if($this->session->userdata('is_logged_in')==FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Anda Belum Login, Silahkan Login Terlebih Dahulu.'));
			return;
		}
		if(empty($_POST)){
			
			show_404();
		}


		$this->form_validation->set_rules('tgl_permohonan_ht', 'Tanggal Permohonan Eksekusi', 'trim|required|xss_clean|exact_length[10]');		
		$this->form_validation->set_rules('jenis_ht', 'Jenis Eksekusi Hak Tanggungan', 'trim|required|xss_clean');
		$this->form_validation->set_rules('tgl_sertifikat', 'Tanggal Sertifikat', 'trim|required|xss_clean|exact_length[10]');
		$this->form_validation->set_rules('nomor_sertifikat', 'Nomor Sertifikat', 'trim|required|xss_clean');

		$this->form_validation->set_rules('panjar', 'Biaya Panjar Perkara', 'trim|required|xss_clean');
		$this->form_validation->set_rules('pendaftaran', 'Biaya Pendaftaran Perkara', 'trim|required|xss_clean');
		$this->form_validation->set_rules('atk', 'Biaya Alat Tulis Kantor', 'trim|required|xss_clean');

		$this->form_validation->set_rules('no_urut_eksekusi', 'Nomor Urut Register Eksekusi', 'trim|required|xss_clean');
		$this->form_validation->set_rules('no_perkara_eksekusi_auto', 'Nomor Eksekusi', 'trim|required|xss_clean');
		$this->form_validation->set_rules('no_urut_perkara_eks_manual', 'Nomor Perkara Manual Eksekusi', 'trim|required|xss_clean');		
		$this->form_validation->set_rules('no_perkara_eksekusi_man', 'Nomor Eksekusi', 'trim|required|xss_clean');

		$is_generate=$this->input->post('generate',TRUE);
		$no_urut_reg_eksekusi=$this->input->post('no_urut_eksekusi',TRUE);
		$no_perkara_eksekusi_auto=$this->input->post('no_perkara_eksekusi_auto',TRUE);
		$no_urut_perkara_eks_manual=$this->input->post('no_urut_perkara_eks_manual',TRUE);
		$no_perkara_eksekusi_man=$this->input->post('no_perkara_eksekusi_man',TRUE);

		$this->load->model('perkara/new_eksekusi_ht','eksekusi');

		$tgl_permohonan_eks=substr($this->tanggalhelper->convertToMysqlDate($this->input->post('tgl_permohonan_ht',TRUE)),0,7);

		$cek_no_urut_eks = $this->eksekusi->cek_nomor_urut_eks($no_urut_reg_eksekusi,$tgl_permohonan_eks);
		$cek_no_urut_eksht = $this->eksekusi->cek_nomor_urut_eksht($no_urut_reg_eksekusi,$tgl_permohonan_eks);

		if($cek_no_urut_eks==1 || $cek_no_urut_eksht==1){
			echo json_encode(array('st'=>0,'msg'=>'Nomor Urut pada bulan permohonan ini sudah ada'));
			return;
		}



		if($is_generate==1){
			$no_perkara_eksekusi=$no_perkara_eksekusi_auto;
		}else if($is_generate==0){
			$no_perkara_eksekusi=$no_urut_perkara_eks_manual.''.$no_perkara_eksekusi_man;
		}

		$cek_nomor_perkara_eks = $this->eksekusi->cek_nomor_perkara_eks($no_perkara_eksekusi);
		$cek_nomor_perkara_eksht = $this->eksekusi->cek_nomor_perkara_eksht($no_perkara_eksekusi);

		if($cek_nomor_perkara_eks==1 || $cek_nomor_perkara_eksht==1){
			echo json_encode(array('st'=>0,'msg'=>'Nomor Register Eksekusi :'.$no_perkara_eksekusi.' sudah ada dalam register'));
			return;
		}



		if ($this->form_validation->run() === FALSE){
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Berhasil'.validation_errors()));
		}else{

				$this->load->model('jurnal/jurnal_ht','jurnal');
				$ht_id='';
				$maxid=$this->jurnal->maxid_perkara_eksekusi_ht();
				foreach ($maxid->result() as $row) {
						$maxid_perkara_eksekusi_ht=$row->maxid;
				}
				if(empty($maxid_perkara_eksekusi_ht)){
					$ht_id=1;
				}else{
					$ht_id=$maxid_perkara_eksekusi_ht;	
				}
				

				$idalurperkara = $this->encrypt->decode(base64_decode($this->input->post('alurperkaraid',TRUE)));
				if(!empty($idalurperkara)){
					echo json_encode(array('st'=>0,'msg'=>'Something Bad Happened, Please Refresh Your Browser.'));
					return;
				}

				$jenis_ht=$this->input->post('jenis_ht',TRUE);
				if($jenis_ht==1){
					$jenis_ht_text='Hak Tanggungan';
				}else if($jenis_ht==2){
					$jenis_ht_text='Hipotek';
				}else if($jenis_ht==3){
					$jenis_ht_text='Fidusia';
				}else if($jenis_ht==4){
					$jenis_ht_text='Lelang';
				}
					

				$data = array(
						'ht_id' => $ht_id,
						'alur_perkara_id' => $idalurperkara,
						'permohonan_eksekusi' => $this->tanggalhelper->convertToMysqlDate($this->input->post('tgl_permohonan_ht',TRUE)),						
						//'eksekusi_nomor_perkara' => $this->input->post('nomor_perkara_ht',TRUE),
						'jenis_ht_id' => $jenis_ht,
						'jenis_ht_text' => $jenis_ht_text,
						'tgl_sertifikat' => $this->tanggalhelper->convertToMysqlDate($this->input->post('tgl_sertifikat',TRUE)),						
						'no_sertifikat' => $this->input->post('nomor_sertifikat',TRUE),
						'nomor_urut_perkara_eksekusi' => $no_urut_reg_eksekusi,
						'eksekusi_nomor_perkara' => $no_perkara_eksekusi,

						'diinput_oleh' => $this->session->userdata('username'),
						'diinput_tanggal' => date("Y-m-d h:i:s",time())
					);			




			$data_biaya = '';
			if($idalurperkara<100){
			$panjar = str_replace('.','',$this->input->post('panjar',TRUE));
			$pendaftaran = str_replace('.','',$this->input->post('pendaftaran',TRUE));
			$atk = str_replace('.','',$this->input->post('atk',TRUE));
			if($panjar<($pendaftaran+$atk)){
					echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Biaya Panjar Tidak Boleh Kurang dari Biaya Pendaftaran ditambah Biaya ATK'));
					return;
				}elseif ($panjar==0) {
					echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Biaya Panjar Tidak Boleh Kosong'));
					return;
				}
				$data_biaya = array(
					array(
						
						'id_pembiayaan' => 1,
						'ht_id' => $ht_id,
						'tahapan_id' => 51,
						'kategori_id' => 1,
						'jenis_biaya_id' => 6,
						'urutan' => 1,
						'jenis_transaksi' => 1,
						'tanggal_transaksi' => $this->tanggalhelper->convertToMysqlDate($this->input->post('tgl_permohonan_ht',TRUE)),						
						'uraian' => 'Panjar Biaya Eksekusi',
						'jumlah' => $panjar,
						'diinput_oleh' => $this->session->userdata('username'),
						'diinput_tanggal' => date("Y-m-d h:i:s",time())
					),
					array(
						
						'id_pembiayaan' => 1,
						'ht_id' => $ht_id,
						'tahapan_id' => 51,
						'kategori_id' => 11,
						'jenis_biaya_id' => 64,
						'urutan' => 2,
						'jenis_transaksi' => -1,
						'tanggal_transaksi' => $this->tanggalhelper->convertToMysqlDate($this->input->post('tgl_permohonan_ht',TRUE)),						
						'uraian' => 'Biaya Pendaftaran Eksekusi',
						'jumlah' => $pendaftaran,
						'diinput_oleh' => $this->session->userdata('username'),
						'diinput_tanggal' => date("Y-m-d h:i:s",time())
					),
					array(
						
						'id_pembiayaan' => 1,
						'ht_id' => $ht_id,
						'tahapan_id' => 51,
						'kategori_id' => 12,
						'jenis_biaya_id' => 200,
						'urutan' => 3,
						'jenis_transaksi' => -1,
						'tanggal_transaksi' => $this->tanggalhelper->convertToMysqlDate($this->input->post('tgl_permohonan_ht',TRUE)),						
						'uraian' => 'Biaya ATK/Proses',
						'jumlah' => $atk,
						'diinput_oleh' => $this->session->userdata('username'),
						'diinput_tanggal' => date("Y-m-d h:i:s",time())
					)
				);
			}

	
			$this->load->model('perkara/new_eksekusi_ht','eksekusi');
			$result = $this->eksekusi->add_perkara_eksekusi($data);
			//$result = $this->eksekusi->add_perkara_eksekusi_detil($datapihak);
			$result = $this->eksekusi->add_perkara_biaya($data_biaya);

				if($result===FALSE){
					echo json_encode(array('st'=>0,'msg'=>'GAGAL Menyimpan'));
					return;
				}else{
					echo json_encode(array('st'=>1,'msg'=>'Berhasil Menyimpan'));
					return;
				}

		}

	}

	function validateInputEdit(){
		if($this->session->userdata('is_logged_in')==FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Anda Belum Login, Silahkan Login Terlebih Dahulu.'));
			return;
		}
		if(empty($_POST)){
			
			show_404();
		}

		$idperkara = $this->encrypt->decode(base64_decode($this->input->post('idperkara',TRUE)));
		if(!is_numeric($idperkara) OR intval($idperkara)<0){
			echo json_encode(array('st'=>0,'msg'=>'Perkara Tidak Ditemukan.'));
			return;
		}

		$idalurperkara = $this->encrypt->decode(base64_decode($this->input->post('alurperkaraid',TRUE)));
		if(!is_numeric($idalurperkara) OR intval($idalurperkara)<0){
			echo json_encode(array('st'=>0,'msg'=>'Something Bad Happened, Please Refresh Your Browser.'));
			return;
		}


		$this->form_validation->set_rules('nomor_perkara_pn', 'Nomor Perkara PN', 'trim|required|xss_clean');
		$this->form_validation->set_rules('tgl_putusan_pn', 'Tanggal Putusan PN', 'trim|required|xss_clean|exact_length[10]');
		$this->form_validation->set_rules('nomor_perkara_banding', 'Nomor Perkara Banding', 'trim|xss_clean');
		$this->form_validation->set_rules('tgl_putusan_banding', 'Tanggal Putusan Banding', 'trim|xss_clean|exact_length[10]');
		$this->form_validation->set_rules('nomor_perkara_kasasi', 'Nomor Perkara Kasasi', 'trim|xss_clean');
		$this->form_validation->set_rules('tgl_putusan_kasasi', 'Tanggal Putusan kasasi', 'trim|xss_clean|exact_length[10]');
		$this->form_validation->set_rules('nomor_perkara_pk', 'Nomor Perkara PK', 'trim|xss_clean');
		$this->form_validation->set_rules('tgl_putusan_pk', 'Tanggal Putusan PK', 'trim|xss_clean|exact_length[10]');
		$this->form_validation->set_rules('listdataput', 'Putusan Eksekusi', 'trim|required|xss_clean');		
		$this->form_validation->set_rules('no_perkara_mhn_eksekusi', 'Nomor Perkara di Mohonkan Eksekusi', 'trim|required|xss_clean');				
		
		$this->form_validation->set_rules('tgl_permohonan_eksekusi', 'Tanggal Permohonan Eksekusi', 'trim|required|xss_clean|exact_length[10]');
		$this->form_validation->set_rules('nama_pemohon', 'Nama Pemohon Eksekusi', 'trim|required|xss_clean');		
		$this->form_validation->set_rules('tgl_surat_kuasa', 'Tanggal Surat Kuasa', 'trim|xss_clean');		
		$this->form_validation->set_rules('no_surat_kuasa', 'Nomor Surat Kuasa', 'trim|xss_clean');		

		$pihak_penggugat = $this->input->post('penggugat',TRUE);
		$pihak_tergugat = $this->input->post('tergugat',TRUE);

		if(($pihak_penggugat==0 || $pihak_penggugat=='') && ($pihak_tergugat==0 || $pihak_tergugat=='') ){
			echo json_encode(array('st'=>0,'msg'=>'Pihak belum ada yang dipilih.'));
			return;
		}

		$id_tergugat='';$nama_tergugat='';

		if($pihak_tergugat!='' || $pihak_tergugat!=0){
		 	$aa_tergugat=implode(';', $pihak_tergugat);
		 	$ax_tergugat=explode(';', $aa_tergugat);
		 	$ac_tergugat=count($ax_tergugat);
		 	
		 	for ($i=0;$i<$ac_tergugat;$i++){
		 		if ($i!=0){
		 			if($i % 2 ==0){
		 				$id_tergugat .= ','.$ax_tergugat[$i];		
			 		}else{
			 			if ($i!=1){
			 				$nama_tergugat .= ',';
			 			}
			 			$nama_tergugat .= $ax_tergugat[$i];
			 		}	
		 		}else{
		 			$id_tergugat .= $ax_tergugat[$i];	
		 		}

		 	}
	 	}
		$id_penggugat='';$nama_penggugat='';
		if($pihak_penggugat!='' || $pihak_penggugat!=0){
		 	$aa_penggugat=implode(';', $pihak_penggugat);
		 	$ax_penggugat=explode(';', $aa_penggugat);
		 	$ac_penggugat=count($ax_penggugat);
		 	
		 	for ($i=0;$i<$ac_penggugat;$i++){
		 		if ($i!=0){
		 			if($i % 2 ==0){
		 				$id_penggugat .= ','.$ax_penggugat[$i];		
			 		}else{
			 			if ($i!=1){
			 				$nama_penggugat .= ',';
			 			}
			 			$nama_penggugat .= $ax_penggugat[$i];
			 		}	
		 		}else{
		 			$id_penggugat .= $ax_penggugat[$i];	
		 		}

		 	}
	 	}

		if(($pihak_penggugat!=0 or $pihak_penggugat!='')){
			$pihak_pemohon_eksekusi='1';
			$kuasadari='Kuasa dari Penggugat :';
			$yangikuasakan=$nama_penggugat;
		}else{
			$pihak_pemohon_eksekusi='2';
			$kuasadari='Kuasa dari Tergugat :';
			$yangikuasakan=$nama_tergugat;
		}

		$idpemohon=$this->encrypt->decode(base64_decode($this->input->post('enc_pemohon',TRUE)));

		$pemohon = $this->input->post('nama_pemohon',TRUE);
		if(!empty($pemohon)){
			if($idpemohon==$id_penggugat){
				$pemohon_eksekusi=$pemohon.' (Penggugat)';	
			}else if($idpemohon==$id_tergugat){
				$pemohon_eksekusi=$pemohon.' (Tergugat)';	
			}else{
				$pemohon_eksekusi=$pemohon.' ('.$kuasadari.' '.$yangikuasakan.')';	
			}
		}


	
		if ($this->form_validation->run() === FALSE){
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Berhasil'.validation_errors()));
		}else{
			$this->load->model('perkara/new_eksekusi','eksekusi');
			
			$datapihak = '';
			$i=0;

			$listpihakpenggugat = $this->eksekusi->data_penggugat($idperkara);		
			if($listpihakpenggugat!=''){
				if($listpihakpenggugat->num_rows>0){

					$pihak_list = $this->input->post('penggugat',TRUE);
					if(empty($pihak_list)){
						$diwakili='T';
						$idpemohon=NULL;
						$nama_pemohon='';
						$pekerjaan_pemohon='';
						$alamat_pemohon='';
						$pemohoneksekusi='';
						$statuspihakid=2;
						$statuspihaktext='Termohon';
						$tglpermohonan=NULL;
					}else{
						$diwakili='Y';
						$idpemohon=$this->encrypt->decode(base64_decode($this->input->post('enc_pemohon',TRUE)));
						$nama_pemohon=$this->input->post('nama_pemohon',TRUE);
						$pekerjaan_pemohon=$this->input->post('pekerjaan_pemohon',TRUE);
						$alamat_pemohon=$this->input->post('alamat_pemohon',TRUE);
						$pemohoneksekusi=$pemohon_eksekusi;
						$statuspihakid=1;
						$statuspihaktext='Pemohon';
						$tglpermohonan=$this->tanggalhelper->convertToMysqlDate($this->input->post('tgl_permohonan_eksekusi',TRUE));
					}

					
					foreach ($listpihakpenggugat->result() as $row) {
							if(preg_match('/'.$row->pihak_id.'/',$id_penggugat)){
							$pihak = array(
									'perkara_id' => $idperkara,
									'alur_perkara_id' => $idalurperkara,
									'status_pihak_id' => $statuspihakid,
									'status_pihak_text' => $statuspihaktext,
									'permohonan_eksekusi' => $tglpermohonan,
									'pihak_asal' => 1,
									'pihak_asal_text' => 'Penggugat',
									'pihak_id' => $row->pihak_id,
									'pihak_nama' => $row->nama,
									'pihak_diwakili' => $diwakili,
									'pemohon_id' => $idpemohon,
									'pemohon_nama' => $nama_pemohon,
									'pemohon_pekerjaan' => $pekerjaan_pemohon,
									'pemohon_alamat' => $alamat_pemohon,
									'pemohon_tanggal_surat' => $this->tanggalhelper->convertToMysqlDate($this->input->post('tgl_surat_kuasa',TRUE)),
									'pemohon_nomor_surat' => $this->input->post('no_surat_kuasa',TRUE),
									'pemohon_eksekusi' => $pemohoneksekusi,
									'diperbaharui_oleh' => $this->session->userdata('username'),
									'diperbaharui_tanggal' => date("Y-m-d h:i:s",time())
							);
							}else{
							$pihak = array(
									'perkara_id' => $idperkara,
									'alur_perkara_id' => $idalurperkara,
									'status_pihak_id' => 2,
									'status_pihak_text' => 'Termohon',
									'permohonan_eksekusi' => NULL,
									'pihak_asal' => 1,
									'pihak_asal_text' => 'Penggugat',
									'pihak_id' => $row->pihak_id,
									'pihak_nama' => $row->nama,
									'pihak_diwakili' => 'T',
									'pemohon_id' => NULL,
									'pemohon_nama' => '',
									'pemohon_pekerjaan' => '',
									'pemohon_alamat' => '',
									'pemohon_tanggal_surat' => $this->tanggalhelper->convertToMysqlDate($this->input->post('tgl_surat_kuasa',TRUE)),
									'pemohon_nomor_surat' => $this->input->post('no_surat_kuasa',TRUE),									
									'pemohon_eksekusi' => '',
									'diperbaharui_oleh' => $this->session->userdata('username'),
									'diperbaharui_tanggal' => date("Y-m-d h:i:s",time())
							);

							}
							$datapihak[$i] = $pihak;
							$i++;

					}
				}
			}

			$listpihaktergugat = $this->eksekusi->data_tergugat($idperkara);		
			if($listpihaktergugat!=''){
				if($listpihaktergugat->num_rows>0){

					$pihak_list = $this->input->post('tergugat',TRUE);
					if(empty($pihak_list)){
						$diwakili='T';
						$idpemohon=NULL;
						$nama_pemohon='';
						$pekerjaan_pemohon='';
						$alamat_pemohon='';
						$pemohoneksekusi='';
						$statuspihakid=2;
						$statuspihaktext='Termohon';
						$tglpermohonan=NULL;
					}else{
						$diwakili='Y';
						$idpemohon=$this->encrypt->decode(base64_decode($this->input->post('enc_pemohon',TRUE)));
						$nama_pemohon=$this->input->post('nama_pemohon',TRUE);
						$pekerjaan_pemohon=$this->input->post('pekerjaan_pemohon',TRUE);
						$alamat_pemohon=$this->input->post('alamat_pemohon',TRUE);
						$pemohoneksekusi=$pemohon_eksekusi;
						$statuspihakid=1;
						$statuspihaktext='Pemohon';
						$tglpermohonan=$this->tanggalhelper->convertToMysqlDate($this->input->post('tgl_permohonan_eksekusi',TRUE));
					}

					
					foreach ($listpihaktergugat->result() as $row) {
							if(preg_match('/'.$row->pihak_id.'/',$id_tergugat)){
							$pihak = array(
									'perkara_id' => $idperkara,
									'alur_perkara_id' => $idalurperkara,
									'status_pihak_id' => $statuspihakid,
									'status_pihak_text' => $statuspihaktext,
									'permohonan_eksekusi' => $tglpermohonan,
									'pihak_asal' => 2,
									'pihak_asal_text' => 'Tergugat',
									'pihak_id' => $row->pihak_id,
									'pihak_nama' => $row->nama,
									'pihak_diwakili' => $diwakili,
									'pemohon_id' => $idpemohon,
									'pemohon_nama' => $nama_pemohon,
									'pemohon_pekerjaan' => $pekerjaan_pemohon,
									'pemohon_alamat' => $alamat_pemohon,
									'pemohon_tanggal_surat' => $this->tanggalhelper->convertToMysqlDate($this->input->post('tgl_surat_kuasa',TRUE)),
									'pemohon_nomor_surat' => $this->input->post('no_surat_kuasa',TRUE),									
									'pemohon_eksekusi' => $pemohoneksekusi,
									'diperbaharui_oleh' => $this->session->userdata('username'),
									'diperbaharui_tanggal' => date("Y-m-d h:i:s",time())
							);
							}else{
							$pihak = array(
									'perkara_id' => $idperkara,
									'alur_perkara_id' => $idalurperkara,
									'status_pihak_id' => 2,
									'status_pihak_text' => 'Termohon',
									'permohonan_eksekusi' => NULL,
									'pihak_asal' => 2,
									'pihak_asal_text' => 'Tergugat',
									'pihak_id' => $row->pihak_id,
									'pihak_nama' => $row->nama,
									'pihak_diwakili' => 'T',
									'pemohon_id' => NULL,
									'pemohon_nama' => '',
									'pemohon_pekerjaan' => '',
									'pemohon_alamat' => '',
									'pemohon_tanggal_surat' => $this->tanggalhelper->convertToMysqlDate($this->input->post('tgl_surat_kuasa',TRUE)),
									'pemohon_nomor_surat' => $this->input->post('no_surat_kuasa',TRUE),									
									'pemohon_eksekusi' => '',
									'diperbaharui_oleh' => $this->session->userdata('username'),
									'diperbaharui_tanggal' => date("Y-m-d h:i:s",time())
							);

							}
							$datapihak[$i] = $pihak;
							$i++;

					}
				}
			}

				$eksekusi_put_id=$this->input->post('listdataput',TRUE);
				if($eksekusi_put_id==10){
					$amardieksekusi=$this->input->post('amarpn',TRUE);
				}else if($eksekusi_put_id==20){
					$amardieksekusi=$this->input->post('amarbanding',TRUE);
				}else if($eksekusi_put_id==30){
					$amardieksekusi=$this->input->post('amarkasasi',TRUE);
				}else if($eksekusi_put_id==40){
					$amardieksekusi=$this->input->post('amarpn',TRUE);
				}

				$data = array(
						'eksekusi_putusan' => $this->input->post('listdataput',TRUE),
						'eksekusi_nomor_perkara' => $this->input->post('no_perkara_mhn_eksekusi',TRUE),
						'eksekusi_amar_putusan' => $amardieksekusi,
						'pihak_pemohon_eksekusi' => $pihak_pemohon_eksekusi,
						'permohonan_eksekusi' => $this->tanggalhelper->convertToMysqlDate($this->input->post('tgl_permohonan_eksekusi',TRUE)),						
						'pemohon_eksekusi' => $pemohon_eksekusi,
						'diperbaharui_oleh' => $this->session->userdata('username'),
						'diperbaharui_tanggal' => date("Y-m-d h:i:s",time())
					);			




			$result = $this->eksekusi->update_perkara_eksekusi($data,$idperkara);
			$result = $this->eksekusi->dele_perkara_eksekusi_detil($idperkara);
			$result = $this->eksekusi->add_perkara_eksekusi_detil($datapihak);
			

				if($result===FALSE){
					echo json_encode(array('st'=>0,'msg'=>'GAGAL Menyimpan'));
					return;
				}else{
					echo json_encode(array('st'=>1,'msg'=>'Berhasil Menyimpan'));
					return;
				}

		}

			

	}





	function parsePihak($listpihak,$idpihak){
		foreach ($listpihak as $key) {
			$idpihakpemohon = $this->encrypt->decode(base64_decode($key));
			if($idpihak==$idpihakpemohon){
				return TRUE;
			}
		}
		return FALSE;
	}

}