<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class addPihak extends CI_Controller {
	function index(){
		if($this->nativesession->is_flash_session('security')===FALSE){
			redirect('main');
		}
		$sec = $this->nativesession->get_flash_session('security');

		if($this->session->userdata('is_logged_in')===FALSE){
			redirect('login');
		}

		$htid = $this->nativesession->get_flash_session('ht_id');
		if(!is_numeric($htid)){
			show_404();
		}
		$this->show_data($htid);
	}

	private function fetchPihakKeText($pihakke,$alurperkaraid){
		#should be fetch from database
		if($alurperkaraid<100){
			if($pihakke==1){return "Penggugat";}
			elseif ($pihakke==2) {return "Tergugat";}
			elseif ($pihakke==3) {return "Intervensi";}
			elseif ($pihakke==4) {return "Turut Tergugat";}
		}else{
			if($pihakke==1){return "Penuntut Umum";}
			elseif ($pihakke==2) {return "Terdakwa";}
			elseif ($pihakke==5) {return "Korban Anak";}
		}
	}

	function show_data($htid){
		$data['current_date'] = date('d/m/Y');
		$data['pihak_ke'] = $this->nativesession->get_flash_session('pihakke');
		$data['enc_id'] =$this->nativesession->get_flash_session('enc_id',TRUE);
		$action = $this->nativesession->get_flash_session('action');
		$this->load->model('pihak/data_pihak', 'pihak');
		$alurperkaraid = $this->pihak->getAlurPerkaraId($htid);
		$data['enc_act'] = base64_encode($this->encrypt->encode($action));
		$data['pihak_ke_text'] = $this->fetchPihakKeText($data['pihak_ke'],$alurperkaraid);
		if($action=='add'){
			$urutan= $this->pihak->getUrutanPihak($data['pihak_ke'],$htid);
			if($urutan<1){
				$this->error_page->show_error_msg('Error Found','Something the right happen. Error Code = 197');
			}
			$data['urutan'] = $urutan;
			$data['title'] = 'TAMBAH DATA PIHAK EKSEKUSI HAK TANGGUNGAN';
			$data['tergabung_ke'] = '';
			$data['id_intervensi'] = '';
			$data['intervensi_nama'] = '';
			$data['tanggal_izin_intervensi'] = '';
		}elseif($action=='edit'){
			$data['urutan'] = $this->nativesession->get_flash_session('urutan');
			$idpihak = $this->nativesession->get_flash_session('pihak_id');
			$data['title'] = 'UBAH DATA PIHAK HAK TANGGUNGAN';
			$data = $this->fetchPihak($idpihak,$data);
			$data['tergabung_ke'] = '';
			$data['id_intervensi'] = '';
			$data['intervensi_nama'] = '';
			$data['tanggal_izin_intervensi'] = '';
			if($data['pihak_ke']==3){
				$this->load->model('pihak/data_pihak', 'pihak');
				$result = $this->pihak->getInfoIntervensi($idpihak,$idperkara);
				if($result!=''){
					if($result->num_rows()>0){
						foreach ($result->result() as $row) {
							$data['tergabung_ke'] = $row->tergabung_ke_pihak;
							$data['id_intervensi'] = $row->jenis_intervensi_id;
							$data['intervensi_nama'] = $row->jenis_intervensi_nama;
							$data['tgl_intervensi'] = $this->tanggalhelper->convertToInputDate($row->tanggal_izin_intervensi);
						}
					}
				}
			}

		}else{
			$this->error_page->show_error_msg('Error Found','Something the right happen. Error Code = 196');
		}
		$data['enc'] = $this->nativesession->get_flash_session('enc');
		$this->load->vars($data);
		$this->load->view('pihak/pihak_pertama');
	}

	function fetchPihak($idPihak,$data){
		if(is_numeric($idPihak)){
			if($idPihak>0){
				$this->load->model('pihak/data_pihak', 'pihak');
				$result = $this->pihak->getDetilInfoPihak($idPihak);
				if($result!=''){
					if($result->num_rows()>0){
						foreach ($result->result() as $row) {
							$data['enc_pihak'] = base64_encode($this->encrypt->encode($row->id));
							$data['nama'] = $row->nama;
							$data['alamat'] = $row->alamat;
							$data['pekerjaan'] = $row->pekerjaan;
							$data['tglLahir'] = $this->tanggalhelper->convertToInputDate($row->tanggal_lahir);
							$data['tempatLahir'] = $row->tempat_lahir;
							$data['jenisPihak'] = $row->jenis_pihak;
							$data['jenisIdentitas'] = $row->jenis_indentitas;
							$data['noIdentitas'] = $row->nomor_indentitas;
							$data['golDarah'] = $row->golongan_darah;
							$data['agama'] = $row->agama;
							if($row->jenis_kelamin=='L'){
								$data['sex'] = 'Laki Laki';
							}elseif($row->jenis_kelamin=='P'){
								$data['sex'] = 'Perempuan';
							}
							$data['wargaNegara'] = $row->warga_negara;
							$data['kawin']	= $row->status_kawin;
							$data['pendidikan'] = $row->pendidikan;
							$data['keterangan'] = $row->keterangan;
							if(!empty($row->tanggal_lahir)){
								$data['umur'] = $this->tanggalhelper->getSelisihTahun($row->tanggal_lahir,date('Y-m-d'));
							}else{
								$data['umur'] = "";
							}
						}
						return $data;
					}
				}else{
					$this->error_page->show_error_msg('Error Found','Something the right happen. Pihak Not Found. Error Code = 192');
					exit();
				}
			}
		}else{
			$this->error_page->show_error_msg('Error Found','Something the right happen. Error Code = 191');
			exit();
		}
	}

	function validateInput(){
		if(empty($_POST)){
			show_404();
		}

		if($this->session->userdata('is_logged_in')===FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Anda Belum Login, Silahkan Login Terlebih Dahulu.'));
			return;
		}

		$pihak_ke = trim($this->input->post('pihak_ke',TRUE));
		if(!is_numeric($pihak_ke) AND $pihak_ke<1 AND $pihak_ke>5){
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Berhasil Value Error. Code Error = 193.'));
			return;
		}

		if($pihak_ke==3){
			$this->form_validation->set_rules('tergabung_ke', 'Tergabung Ke Pihak', 'trim|required|numeric|xss_clean');
			$this->form_validation->set_rules('jenis_intervensi', 'Jenis Intervensi', 'trim|required|numeric|xss_clean');
			$this->form_validation->set_rules('pihak_tgl_intervensi', 'Tanggal Izin Intervensi', 'trim|required|xss_clean|exact_length[10]');
		}
		$this->form_validation->set_rules('no_urut', 'Nomor Urut Pihak', 'trim|required|numeric|xss_clean');
		$this->form_validation->set_rules('pihak', 'Pihak', 'trim|required|xss_clean');
		$this->form_validation->set_rules('fullname', 'Nama Pihak', 'trim|required|xss_clean');
		$this->form_validation->set_rules('tempat_lahir', 'Tempat Lahir', 'trim|required|xss_clean');
		$this->form_validation->set_rules('tgl_lahir', 'Tanggal Lahir', 'trim|required|xss_clean|exact_length[10]');
		$this->form_validation->set_rules('umur', 'Umur Pihak', 'trim|required|numeric|xss_clean');
		$this->form_validation->set_rules('warga_negara', 'Warga Negara', 'trim|required|xss_clean');
		$this->form_validation->set_rules('alamat', 'Alamat Pihak', 'trim|required|xss_clean');
		$this->form_validation->set_rules('pekerjaan', 'Pekerjaan Pihak', 'trim|required|xss_clean');
		$this->form_validation->set_rules('statusKawin', 'Status Perkawinan', 'trim|required|xss_clean');
		$this->form_validation->set_rules('pendidikan', 'Pendidikan Terakhir', 'trim|required|xss_clean');

		if ($this->form_validation->run() === FALSE){
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Berhasil'.validation_errors()));
			return;
		}

		$idpihak = $this->encrypt->decode(base64_decode($this->input->post('enc_pihak',TRUE)));
		$htid = $this->encrypt->decode(base64_decode($this->input->post('ht_id',TRUE)));
		
		$this->form_validation->set_rules('no_urut', 'Nomor Urut', 'trim|required|numeric|xss_clean');
		if ($this->form_validation->run() === FALSE){
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Berhasil'.validation_errors()));
			return;
		}else{
			if(!is_numeric($idpihak) OR $idpihak<0){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Berhasil Pihak Tidak ditemukan. Code Error = 195.'));
				return;
			}else{
				if(!is_numeric($idperkara) OR $idpihak<0){
					echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Berhasil Perkara Tidak ditemukan. Code Error = 194.'));
					return;
				}else{

					$this->load->model('pihak/data_pihak', 'pihak');
					$data = array(
						'perkara_id' => $idperkara,
						'urutan' => $this->input->post('no_urut',TRUE),
						'pihak_id' => $idpihak,
						'keterangan' => trim($this->input->post('keterangan',TRUE)),
						'diinput_oleh' => $this->session->userdata('username'),
						'diinput_tanggal' => date("Y-m-d h:i:s",time())
					);
					if($pihak_ke==3){
						$tgl_intervensi = $this->input->post('pihak_tgl_intervensi',TRUE);
						if(!$this->tanggalhelper->isInputDateValid($tgl_intervensi)){
							echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Intervensi Tidak Valid'));
							return;
						}else{
							$data['tanggal_izin_intervensi'] = $this->tanggalhelper->convertToMysqlDate($tgl_intervensi);
						}

						$data['jenis_intervensi_id'] = $this->input->post('jenis_intervensi',TRUE);
						if(!is_numeric($data['jenis_intervensi_id']) OR $data['jenis_intervensi_id'] <1 OR $data['jenis_intervensi_id'] >3){
							echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Jenis Intervensi Tidak Valid'));
							return;
						}

						if($data['jenis_intervensi_id']==1){
							$data['jenis_intervensi_nama'] = 'Voeging';
						}elseif($data['jenis_intervensi_id']==2){
							$data['jenis_intervensi_nama'] = 'Tussenkomst';
						}elseif($data['jenis_intervensi_id']==2){
							$data['jenis_intervensi_nama'] = 'Vrijwaring';
						}else{
							$data['jenis_intervensi_nama'] = 'ERROR';
						}

						$data['tergabung_ke_pihak'] = $this->input->post('tergabung_ke',TRUE);
						if(!is_numeric($data['tergabung_ke_pihak']) OR $data['tergabung_ke_pihak'] <1 OR $data['tergabung_ke_pihak'] >3){
							echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Jenis Intervensi Tidak Valid'));
							return;
						}
					}
					$act = $this->encrypt->decode(base64_decode($this->input->post('act',TRUE)));
					if ($act=='add') {
						$isexist = $this->pihak->isPihakberpekara($idpihak,$idperkara);
						if($isexist->num_rows>0){
							$nama ='';
							$status = '';
							foreach ($isexist->result() as $row) {
								$nama = $row->nama;
								$status = $row->status_perkara;
							}
							echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> '.$nama.' Telah terdaftar sebagai '.$status.' diperkara ini'));
							return;
						}
						$addData = $this->pihak->add_data($data,$pihak_ke);
					}elseif ($act=='edit') {
						#$data['urutan'] = $this->input->post('no_urut',TRUE);
						$id = $this->encrypt->decode(base64_decode($this->input->post('enc_id',TRUE)));
						if($id<1){
							echo json_encode(array('st'=>0,'msg'=>'ERROR.<br> Terjadi kesalahan pada DATABASE.err'));
							return;
						}
						$addData = $this->pihak->updt_data_pihak($id,$data,$pihak_ke);
						if($addData==FALSE){
							echo json_encode(array('st'=>0,'msg'=>'ERROR.<br> Terjadi kesalahan pada DATABASE.'));
							return;
						}elseif (intval($addData)==5) {
							echo json_encode(array('st'=>0,'msg'=>'ERROR.<br> Pihak Telah Terdaftar pada perkara yang sama.'));
							return;
						}
					}else{
						echo json_encode(array('st'=>0,'msg'=>'ERROR.<br> Something Bad Happen. Error Code = 190.'.$act));
						return;
					}
					
					if($addData==TRUE AND $pihak_ke!=5){
						$data_pihak = array(
						'diperbaharui_oleh' => $this->session->userdata('username'),
						'diperbaharui_tanggal' => date("Y-m-d h:i:s",time())
						);
						$updtData = $this->pihak->update_data($data_pihak,$idperkara,$pihak_ke);
						if($updtData==TRUE){
							echo json_encode(array('st'=>1,'msg'=>'Pihak Berhasil ditambahkan.'));
							return;
						}
					}elseif ($pihak_ke==5 AND $addData==TRUE) {
						echo json_encode(array('st'=>1,'msg'=>'Pihak Berhasil ditambahkan.'));
						return;
					}
					echo json_encode(array('st'=>0,'msg'=>'ERROR.<br> Terjadi kesalahan pada DATABASE.'));
				}
			}
		}
	}

	function validateDelete(){
		if(empty($_POST)){
			show_404();
		}

		if($this->session->userdata('is_logged_in')===FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Anda Belum Login, Silahkan Login Terlebih Dahulu.'));
			return;
		}

		$act = $this->encrypt->decode(base64_decode($this->input->post('act',TRUE)));
		if($act=='edit'){
			$this->load->model('pihak/data_pihak', 'pihak');
			$id = $this->encrypt->decode(base64_decode($this->input->post('enc_id',TRUE)));
			$idperkara = $this->encrypt->decode(base64_decode($this->input->post('enc',TRUE)));
			$pihakke = trim($this->input->post('pihak_ke',TRUE));
			$delData = $this->pihak->del_data($id,$pihakke);
			if($delData==TRUE){
				$data_perkara = array(
					'diperbaharui_oleh' => $this->session->userdata('username'),
					'diperbaharui_tanggal' => date("Y-m-d h:i:s",time())
					);
				$updtData = $this->pihak->update_data($data_perkara,$idperkara,$pihakke);
				if($updtData==TRUE){
					echo json_encode(array('st'=>1,'msg'=>'Pihak Berhasil Dihapus.'));
					return;
				}
			}
			echo json_encode(array('st'=>0,'msg'=>'ERROR.<br> Pihak Tidak Berhasil Dihapus. Terjadi kesalahan pada DATABASE.'));
		}else{
			echo json_encode(array('st'=>0,'msg'=>'ERROR.<br> Something Bad Happen. Error Code = 189.'));
			return;
		}
	}


}