<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class addPengacaraDiversi extends CI_Controller {
	function index(){
		if($this->nativesession->get_flash_session('security')==FALSE){
			redirect('main');
		}

		if($this->session->userdata('is_logged_in')==FALSE){
			redirect('login');
		}

		$idperkara = $this->nativesession->get_flash_session('perkara_id');
		if(!is_numeric($idperkara)){
			show_404();
		}
		$this->show_data($idperkara);
	}


	function show_data($idperkara){
		//$alurperkaraid = $this->tanggalhelper->getIDAlurPerkara($idperkara);
		$data['idperkara'] = $idperkara;
		$data['pihak_ke'] = $this->nativesession->get_flash_session('pihakke');
		$data['enc_id'] =$this->nativesession->get_flash_session('enc_id',TRUE);
		$action = $this->nativesession->get_flash_session('action');
		$this->load->model('diversi/data_pengacara_diversi', 'pengacara');
		$data['para_pihak'] = $this->pengacara->getInfoParaPihak($idperkara);
		$data['enc_act'] = base64_encode($this->encrypt->encode($action));

		$idperkarapengacara = $this->encrypt->decode(base64_decode($this->nativesession->get_flash_session('enc_pihak',TRUE)));
		
		$data['enc_pengacaraid'] = base64_encode($this->encrypt->encode($idperkarapengacara));
		$idData = $this->encrypt->decode(base64_decode(($data['enc_id'])));
		//$idData -->id diversi_penasihat_hukum
		$data['act'] = $action;

		if($action=='add'){
			$urutan= $this->pengacara->getUrutanPengacara($idperkara);
			if($urutan<1){
				$this->error_page->show_error_msg('Error Found','Something Not Right Happen. Error Code = 197');
			}
			$data['urutan'] = $urutan;
			$data['title'] = 'TAMBAH DATA PENASIHAT HUKUM';

		}elseif($action=='edit'){
			$data['urutan'] = $this->nativesession->get_flash_session('urutan');

			$idpihak = $this->nativesession->get_flash_session('pihak_id');	
			$data['title'] = 'UBAH DATA PENASIHAT HUKUM';
			$data = $this->fetchPihak($idpihak,$idData);
			$data['para_pihak'] = $this->pengacara->getPihakDiwakilkan($idData);
			$data['enc_id'] = base64_encode($this->encrypt->encode($idData));
			$data['act'] = $action;		
			$data['enc_act'] = base64_encode($this->encrypt->encode($action));	
		}else{
			$this->error_page->show_error_msg('Error Found','Something the right happen. Error Code = 196');
		}
		$data['enc'] = $this->nativesession->get_flash_session('enc');
		$this->load->vars($data);
		$this->load->view('diversi/pengacara_diversi');
	}

	function fetchPihak($idData,$iddiversi){
		if(is_numeric($idData)){
			if($idData>0){
				$this->load->model('diversi/data_pengacara_diversi', 'pengacara');
				$result = $this->pengacara->getDetilInfoPengacara($idData,$iddiversi);

				if($result!=''){
					if($result->num_rows()>0){
						foreach ($result->result() as $row) {
							#$data['enc_iddata'] = base64_encode($this->encrypt->encode($row->id));
							$data['enc_pengacaraid'] = base64_encode($this->encrypt->encode($row->id));
							$data['nama'] = $row->nama;
							$data['wongedan'] = $row->id;
							$data['alamat'] = $row->alamat;
							$data['pekerjaan'] = $row->pekerjaan;
							$data['tglLahir'] = $this->tanggalhelper->convertToInputDate($row->tanggal_lahir);
							$data['tempatLahir'] = $row->tempat_lahir;
							$data['jenisPihak'] = $row->jenis_pihak;
							$data['jenisIdentitas'] = $row->jenis_indentitas;
							$data['noIdentitas'] = $row->nomor_indentitas;
							$data['golDarah'] = $row->golongan_darah;
							$data['agama'] = $row->agama;
							if($row->jenis_kelamin=='L'){
								$data['sex'] = 'Laki Laki';
							}elseif($row->jenis_kelamin=='P'){
								$data['sex'] = 'Perempuan';
							}
							$data['wargaNegara'] = $row->warga_negara;
							$data['kawin']	= $row->status_kawin;
							$data['pendidikan'] = $row->pendidikan;
							$data['keterangan'] = $row->keterangan;
							if(!empty($row->tanggal_lahir)){
								$data['umur'] = $this->tanggalhelper->getSelisihTahun($row->tanggal_lahir,date('Y-m-d'));
							}else{
								$data['umur'] = "";
							}
							$data['aktif'] = $row->aktif;
							$data['aktif_mulai'] = $row->aktif_mulai;
							$data['aktif_sampai'] = $row->aktif_sampai;
							$data['nomor_kuasa'] = $row->no_surat_kuasa;
							$data['tanggal_kuasa'] = $row->tgl_surat_kuasa;
						}
						return $data;

					}
				}else{
					$this->error_page->show_error_msg('Error Found','Something the right happen. Pihak Not Found. Error Code = 192');
					exit();
				}
			}
		}else{
			$this->error_page->show_error_msg('Error Found','Something the right happen. Error Code = 191');
			exit();
		}
	}

	function validateInput(){
		if(empty($_POST)){
			show_404();
		}
		
		if($this->session->userdata('is_logged_in')==FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Anda Belum Login, Silahkan Login Terlebih Dahulu.'));
			return;
		}
		
		$this->form_validation->set_rules('no_urut', 'Nomor Urut Pihak', 'trim|required|numeric|xss_clean');
		$this->form_validation->set_rules('fullname', 'Nama Pihak', 'trim|required|xss_clean');
		$this->form_validation->set_rules('warga_negara', 'Warga Negara', 'trim|required|xss_clean');
		$this->form_validation->set_rules('alamat', 'Alamat Pihak', 'trim|required|xss_clean');
		$this->form_validation->set_rules('nmr_kuasa', 'Nomor Surat Kuasa', 'trim|required|xss_clean');
		$this->form_validation->set_rules('tgl_kuasa', 'Tanggal Kuasa', 'trim|required|xss_clean|exact_length[10]');


		if ($this->form_validation->run() == FALSE){
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Berhasil'.validation_errors()));
			return;
		}
		$pihak_list = $this->input->post('para_pihak',TRUE);

		if(empty($pihak_list)){
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Pilih Pihak Yang diWakili'));
			return;
		}
		
		$idpengacara = $this->encrypt->decode(base64_decode($this->input->post('enc_pengacara',TRUE)));
		$idperkara = $this->encrypt->decode(base64_decode($this->input->post('enc',TRUE)));
		if(!is_numeric($idperkara) AND $idperkara<1){
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Berhasil Perkara NOT FOUND'));
			return;
		}
		$pihak_ke = trim($this->input->post('pihak_ke',TRUE));
		if ($this->form_validation->run() == FALSE){
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Berhasil'.validation_errors()));
			return;
		}else{ 
			$idperkara = $this->encrypt->decode(base64_decode($this->input->post('enc',TRUE)));
			if(!is_numeric($idpengacara) OR $idpengacara<0){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Berhasil Pihak Tidak ditemukan. Code Error = 195.'));
				return;
			}else{ 
				if(!is_numeric($idperkara) OR $idperkara<0){
					echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Berhasil ID Register Diversi Tidak ditemukan. Code Error = 194.'));
					return;
				}else{
						$aktifMulai = $this->input->post('begin_aktif',TRUE);
						$aktifMulai = $this->tanggalhelper->convertToMysqlDate($aktifMulai);
					
					if($aktifMulai==false){
						if ($this->session->userdata('jenis_pengadilan')!=3 ){
							echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Format Tanggal Tidak Benar. Format tanggal hari/bulan/tahun. Contoh 20/01/2015.'));
							return;
						}
					}

					if ($this->session->userdata('jenis_pengadilan')!=2){
						$aktifSelesai = $this->input->post('end_aktif',TRUE);
					}else{
						$aktifSelesai = $this->input->post('begin_aktif',TRUE);
					}

					$aktifSelesai = $this->tanggalhelper->convertToMysqlDate($aktifSelesai);
					

					if($aktifSelesai==false){
						if ($this->session->userdata('jenis_pengadilan')!=3 ){
							echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Format Tanggal Tidak Benar. Format tanggal hari/bulan/tahun. Contoh 20/02/2015.'));
							return;
						}
					}

					$this->load->model('diversi/data_pengacara_diversi', 'pengacara');
/*					$isPihakAlreadyRegistered = $this->pengacara->isPihakAlreadyThere($idperkara,$idpengacara);
					if($isPihakAlreadyRegistered){
						echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Berhasil Pihak Yang Dipilih Telah Menjadi Pihak Berperkara di Perkara ini.'));
						return;
					}
*/					$data = array(
						'diversi_register_id' => $idperkara,						
						'pengacara_id' => $idpengacara,
						'aktif' => $this->input->post('aktif',TRUE),
						'aktif_mulai' => $aktifMulai,
						'aktif_sampai' => $aktifSelesai,
						'no_surat_kuasa' => $this->input->post('nmr_kuasa',TRUE),
						'tgl_surat_kuasa' =>$this->tanggalhelper->convertToMysqlDate($this->input->post('tgl_kuasa',TRUE)),
						'diinput_oleh' => $this->session->userdata('username'),
						'diinput_tanggal' => date("Y-m-d h:i:s",time())
					);
					//$idalurperkara = $this->tanggalhelper->getIDAlurPerkara($idperkara);
					//$statuspengacara = $this->nativesession->getStatusPihak(10,$idalurperkara,$pihak_ke+6);

					$act = $this->encrypt->decode(base64_decode($this->input->post('act',TRUE)));
					$urut=1;
					if ($act=='add') {
						foreach ($pihak_list as $pihak) {
							$anak = $this->encrypt->decode(base64_decode($pihak));
							$anak_pecah = explode('|', $anak);
							$data['anak_id'] 	= $anak_pecah[0];
							$data['urutan'] 	= $anak_pecah[1];

							$isthere = $this->pengacara->isPengacaraAlreadyThere($idperkara,$idpengacara,$data['anak_id']);
							if($isthere>0){
								echo json_encode(array('st'=>0,'msg'=> ' Penasihat Hukum Sudah Terdaftar Mewakili Pihak Yang dipilih'));
								return;
							}
							
							$addData = $this->pengacara->add_data($data);
							$urut++;

						}
						if($addData==true){
								echo json_encode(array('st'=>1,'msg'=>'Pihak Berhasil ditambahkan.'));
								return;							
						}
					}elseif ($act=='edit') {

						$id = $this->encrypt->decode(base64_decode($this->input->post('enc_id',TRUE)));
						if($id<1){
							echo json_encode(array('st'=>0,'msg'=>'ERROR.<br> Terjadi kesalahan pada DATABASE.'));
							return;
						}
						foreach ($pihak_list as $pihak) {
							$anak = $this->encrypt->decode(base64_decode($pihak));
							$anak_pecah = explode('|', $anak);
							$data['anak_id'] 	= $anak_pecah[0];
							$data['urutan'] 	= $anak_pecah[1];

							$addData = $this->pengacara->updt_data_pengacara($id,$data);
						}
						
						if($addData==true){
								echo json_encode(array('st'=>1,'msg'=>'Pihak Berhasil ditambahkan.'));
								return;							
						}
					}else{
						echo json_encode(array('st'=>0,'msg'=>'ERROR.<br> Something Bad Happen. Error Code = 190.'.$act));
						return;
					}
					
					
				}
			}
		}
	}

	function validateDelete(){
		if(empty($_POST)){
			show_404();
		}

		if($this->session->userdata('is_logged_in')==FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Anda Belum Login, Silahkan Login Terlebih Dahulu.'));
			return;
		}

		$act = $this->encrypt->decode(base64_decode($this->input->post('act',TRUE)));
		if($act=='edit'){
			$this->load->model('diversi/data_pengacara_diversi', 'pengacara');
			$id = $this->encrypt->decode(base64_decode($this->input->post('enc_id',TRUE)));
			$delData = $this->pengacara->del_data($id);
			if($delData==TRUE){
					echo json_encode(array('st'=>1,'msg'=>' Penasihat Hukum Berhasil Dihapus.'));
					return;
			}			
			
		}else{
			echo json_encode(array('st'=>0,'msg'=>'ERROR.<br> Something Bad Happen. Error Code = 189.'));
			return;
		}
	}


}