<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class addPenahanan_c extends CI_Controller {
	
	function __construct() {
	    parent::__construct();
	    $this->load->model('penahanan/add_penahanan_m');
	}

	function index(){
		if($this->nativesession->get_flash_session('security')==FALSE){
			redirect('main');
		}
		if($this->session->userdata('is_logged_in')==FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Anda Belum Login, Silahkan Login Terlebih Dahulu.'));
			return;
		}
		$this->show_data();
	}

	function getRutan(){
        $keyword=$this->input->post('keyword');
        $data=$this->add_penahanan_m->getdatarutan($keyword);        
        echo json_encode($data);
    }	
	
	function load(){
		$nomor_perkara= $this->input->post('no_perkara', TRUE);
		$perkara_id = $this->add_penahanan_m->get_perkara_id(trim($nomor_perkara));
		if(empty($perkara_id)){
			echo json_encode(array('st'=>0,'msg'=>'Perkara Tidak Ditemukan. Periksa kembali nomor perkara yang anda masukan'));
			return;
		}
		$list = $this->add_penahanan_m->get_nama_pihak($perkara_id);
		if (empty($list)){
			$list = $this->add_penahanan_m->get_nama_pihak_awal($perkara_id);	
		}
		foreach ($list as $row ) {
			$result[]=array("perkara_id"=>base64_encode($this->encrypt->encode($row->perkara_id)), "alur_perkara_id"=>base64_encode($this->encrypt->encode($row->alur_perkara_id)), "pihak_id"=>base64_encode($this->encrypt->encode($row->pihak_id)), "nama"=>$row->nama);
		}
		
		echo json_encode($result);
	}

	function names(){
		$pihak_id = $this->encrypt->decode(base64_decode($this->input->post('pihak_id',TRUE)));
		$result=$this->get_pihak_detail($pihak_id);
		echo json_encode($result);
	}

	function get_pihak_detail($pihak_id){
		$list = $this->add_penahanan_m->get_data_pihak($pihak_id);
		if (count($list)>0){
			foreach ($list as $row) {
				$result[]=array("tempat_lahir"=>$row->tempat_lahir, 
								"tanggal_lahir"=>$this->tanggalhelper->convertDate($row->tanggal_lahir), 
								"umur"=>$row->umur,
								"nama"=>$row->nama, 
								"jenis_kelamin"=>$row->jenis_kelamin, 
								"warga_negara"=>$row->warga_negara,
								"agama"=>$row->agama_nama,
								"alamat"=>$row->alamat,
								"pekerjaan"=>$row->pekerjaan,
								"pihak_id"=>$row->pihak_id,
								"nrp"=>$row->nrp,
								"pangkat"=>$row->pangkat,
								"jabatan"=>$row->jabatan,
								"kesatuan"=>$row->kesatuan);
			};
		}else{
				$result[]=array("tempat_lahir"=>'', 
								"tanggal_lahir"=>'', 
								"umur"=>'',
								"nama"=>'', 
								"jenis_kelamin"=>'', 
								"warga_negara"=>'',
								"agama"=>'',
								"alamat"=>'',
								"pekerjaan"=>'',
								"nrp"=>"",
								"pangkat"=>"",
								"jabatan"=>"",
								"kesatuan"=>"");
		}
		return $result;
	}
	function show_data(){
		$history = $this->nativesession->get('main_url_requested');
		$data['current_date']= date('d/m/Y');
		$data['page_title'] = 'TAMBAH PENAHANAN TERDAKWA';
		$data['enc'] = $this->nativesession->get_flash_session('enc');
		$data['main_body'] = 'penahanan_list/edit_penahanan_v';
		$data['main_history'] = $history;
		$data['history'] = $history;
		$data['nama'] = '';
		$data['nrp'] = '';
		$data['pangkat'] = '';
		$data['jabatan'] = '';
		$data['kesatuan'] = '';
		$data['tempat_lahir'] = '';
		$data['tanggal_lahir'] = '';
		$data['umur'] = '';
		$data['jenis_kelamin'] = '';
		$data['warga_negara'] = '';
		$data['alamat'] = '';
		$data['pekerjaan'] = '';
		
		
		$this->load->vars($data);
		$this->load->view('header');
		$this->load->view('body/body_new');
	}
	
	function f_show_details(){
		if($this->nativesession->get_flash_session('security')==FALSE){
			redirect('main');
		}
		$this->nativesession->set_flash_session('security', TRUE);
		if($this->session->userdata('is_logged_in')==FALSE){
			redirect ('login');
			return;
		}
		$post=$this->input->post();
		if(empty($post)){
			$data['perkara_id'] = $this->nativesession->get_flash_session('enc');
			$perkara_id = $this->encrypt->decode(base64_decode($data['perkara_id']));
			$pihak_id = $this->nativesession->get_flash_session('enc_terdakwa_id');
			$data['add']=false;
			$data['nomor_perkara'] = $this->add_penahanan_m->get_nomor_perkara($perkara_id);
			$data['pihak_id']=$this->encrypt->decode(base64_decode($pihak_id));
		}else{
			if ($this->input->post('sl_nama', TRUE)!=''){
				$data['pihak_id'] = $this->encrypt->decode(base64_decode($this->input->post('sl_nama', TRUE)));	
				$pihak_id = $this->input->post('sl_nama', TRUE);
				$perkara_id = $this->encrypt->decode(base64_decode($this->input->post('perkara_id', TRUE)));
				$data['perkara_id'] = $this->input->post('perkara_id', TRUE);
				$data['nomor_perkara'] = $this->input->post('no_perkara', TRUE);
				$data['add']=true;
			}	
		}
		$data['id_perkara']=$perkara_id;
		$data['alur_perkara_id'] = $this->tanggalhelper->getIDAlurPerkara($perkara_id);
		$data['history'] = $this->nativesession->get_flash_session('url_requested');
		$this->nativesession->set_flash_session('url_requested',$data['history']);
		$his = $this->nativesession->get_flash_session('url_from_dataumum');
		$data['dari_dataumum']=false;
		if(!empty($his)){
			$data['previous'] = $his;
			$this->nativesession->set_flash_session('url_from_dataumum',$his);
			$data['dari_dataumum']=true;
		}else{
			$data['previous'] = $this->nativesession->get_flash_session('main_url_penahanan');
		}
		$datapihak = $this->get_pihak_detail($data['pihak_id']);
		$data['pihak_detail']=$datapihak[0];
		$data['dakwaan']=$this->add_penahanan_m->get_dakwaan($perkara_id);
		$data['detail_penahanan']=$this->add_penahanan_m->get_data_penahanan(intval($perkara_id), intval($data['pihak_id']));
		$data['page_title'] = 'INFORMASI DETIL PENAHANAN TERDAKWA/TERSANGKA';
		$data['main_body'] = 'penahanan_list/penahanan_detail_v';
		$data['enc'] = $data['perkara_id'];
		$this->load->vars($data);
		$this->load->view('header');
		$this->load->view('body/body_new');
	}

	function add_penahanan_detail(){
		//get variables
		$data['perkara_id']=$this->nativesession->get_flash_session('enc');
		$data['pihak_id']=$this->nativesession->get_flash_session('enc_pihak');
		$penahanan_id=$this->nativesession->get_flash_session('penahanan_id');
		if ($penahanan_id!='add'){
			$data['penahanan_id']=base64_encode($this->encrypt->encode($penahanan_id));	
		}else{
			$data['penahanan_id']=$penahanan_id;
		}
		$perkara_id=$this->encrypt->decode(base64_decode($data['perkara_id']));
		$alur_perkara_id = $this->add_penahanan_m->get_alur_perkara_id($perkara_id);
		if ($this->authorization->HasRuleAddPenahanan($perkara_id)==false){
			show_404();
			return;
		}
		$pihak_id=$this->nativesession->get_flash_session('pihak_id');
		$list_penahanan=$this->add_penahanan_m->get_data_penahanan($perkara_id, $pihak_id);
		$arr_penahanan=array(
								'status_penahanan_id'=>'0',
								'jenis_penahanan_id'=>'0',
								'jenis_tahanan_id'=>'0',
								'tanggal_surat'=>'',
								'nomor_surat'=>'',
								'mulai'=>'',
								'sampai'=>'',
								'lama_penahanan'=>'-',
								'pejabat_penahan'=>'-',
								'keterangan'=>'',
								'rutan'=>'',
								'idrutan'=>''
					);
		if (!empty($list_penahanan)){
			foreach ($list_penahanan as $row) {
				if ($row->id==$penahanan_id){
					$arr_penahanan=array(
						'id'=>$row->id,
						'pihak_id'=>$row->pihak_id,
						'status_penahanan_id'=>$row->status_penahanan_id,
						'jenis_penahanan_id'=>$row->jenis_penahanan_id,
						'jenis_tahanan_id'=>$row->jenis_tahanan_id,
						'tanggal_surat'=>$row->tanggal_surat,
						'nomor_surat'=>$row->nomor_surat,
						'mulai'=>$row->mulai,
						'sampai'=>$row->sampai,
						'lama_penahanan'=>$row->lama_penahanan,
						'pejabat_penahan'=>$row->pejabat_penahan,
						'keterangan'=>$row->keterangan,
						'rutan'=>$row->rutan_nama,
						'idrutan'=>$row->rutan_id
						);
				}
			}
		}
		$data['detail_penahanan']=$arr_penahanan;
		$data['nomor_perkara']=$this->add_penahanan_m->get_nomor_perkara($perkara_id);
		$list_status_penahanan=$this->add_penahanan_m->get_status_penahanan();
		$list_jenis_tahanan=$this->add_penahanan_m->get_jenis_tahanan();
		$datapihak = $this->get_pihak_detail($pihak_id);
		$data['pihak_detail']=$datapihak[0];
		
		$list_penahanan=$this->add_penahanan_m->get_jenis_penahanan();
		$arr=array('0'=>'');
		$arr_batas_waktu=array('0'=>0);$i=0;
		$testtt='';
		foreach ($list_penahanan as $row) {
			$arr[$row->id]=$row->nama;
			if ($alur_perkara_id==118){
				$arr_batas_waktu[$row->id]=$row->batas_waktu_anak;
				$testtt.='"'.$row->id.'":"'.$row->batas_waktu_anak.'"';	
			}else{
				$arr_batas_waktu[$row->id]=$row->batas_waktu;
				$testtt.='"'.$row->id.'":"'.$row->batas_waktu.'"';	
			}
			if ($i<count($list_penahanan)-1){
				$testtt.=',';
			}
			$i++;
		};
		$data['jenis_penahanan']=$arr;
		
		$list_penahanan2=$this->add_penahanan_m->get_jenis_pembebas();
		$arr2=array('0'=>'');
		$arr_batas_waktu2=array('0'=>0);$i=0;
		$testtt2='';
		foreach ($list_penahanan2 as $row2) {
			if($row2->id==16)$row2->nama='Perwira Penyerah Perkara';
			$arr2[$row2->id]=$row2->nama;
			$i++;
		};
		$data['jenis_penahanan2']=$arr2;

		$data['batas_waktu']='{' . $testtt . '}';
		$arr=array('0'=>'');
		foreach ($list_status_penahanan as $row) {
			$arr[$row->id]=$row->nama;
		};
		$data['status_penahanan']=$arr;
		$arr=array('0'=>'');
		foreach ($list_jenis_tahanan as $row) {
			$arr[$row->id]=$row->nama;
		};
		$data['jenis_tahanan']=$arr;
		$data['current_date'] = date('d/m/Y');
		$this->load->view('penahanan_list/add_perpanjangan_penahanan_v', $data);
	}

	function f_validate_input_add(){
		// $this->nativesession->set_flash_session('url_requested', current_url());
		$post=$this->input->post();
		if(empty($post)){
			show_404();
		}else{
			if($this->nativesession->get_flash_session('security')==FALSE){
				redirect('main');
			}
			$this->nativesession->set_flash_session('security', TRUE);
			if($this->session->userdata('is_logged_in')==FALSE){
				echo json_encode(array('st'=>0,'msg'=>'Anda Belum Login, Silahkan Login Terlebih Dahulu.'));
				return;
			}
			$jenis_pengadilan = $this->session->userdata('jenis_pengadilan');
			if($jenis_pengadilan=='2'){
				$this->form_validation->set_rules('pejabat_penahan', 'Pejabat Penahan', 'trim|required|xss_clean');
			}
			
			$status_penahanan=$this->input->post('status_penahanan');
			if($status_penahanan=='1'){ $ditahanoleh="Ditahan Oleh"; }
			if($status_penahanan=='2'){ $ditahanoleh="Ditahan Oleh"; }
			if($status_penahanan=='3'){ $ditahanoleh="Ditahan Oleh"; }
			if($status_penahanan=='4'){ $ditahanoleh="Ditahan Oleh"; }
			if($status_penahanan=='5'){ $ditahanoleh="Ditahan Oleh"; }
			
			$this->form_validation->set_rules('status_penahanan', 'Status Penahanan', 'trim|required|xss_clean|callback_f_dropdown_id_check');
			if ($status_penahanan=='5'){
				$this->form_validation->set_rules('jenis_penahanan2', $ditahanoleh, 'trim|required|xss_clean|callback_f_dropdown_id_check');
			}else{
				$this->form_validation->set_rules('jenis_penahanan', $ditahanoleh, 'trim|required|xss_clean|callback_f_dropdown_id_check');
			}
			
			if($status_penahanan=='1'){
				$this->form_validation->set_rules('jenis_tahanan', 'Jenis Tahanan', 'trim|required|xss_clean|callback_f_dropdown_id_check');
				$this->form_validation->set_rules('tgl_mulai', 'Tanggal Mulai', 'trim|required|xss_clean');
				$this->form_validation->set_rules('tgl_sampai', 'Tanggal Sampai', 'trim|required|xss_clean');
			}
			if ($this->form_validation->run() === FALSE){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Berhasil '.validation_errors()));
				return;
			}else{
				//simpan data
				$curr_date = date('Y-m-d');
				$todayDate = date('m/d/Y');
				
				$tanggal_surat = $this->input->post('tgl_surat_penahanan', TRUE);
				if(!empty($tanggal_surat)){
					$tanggal_surat = $this->tanggalhelper->convertToMysqlDate($tanggal_surat);
				}else{
					$tanggal_surat = NULL;
				}
				$tgl_mulai = $this->tanggalhelper->convertToMysqlDate($this->input->post('tgl_mulai', TRUE));
				
				$tgl_sampai = $this->input->post('tgl_sampai', TRUE);
				if(!empty($tgl_sampai))
					$tgl_sampai = $this->tanggalhelper->convertToMysqlDate($this->input->post('tgl_sampai', TRUE));
				else
					$tgl_sampai = NULL;
				$waktu_penahanan = $tgl_mulai.' s/d '.$tgl_sampai;
				$lama_penahanan = $this->tanggalhelper->getSelisihHari($tgl_mulai,$tgl_sampai) + 1;
				$pihak_id=$this->input->post('pihak_id', TRUE);
				$perkara_id=$this->input->post('perkara_id', TRUE);
				$rutan_id=$this->input->post('idrutan',TRUE);
				if (empty($rutan_id)){
					$rutan_id=NULL;
				}
				$jenis_tahanan = $this->input->post('jenis_tahanan', TRUE);
				$no_surat_penahanan=$this->input->post('no_surat_penahanan', TRUE);
				if ($status_penahanan==5){
					$tgl_sampai=NULL;
					$waktu_penahanan=NULL;
					$lama_penahanan=NULL;
					$no_surat_penahanan=NULL;
					$jenis_penahanan=$this->input->post('jenis_penahanan2', TRUE);
				}else{
					$jenis_penahanan=$this->input->post('jenis_penahanan', TRUE);
				}
				if($status_penahanan==2){
					$jenis_tahanan = '0';
					$tanggal_surat = NULL;
					$tgl_mulai = NULL;
					$tgl_sampai = NULL;
					$waktu_penahanan = '';
					$lama_penahanan = NULL;
					$pejabat_penahan = NULL;
					$jenis_penahanan = $this->input->post('jenis_penahanan', TRUE);
				}
				
				$data=array(
						'perkara_id'=>$this->encrypt->decode(base64_decode($perkara_id)),
						'pihak_id'=>$this->encrypt->decode(base64_decode($pihak_id)), 
						'jenis_penahanan_id'=>$jenis_penahanan, 
						'status_penahanan_id'=>$status_penahanan, 
						'jenis_tahanan_id'=>$jenis_tahanan, 
						'rutan_id'=>$rutan_id,
						'tanggal_surat'=>$tanggal_surat, 
						'nomor_surat'=>$no_surat_penahanan, 
						'mulai'=>$tgl_mulai, 
						'sampai'=>$tgl_sampai, 
						'waktu_penahanan'=>$waktu_penahanan, 
						'lama_penahanan'=>$lama_penahanan, 
						'keterangan'=>$this->input->post('keterangan', TRUE),
						'pejabat_penahan'=>$this->input->post('pejabat_penahan', TRUE),
						'diinput_oleh'=>$this->session->userdata('username', TRUE),
						'diinput_tanggal'=>date('Y-m-d H:i:s')
				); 

				$batas_waktu = json_decode($this->input->post('vra', TRUE));
				if($status_penahanan==1||$status_penahanan==3||$status_penahanan==4){
					if ($batas_waktu->$data['jenis_penahanan_id'] < $lama_penahanan){
						echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Lama penahanan tidak boleh lebih dari '.$batas_waktu->$data['jenis_penahanan_id'].' hari!' ));
						return;
					}
				}				

				if ($this->add_penahanan_m->insert_penambahan_penahanan($data)){
					redirect('detail_penahanan_dataumum/'.$pihak_id.'/'.$perkara_id);
				}else{
					echo json_encode(array('st'=>0,'msg'=>'Penambahan Data Penahanan Terdakwa Gagal'));
					return;
				};
			}
		}		
	}

	function f_validate_input_edit(){
		$post=$this->input->post();
		if(empty($post)){
			show_404();
		}else{
			if($this->nativesession->get_flash_session('security')==FALSE){
				redirect('main');
			}
			$this->nativesession->set_flash_session('security', TRUE);
			if($this->session->userdata('is_logged_in')==FALSE){
				echo json_encode(array('st'=>0,'msg'=>'Anda Belum Login, Silahkan Login Terlebih Dahulu.'));
				return;
			}
			$jenis_pengadilan = $this->session->userdata('jenis_pengadilan');
			if($jenis_pengadilan=='2'){
				$this->form_validation->set_rules('pejabat_penahan', 'Pejabat Penahan', 'trim|required|xss_clean');
			}
			$this->form_validation->set_rules('jenis_penahanan', 'Ditahan Oleh', 'trim|required|xss_clean|callback_f_dropdown_id_check');
			$this->form_validation->set_rules('status_penahanan', 'Status Penahanan', 'trim|required|xss_clean|callback_f_dropdown_id_check');
			if($this->input->post('status_penahanan')=='1'){
				$this->form_validation->set_rules('jenis_tahanan', 'Jenis Tahanan', 'trim|required|xss_clean|callback_f_dropdown_id_check');
			}
			if($this->input->post('status_penahanan')=='3' OR $this->input->post('status_penahanan')=='4'){
				$this->form_validation->set_rules('tgl_mulai', 'Tanggal Mulai', 'trim|required|xss_clean|callback_f_dropdown_id_check');
			}
			if ($this->form_validation->run() === FALSE){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Berhasil '.validation_errors()));
				return;
			}else{
				//simpan data
				$tanggal_surat = $this->input->post('tgl_surat_penahanan', TRUE);
				if(!empty($tanggal_surat)){
					$tanggal_surat = $this->tanggalhelper->convertToMysqlDate($tanggal_surat);
				}else{
					$tanggal_surat = NULL;
				}
				$tgl_mulai = $this->tanggalhelper->convertToMysqlDate($this->input->post('tgl_mulai', TRUE));
				$tgl_sampai = $this->input->post('tgl_sampai', TRUE);
				if(!empty($tgl_sampai)){
					$tgl_sampai = $this->tanggalhelper->convertToMysqlDate($this->input->post('tgl_sampai', TRUE));
				}else{
					$tgl_sampai = NULL;
				}
				$waktu_penahanan = $tgl_mulai.' s/d '.$tgl_sampai;
				$lama_penahanan = $this->tanggalhelper->getSelisihHari($tgl_mulai,$tgl_sampai) + 1;

				$status_penahanan = $this->input->post('status_penahanan', TRUE);
				$jenis_tahanan = $this->input->post('jenis_tahanan', TRUE);
				$pejabat_penahan = $this->input->post('pejabat_penahan', TRUE);
				if($status_penahanan==2){
					$jenis_tahanan = '0';
					$tanggal_surat = NULL;
					$tgl_mulai = NULL;
					$tgl_sampai = NULL;
					$waktu_penahanan = '';
					$lama_penahanan = NULL;
					$pejabat_penahan = NULL;
				}elseif($status_penahanan==3 OR $status_penahanan==4){
					$lama_penahanan = NULL;
				}
				
				$namarutan=$this->input->post('rutan',TRUE);
				if (empty($namarutan)){
					$rutanid=NULL;
				}else{
					$rutanid=$this->input->post('idrutan',TRUE);;
				}
				$perkara_id=$this->input->post('perkara_id', TRUE);
				$pihak_id=$this->input->post('pihak_id', TRUE);
				$data=array(
						'perkara_id'=>$this->encrypt->decode(base64_decode($perkara_id)),
						'pihak_id'=>$this->encrypt->decode(base64_decode($pihak_id)), 
						'jenis_penahanan_id'=>$this->input->post('jenis_penahanan', TRUE), 
						'status_penahanan_id'=>$status_penahanan, 
						'jenis_tahanan_id'=>$jenis_tahanan, 
						'rutan_id'=>$rutanid,
						'tanggal_surat'=>$tanggal_surat, 
						'nomor_surat'=>$this->input->post('no_surat_penahanan', TRUE), 
						'mulai'=>$tgl_mulai, 
						'sampai'=>$tgl_sampai, 
						'waktu_penahanan'=>$waktu_penahanan, 
						'lama_penahanan'=>$lama_penahanan, 
						'pejabat_penahan'=>$pejabat_penahan,
						'keterangan'=>$this->input->post('keterangan', TRUE),
						'diperbaharui_oleh'=>$this->session->userdata('username', TRUE),
						'diperbaharui_tanggal'=>date('Y-m-d H:i:s')
				); 
				
				$batas_waktu = json_decode($this->input->post('vra', TRUE));

				if ($batas_waktu->$data['jenis_penahanan_id'] < $lama_penahanan){
					echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Lama penahanan tidak boleh lebih dari '.$batas_waktu->$data['jenis_penahanan_id'].' hari!' ));
					return;
				}
				$this->add_penahanan_m->edit_penambahan_penahanan($data, $this->encrypt->decode(base64_decode($this->input->post('penahanan_id'))));
				redirect('detail_penahanan_dataumum/'.$pihak_id.'/'.$perkara_id);
			}
		}		
	}

	function f_dropdown_id_check($str){
		if (intval($str)==0){
			$this->form_validation->set_message('f_dropdown_id_check', '%s - Tidak Boleh Kosong');
			return FALSE;
		}else{
			return TRUE;
		}
	}
	
	function hapus_penahanan(){
		$perkara_id=$this->uri->segment(3);
		$pihak_id=$this->uri->segment(4);
		$penahanan_id=$this->uri->segment(5);
		$idpenahanan = $this->encrypt->decode(base64_decode($penahanan_id));
		$this->load->model('penahanan/add_penahanan_m');
		$this->add_penahanan_m->hapus_penahanan($idpenahanan);
		redirect('detail_penahanan_dataumum/'.$pihak_id.'/'.$perkara_id);
	}
	
	// == didisable sementara. jika sudah ketemu cara pakai jsonnya, tinggal enable lagi
	// function hapus_penahanan(){
		// if(empty($_POST)){
			// show_404();
		// }
		// if($this->session->userdata('is_logged_in')==FALSE){
			// echo json_encode(array('st'=>0,'msg'=>'Anda Belum Login, Silahkan Login Terlebih Dahulu.'));
			// return;
		// }
		
		// $idpenahanan = $this->encrypt->decode(base64_decode($this->input->post('penahanan_id')));
		// if(!is_numeric($idpenahanan) OR !intval($idpenahanan)>0){
			// echo json_encode(array('st'=>0,'msg'=>'Data Penahanan Tidak Ditemukan.'));
			// return;
		// }
		
		// $perkara_id=$this->input->post('perkara_id', TRUE);
		// $pihak_id=$this->input->post('pihak_id', TRUE);
				
		// $this->load->model('penahanan/add_penahanan_m');
		// if($this->add_penahanan_m->hapus_penahanan($idpenahanan)){
			// echo json_encode(array('st'=>1,'msg'=>'Penghapusan Data Penahanan Berhasil'));
			// return;
		// }else{
			// echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Berhasil'));
			// return;
		// }
	// }	
	
	public function search(){
		if (isset($_get['terms'])){
			$res = $this->add_penahanan_m->search($_get['terms']);
			if (count($res)>0){
				foreach ($res as $key) {
					$arr_result[]=$key->nomor_perkara;
					echo $key->nomor_perkara;
				}
				echo json_encode($arr_result);
			}	
		}
	}

	function add_data_template_dibantar($perkara_id,$pihak_id,$penahanan_id){
		//get variables
		$data['perkara_id']=$this->encrypt->decode(base64_decode($perkara_id));
		$data['pihak_id']=$this->encrypt->decode(base64_decode($pihak_id));
		$data['penahanan_id']=$this->encrypt->decode(base64_decode($penahanan_id));;
		$data['cek_bantar']=$this->add_penahanan_m->cek_bantar($data['perkara_id'],$data['pihak_id'],$data['penahanan_id']);
			if($data['cek_bantar']>0){
				$data_template_bantar = $this->add_penahanan_m->get_data_template_bantar($data['perkara_id'],$data['pihak_id'],$data['penahanan_id']);
				if(!empty($data_template_bantar)){
					foreach ($data_template_bantar->result() as $row) {
						$data['tanggal_permohonan']=$row->tanggal_permohonan;
						$data['nomor_permohonan']=$row->nomor_permohonan;
						$data['nama_dokter']=$row->nama_dokter;
						$data['nama_rumah_sakit']=$row->rumah_sakit;
						$data['tanggal_mulai_bantar']=$row->tanggal_mulai;
						$data['alasan']=$row->alasan;
						$data['id_template_bantar']=$row->id;
					}
				}				
			}

		$data['current_date'] = date('d/m/Y');
		$this->load->view('penahanan_list/add_data_template_penahanan', $data);
	}

	function input_data_bantar(){
		// $this->nativesession->set_flash_session('url_requested', current_url());
		$post=$this->input->post();
		if(empty($post)){
			show_404();
		}else{
			if($this->nativesession->get_flash_session('security')==FALSE){
				redirect('main');
			}
			$this->nativesession->set_flash_session('security', TRUE);
			if($this->session->userdata('is_logged_in')==FALSE){
				echo json_encode(array('st'=>0,'msg'=>'Anda Belum Login, Silahkan Login Terlebih Dahulu.'));
				return;
			}

			$perkara_id = $this->input->post('perkara_id', TRUE);
			$pihak_id = $this->input->post('pihak_id', TRUE);
			$penahanan_id = $this->input->post('penahanan_id', TRUE);
			
			$data['cek_bantar']=$this->add_penahanan_m->cek_bantar($perkara_id, $pihak_id,$penahanan_id);

			$tanggal_permohonan=$this->tanggalhelper->convertToMysqlDate($this->input->post('tanggal_permohonan', TRUE));
			$nomor_permohonan = $this->input->post('nomor_permohonan', TRUE);
			$nama_dokter = $this->input->post('nama_dokter', TRUE);
			$nama_rumah_sakit = $this->input->post('nama_rumah_sakit', TRUE);
			$tanggal_mulai_bantar=$this->tanggalhelper->convertToMysqlDate($this->input->post('tanggal_mulai_bantar', TRUE));
			$alasan = $this->input->post('alasan', TRUE);
	
			//simpan data
			$curr_date = date('Y-m-d');
			$todayDate = date('m/d/Y');

			if($data['cek_bantar']>0){
				$data_update=array(
					'nomor_permohonan'=>$nomor_permohonan, 
					'tanggal_permohonan'=>$tanggal_permohonan, 
					'alasan'=>$alasan,
					'tanggal_mulai'=>$tanggal_mulai_bantar,
					'diinput_oleh'=>$this->session->userdata('username', TRUE),
					'diinput_tanggal'=>date('Y-m-d H:i:s')
				); 
			}else{
				$data_insert=array(
					'perkara_id'=>$perkara_id,
					'pihak_id'=>$pihak_id, 
					'penahanan_id'=>$penahanan_id, 
					'nomor_permohonan'=>$nomor_permohonan, 
					'tanggal_permohonan'=>$tanggal_permohonan, 
					'nama_dokter'=>$nama_dokter,
					'rumah_sakit'=>$nama_rumah_sakit,
					'alasan'=>$alasan,
					'tanggal_mulai'=>$tanggal_mulai_bantar,
					'diinput_oleh'=>$this->session->userdata('username', TRUE),
					'diinput_tanggal'=>date('Y-m-d H:i:s')
					);
			}

			$enc_pihak_id=base64_encode($this->encrypt->encode($pihak_id));
			$enc_perkara_id=base64_encode($this->encrypt->encode($perkara_id));
			if($data['cek_bantar']>0){
				$this->add_penahanan_m->update_data_bantar_template($data_update,$perkara_id,$pihak_id,$penahanan_id);	
				redirect('detail_penahanan_dataumum/'.$enc_pihak_id.'/'.$enc_perkara_id);
			}else{
				$this->add_penahanan_m->insert_data_bantar_template($data_insert);	
				redirect('detail_penahanan_dataumum/'.$enc_pihak_id.'/'.$enc_perkara_id);
			}
			
		}		
	}

	function hapus_template_bantar($perkara_id,$pihak_id,$id_template_bantar){
 		$enc_pihak_id=base64_encode($this->encrypt->encode($pihak_id));
		$enc_perkara_id=base64_encode($this->encrypt->encode($perkara_id));

		$this->add_penahanan_m->hapus_data_bantar($id_template_bantar);
		redirect('detail_penahanan_dataumum/'.$enc_pihak_id.'/'.$enc_perkara_id);
	}	

	function add_data_template_ditangguhkan($perkara_id,$pihak_id,$penahanan_id){
		//get variables
		$data['perkara_id']=$this->encrypt->decode(base64_decode($perkara_id));
		$data['pihak_id']=$this->encrypt->decode(base64_decode($pihak_id));
		$data['penahanan_id']=$this->encrypt->decode(base64_decode($penahanan_id));;
		$data['cek_bantar']=$this->add_penahanan_m->cek_bantar($data['perkara_id'],$data['pihak_id'],$data['penahanan_id']);
			if($data['cek_bantar']>0){
				$data_template_bantar = $this->add_penahanan_m->get_data_template_bantar($data['perkara_id'],$data['pihak_id'],$data['penahanan_id']);
				if(!empty($data_template_bantar)){
					foreach ($data_template_bantar->result() as $row) {
						$data['tanggal_permohonan']		=$row->tanggal_permohonan;
						$data['nomor_permohonan']		=$row->nomor_permohonan;
						$data['jenis_jaminan']			=$row->jenis_jaminan;
						$data['tanggal_perjanjian']		=$row->tanggal_perjanjian;
						$data['nomor_perjanjian']		=$row->nomor_perjanjian;
						$data['pihak_penjamin_id']		=$row->pihak_penjamin_id;
						$data['uang_jaminan']			=$row->uang_jaminan;
						$data['nomor_bukti_setoran']	=$row->nomor_bukti_setoran;
						$data['pertimbangan']			=$row->pertimbangan;
						$data['id_template_bantar']		=$row->id;
						$data['enc_pihak']				= base64_encode($this->encrypt->encode($row->pihak_penjamin_id));
					}
				}				
			}

			if($data['pihak_penjamin_id']>0){
				$data_penjamin = $this->add_penahanan_m->get_data_penjamin($data['pihak_penjamin_id'],$data['tanggal_permohonan']);
				if(!empty($data_penjamin)){
					foreach ($data_penjamin->result() as $row) {
						$data['nama']=$row->nama;
						$data['tempatLahir']=$row->tempat_lahir;
						$data['tglLahir']=$row->tanggal_lahir;
						$data['umur']=$row->umur;
						$data['sex']=$row->jenis_kelamin;
						$data['wargaNegara']=$row->nama_negara;
						$data['alamat']=$row->alamat;
						$data['pekerjaan']=$row->pekerjaan;
					}
				}				
			}


		$data['current_date'] = date('d/m/Y');
		$this->load->view('penahanan_list/add_data_template_penangguhan', $data);
	}	

	function input_data_penangguhan(){
		// $this->nativesession->set_flash_session('url_requested', current_url());
		if($this->nativesession->get_flash_session('security')==FALSE){
			redirect('main');
		}
		$this->nativesession->set_flash_session('security', TRUE);
		if($this->session->userdata('is_logged_in')==FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Anda Belum Login, Silahkan Login Terlebih Dahulu.'));
			return;
		}
		$post=$this->input->post();
		if(empty($post)){
			show_404();
		}
		$this->form_validation->set_rules('tanggal_permohonan', 'Tanggal Permohonan', 'trim|required|xss_clean');
		$this->form_validation->set_rules('nomor_permohonan', 'Nomor Permohonan', 'trim|required|xss_clean');
		if($this->input->post('jaminan')=='1' OR $this->input->post('jaminan')=='2'){
			$this->form_validation->set_rules('tanggal_perjanjian', 'Tanggal Perjanjian', 'trim|required|xss_clean');
			$this->form_validation->set_rules('nomor_perjanjian', 'Nomor Perjanjian', 'trim|required|xss_clean');
			$this->form_validation->set_rules('uang_jaminan', 'Uang Jaminan', 'trim|required|xss_clean');
		}
		if($this->input->post('jaminan')=='1'){
			$this->form_validation->set_rules('fullname', 'Nama Penjamin', 'trim|required|xss_clean');
			$this->form_validation->set_rules('tempat_lahir', 'Tempat Lahir', 'trim|required|xss_clean');
			$this->form_validation->set_rules('tgl_lahir', 'Tanggal Lahir', 'trim|required|xss_clean');
			$this->form_validation->set_rules('umur', 'Umum', 'trim|required|xss_clean');
			$this->form_validation->set_rules('jenis_kelamin', 'Jenis Kelamin', 'trim|required|xss_clean');
			$this->form_validation->set_rules('warga_negara', 'Warga Negara', 'trim|required|xss_clean');
			$this->form_validation->set_rules('alamat', 'Alamat', 'trim|required|xss_clean');
			$this->form_validation->set_rules('pekerjaan', 'Pekerjaan', 'trim|required|xss_clean');			
		}
		if($this->input->post('jaminan')=='2'){
			$this->form_validation->set_rules('nomor_bukti_setoran', 'Nomor Bukti Setoran', 'trim|required|xss_clean');
			$this->form_validation->set_rules('tanggal_bukti_setoran', 'Tanggal Bukti Setoran', 'trim|required|xss_clean');			
		}
		if($this->input->post('jaminan')=='3'){
			$this->form_validation->set_rules('pertimbangan', 'Pertimbangan', 'trim|required|xss_clean');			
		}
		if ($this->form_validation->run() === FALSE){
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Berhasil '.validation_errors()));
			return;
		}else{			
			$perkara_id = $this->input->post('perkara_id', TRUE);
			$pihak_id = $this->input->post('pihak_id', TRUE);
			$enc_pihak = $this->input->post('enc_pihak', TRUE);
			$penahanan_id = $this->input->post('penahanan_id', TRUE);
			
			$data['cek_bantar']=$this->add_penahanan_m->cek_bantar($perkara_id, $pihak_id,$penahanan_id);

			$tanggal_permohonan=$this->tanggalhelper->convertToMysqlDate($this->input->post('tanggal_permohonan', TRUE));
			$nomor_permohonan = $this->input->post('nomor_permohonan', TRUE);
			$jenis_jaminan = $this->input->post('jaminan', TRUE);
			if($jenis_jaminan==1 OR $jenis_jaminan==2){
				$tanggal_perjanjian=$this->tanggalhelper->convertToMysqlDate($this->input->post('tanggal_perjanjian', TRUE));
				$nomor_perjanjian = $this->input->post('nomor_perjanjian', TRUE);
				$uang_jaminan = $this->input->post('uang_jaminan', TRUE);
			}else{
				$tanggal_perjanjian= NULL;
				$nomor_perjanjian = NULL;
				$uang_jaminan = NULL;
			}
			if($jenis_jaminan==1){
				$pihak_penjamin_id = $this->encrypt->decode(base64_decode($enc_pihak));
				$nomor_bukti = NULL;
				$tanggal_bukti = NULL;
				$pertimbangan = NULL;
			}elseif($jenis_jaminan==2){
				$pihak_penjamin_id = NULL;
				$nomor_bukti = $this->input->post('nomor_bukti_setoran', TRUE);
				$tanggal_bukti = $this->tanggalhelper->convertToMysqlDate($this->input->post('tanggal_bukti_setoran', TRUE));
				$pertimbangan = NULL;
			}else{
				$pihak_penjamin_id = NULL;
				$nomor_bukti = NULL;
				$tanggal_bukti = NULL;
				$pertimbangan = $this->input->post('pertimbangan', TRUE);
			}
			//simpan data
			$curr_date = date('Y-m-d');
			$todayDate = date('m/d/Y');

			if($data['cek_bantar']>0){
				$data_update=array(
					'pihak_penjamin_id'=>$pihak_penjamin_id, 
					'nomor_permohonan'=>$nomor_permohonan, 
					'tanggal_permohonan'=>$tanggal_permohonan, 
					'jenis_jaminan'=>$jenis_jaminan,
					'nomor_perjanjian'=>$nomor_perjanjian, 
					'tanggal_perjanjian'=>$tanggal_perjanjian, 
					'uang_jaminan'=>$uang_jaminan,
					'nomor_bukti_setoran'=>$nomor_bukti,
					'tanggal_bukti_setoran'=>$tanggal_bukti,
					'pertimbangan'=>$pertimbangan,
					'diinput_oleh'=>$this->session->userdata('username', TRUE),
					'diinput_tanggal'=>date('Y-m-d H:i:s')
				); 
			}else{
				$data_insert=array(
					'perkara_id'=>$perkara_id,
					'pihak_id'=>$pihak_id, 
					'pihak_penjamin_id'=>$pihak_penjamin_id, 
					'penahanan_id'=>$penahanan_id, 
					'nomor_permohonan'=>$nomor_permohonan, 
					'tanggal_permohonan'=>$tanggal_permohonan,
					'jenis_jaminan'=>$jenis_jaminan, 
					'nomor_perjanjian'=>$nomor_perjanjian, 
					'tanggal_perjanjian'=>$tanggal_perjanjian, 
					'uang_jaminan'=>$uang_jaminan,
					'nomor_bukti_setoran'=>$nomor_bukti,
					'tanggal_bukti_setoran'=>$tanggal_bukti,
					'pertimbangan'=>$pertimbangan,
					'diinput_oleh'=>$this->session->userdata('username', TRUE),
					'diinput_tanggal'=>date('Y-m-d H:i:s')
					);
			}

			$enc_pihak_id=base64_encode($this->encrypt->encode($pihak_id));
			$enc_perkara_id=base64_encode($this->encrypt->encode($perkara_id));
			if($data['cek_bantar']>0){
				$this->add_penahanan_m->update_data_bantar_template($data_update,$perkara_id,$pihak_id,$penahanan_id);	
				redirect('detail_penahanan_dataumum/'.$enc_pihak_id.'/'.$enc_perkara_id);
			}else{
				$this->add_penahanan_m->insert_data_bantar_template($data_insert);	
				redirect('detail_penahanan_dataumum/'.$enc_pihak_id.'/'.$enc_perkara_id);
			}
			
		}		
	}


}
/* End of file addPenahanan_c.php */
/* Location: ./application/controllers/addPenahanan_c.php */