<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class addPanitera_c extends CI_Controller {
	
	function __construct() {
	    parent::__construct();
	    $this->load->model('penetapan/add_panitera_m');
	}

	function index(){		
	}

	function f_add_panitera(){
		if($this->session->userdata('is_logged_in')==FALSE){
			redirect('login');
		}
		
		$data['current_date'] = date('d/m/Y');
		$data['perkara_id'] = $this->nativesession->get_flash_session('perkara_id');
		if (!is_numeric($data['perkara_id']) OR $data['perkara_id']<0){
			show_404();
			exit();
		}
		$data['enc'] = $this->nativesession->get_flash_session('enc');
		$jenisP = $this->session->userdata('jenis_pengadilan');
		$data['perkara'] = $this->add_panitera_m->get_no_perkara($data['perkara_id']);
		$data['perkara_penetapan'] = $this->add_panitera_m->get_data_penetapan($data['perkara_id']);
		$data['action'] = 'add';
		if($jenisP==2){
			$pilih_panitera = 'Pilih Panitera';
		}elseif($jenisP==1 OR $jenisP==3){
			$pilih_panitera = 'Pilih Panitera Pengganti';
		}
		$Pilih_Panitera = '';
		$list = array('0'=>$Pilih_Panitera);		
		$res = $this->add_panitera_m->get_data_panitera_aktif();
		foreach ($res as $row){
			$list[$row['id']] = $row['nama_gelar'];
		};
		$data['data_panitera']=$list;
		$data['namahalaman']="TAMBAH PENUNJUKAN PANITERA/PANITERA PENGGANTI";
		$this->load->view('perkara_tab/penetapan/edit_panitera_v', $data);
	}

	function f_edit_panitera(){
		if($this->session->userdata('is_logged_in')==FALSE){
			redirect('login');
		}
		
		$data['current_date'] = date('d/m/Y');
		$data['perkara_id'] = $this->nativesession->get_flash_session('perkara_id');
		if (!is_numeric($data['perkara_id']) OR $data['perkara_id']<0){
			show_404();
			exit();
		}
		$data['enc'] = $this->nativesession->get_flash_session('enc');
		$jenisP = $this->session->userdata('jenis_pengadilan');
		$data['perkara'] = $this->add_panitera_m->get_no_perkara($data['perkara_id']);
		$data['perkara_penetapan'] = $this->add_panitera_m->get_data_penetapan($data['perkara_id']);
		if($jenisP==2){
			$pilih_panitera = 'Pilih Panitera';
		}elseif($jenisP==1 OR $jenisP==3){
			$pilih_panitera = 'Pilih Panitera Pengganti';
		}
		$list = array('0'=>'Pilih Panitera');
		$res = $this->add_panitera_m->get_data_panitera_aktif();
		foreach ($res as $row){
			$list[$row['id']] = $row['nama_gelar'];
		};
		$data['data_panitera']=$list;
		$data['data_penetapan'] = $this->add_panitera_m->get_data_penetapan($data['perkara_id']);
		$data['data_panitera_detail'] = $this->add_panitera_m->get_data_panitera_detail($data['perkara_id']);
		$data['action'] = 'edit';
		$data['cek_status'] = $this->add_panitera_m->getStatusPP($data['perkara_id']);
		$data['namahalaman']="EDIT PENUNJUKAN PANITERA/PANITERA PENGGANTI";
		$this->load->view('perkara_tab/penetapan/edit_panitera_v', $data);
	}


	function f_penunjukan_kembali(){
		if($this->session->userdata('is_logged_in')==FALSE){
			redirect('login');
		}
		
		$data['current_date'] = date('d/m/Y');
		$data['perkara_id'] = $this->nativesession->get_flash_session('perkara_id');
		if (!is_numeric($data['perkara_id']) OR $data['perkara_id']<0){
			show_404();
			exit();
		}
		$data['enc'] = $this->nativesession->get_flash_session('enc');
		$jenisP = $this->session->userdata('jenis_pengadilan');
		$data['perkara'] = $this->add_panitera_m->get_no_perkara($data['perkara_id']);
		$data['perkara_penetapan'] = $this->add_panitera_m->get_data_penetapan($data['perkara_id']);
		if($jenisP==2){
			$pilih_panitera = 'Pilih Panitera';
		}elseif($jenisP==1 OR $jenisP==3){
			$pilih_panitera = 'Pilih Panitera Pengganti';
		}
		$list = array('0'=>'Pilih Panitera');
		$res = $this->add_panitera_m->get_data_panitera_aktif();
		foreach ($res as $row){
			$list[$row['id']] = $row['nama_gelar'];
		};
		$data['data_panitera']=$list;
		$data['cek_status'] = $this->add_panitera_m->getStatusPP($data['perkara_id']);
		$data['namahalaman']="PENUNJUKAN KEMBALI PANITERA/PANITERA PENGGANTI";
		$this->load->view('perkara_tab/penetapan/penunjukan_kembali_panitera_v', $data);
	}
	
	function f_validate_input_add(){
		$post=$this->input->post();
		if(empty($post)){
			show_404();
		}
		if($this->session->userdata('is_logged_in')==FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Anda Belum Login, Silahkan Login Terlebih Dahulu.'));
			return;
		}

		$this->form_validation->set_rules('tgl_penunjukan_panitera', 'Tanggal Penunjukan Panitera', 'trim|required|xss_clean|exact_length[10]');
		$this->form_validation->set_rules('panitera1', 'Panitera Pengganti', 'numeric|required|xss_clean|callback_f_panitera_id_check');
		

		if ($this->form_validation->run() == FALSE){
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Berhasil '.validation_errors()));
			return;
		}else{
			//simpan data panitera
			$idperkara = $this->encrypt->decode(base64_decode($this->input->post('enc',TRUE)));

			$curr_date = date('Y-m-d');
			$todayDate = date('d/m/Y');
			
			$date_penetapan_hakim = $this->add_panitera_m->get_penetapan_hakim_pertama($idperkara)->penetapan_majelis_hakim;
			$tgl_penetapan_panitera = $this->input->post('tgl_penunjukan_panitera');
			$tgl_penetapan_panitera = $this->tanggalhelper->convertToMysqlDate($tgl_penetapan_panitera);

			if($tgl_penetapan_panitera==false){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Format Tanggal Tidak Benar. Format tanggal hari/bulan/tahun. Contoh 20/01/2015.'));
				return;
			}
			$selisih = $this->tanggalhelper->getSelisihHari($tgl_penetapan_panitera,$curr_date);
			if($selisih<0){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Penunjukan Panitera Pengganti Tidak Boleh Melebihi Hari Ini. Hari ini Tanggal '.$todayDate));
				return;
			}
			$selisih = $this->tanggalhelper->getSelisihHari($date_penetapan_hakim,$tgl_penetapan_panitera);
			if($date_penetapan_hakim>$tgl_penetapan_panitera){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Penunjukan Panitera Pengganti Tidak Boleh Kurang dari Tanggal Penetapan Majelis Hakim.'));
				return;
			}

			$dayname = $this->tanggalhelper->getDayName($tgl_penetapan_panitera);
			if($dayname=='Saturday' OR $dayname=='Sunday'){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Dapat Memilih Tanggal Penunjukan Panitera Pengganti Hakim Dihari Libur, Sabtu dan Minggu.'));
				return;
			}

			$panitera1 = $this->input->post('panitera1', TRUE);
			$this->panitera_id = $panitera1;
			if (intval($this->input->post('panitera2', TRUE))<>0){
				$panitera2 = $this->input->post('panitera2', TRUE);
				$this->panitera_id .= ",".$this->input->post('panitera2', TRUE);
			}
			if (intval($this->input->post('panitera3', TRUE))<>0){
				$panitera3 = $this->input->post('panitera3', TRUE);
				$this->panitera_id .= ",".$this->input->post('panitera3', TRUE);
			}
			$keterangan = $this->input->post('keterangan');
			if('keterangan'==''){
				$keterangan=null;
			}
			$this->keterangan = $keterangan;
			$namahalaman=$this->input->post('namahalaman', TRUE);
			$this->add_panitera_m->insert_penunjukan_panitera($idperkara, $tgl_penetapan_panitera);
			$this->load->model('riwayatperkara/riwayat_perkara_m');
			$this->riwayat_perkara_m->updateproses($idperkara,'30',$tgl_penetapan_panitera,'',$namahalaman,1);
			echo json_encode(array('st'=>1,'msg'=>'Data Penunjukan Berhasil Disimpan'));
		}
	}

	function f_validate_input_edit(){
		$post=$this->input->post();
		if(empty($post)){
			show_404();
		}

		if($this->session->userdata('is_logged_in')==FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Anda Belum Login, Silahkan Login Terlebih Dahulu.'));
			return;
		}

		$this->form_validation->set_rules('tgl_penunjukan_panitera', 'Tanggal Penunjukan Panitera', 'trim|required|xss_clean|exact_length[10]');
		$this->form_validation->set_rules('panitera1', 'Panitera Pengganti', 'numeric|required|xss_clean|callback_f_panitera_id_check');
		

		if ($this->form_validation->run() === FALSE){
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Berhasil '.validation_errors()));
			return;
		}else{
			//simpan data panitera
			$idperkara = $this->encrypt->decode(base64_decode($this->input->post('enc',TRUE)));
			
			$curr_date = date('Y-m-d');
			$todayDate = date('d/m/Y');

			$date_penetapan_hakim = $this->add_panitera_m->get_penetapan_hakim_pertama($idperkara)->penetapan_majelis_hakim;
			$tgl_penetapan_panitera = $this->input->post('tgl_penunjukan_panitera');
			$tgl_penetapan_panitera = $this->tanggalhelper->convertToMysqlDate($tgl_penetapan_panitera);

			if($tgl_penetapan_panitera==false){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Format Tanggal Tidak Benar. Format tanggal hari/bulan/tahun. Contoh 20/01/2015.'));
				return;
			}
			$selisih = $this->tanggalhelper->getSelisihHari($tgl_penetapan_panitera,$curr_date);
			if($selisih<0){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Penunjukan Panitera Pengganti Tidak Boleh Melebihi Hari Ini. Hari ini Tanggal '.$todayDate));
				return;
			}
			$selisih = $this->tanggalhelper->getSelisihHari($date_penetapan_hakim,$tgl_penetapan_panitera);
			if($date_penetapan_hakim>$tgl_penetapan_panitera){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Penunjukan Panitera Pengganti Tidak Boleh Kurang dari Tanggal Penetapan Majelis Hakim.'));
				return;
			}

			$dayname = $this->tanggalhelper->getDayName($tgl_penetapan_panitera);
			if($dayname=='Saturday' OR $dayname=='Sunday'){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Dapat Memilih Tanggal Penunjukan Panitera Pengganti Hakim Dihari Libur, Sabtu dan Minggu.'));
				return;
			}


			$panitera1 = $this->input->post('panitera1', TRUE);
			$this->panitera_id = $panitera1;
			if (intval($this->input->post('panitera2', TRUE))<>0){
				$panitera2 = $this->input->post('panitera2', TRUE);
				$this->panitera_id .= ",".$this->input->post('panitera2', TRUE);
			}
			if (intval($this->input->post('panitera3', TRUE))<>0){
				$panitera3 = $this->input->post('panitera3', TRUE);
				$this->panitera_id .= ",".$this->input->post('panitera3', TRUE);
			}
			$panitera_sebelumnya_id = $this->input->post('panitera_sebelumnya_id', TRUE);
			$tanggalinput = $this->add_panitera_m->get_jumlah_tanggal_input($idperkara);

			$keterangan = $this->input->post('keterangan');
			if('keterangan'==''){
				$keterangan=null;
			}
			$this->keterangan = $keterangan;
			$namahalaman=$this->input->post('namahalaman', TRUE);
			$this->load->model('riwayatperkara/riwayat_perkara_m');
			$jml_row=$tanggalinput->num_rows();
			if($jml_row > 1){
				$tanggal_penunjukan_sebelumnya=$tanggalinput->row($jml_row-1)->tanggal_penetapan;
				$selisih = $this->tanggalhelper->getSelisihHari($tanggal_penunjukan_sebelumnya,$tgl_penetapan_panitera);
				if($selisih<0){
					echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Penunjukan Panitera Pengganti Tidak Boleh Sebelum '.$this->tanggalhelper->convertDayDate($tanggal_penunjukan_sebelumnya)));
					return;
				}else{
					$this->add_panitera_m->edit_penunjukan_panitera($idperkara, $tgl_penetapan_panitera, $panitera_sebelumnya_id,1,$namahalaman);
					$this->riwayat_perkara_m->updateproses($idperkara,'31',$tgl_penetapan_panitera,'',$namahalaman,1);
				}
			}else{
				$this->add_panitera_m->edit_penunjukan_panitera($idperkara, $tgl_penetapan_panitera, $panitera_sebelumnya_id,0,$namahalaman);
				$this->riwayat_perkara_m->updateproses($idperkara,'30',$tgl_penetapan_panitera,'',$namahalaman,1);
			}
									
			echo json_encode(array('st'=>1,'msg'=>'Data Penunjukan Berhasil Disimpan'));
		}
	}
	
	function f_validate_input_penunjukan_kembali(){
		$post=$this->input->post();
		if(empty($post)){
			show_404();
		}
		if($this->session->userdata('is_logged_in')==FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Anda Belum Login, Silahkan Login Terlebih Dahulu.'));
			return;
		}

		$this->form_validation->set_rules('tgl_penunjukan_panitera', 'Tanggal Penunjukan Panitera', 'trim|required|xss_clean');
		$this->form_validation->set_rules('panitera1', 'Panitera Pengganti', 'numeric|required|xss_clean|callback_f_panitera_id_check');
		
		if ($this->form_validation->run() === FALSE){
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Berhasil '.validation_errors()));
			return;
		}else{
			//simpan data panitera
			$idperkara = $this->encrypt->decode(base64_decode($this->input->post('enc',TRUE)));

			$curr_date = date('Y-m-d');
			$todayDate = date('d/m/Y');

			$date_penunjukkan_kembali = $this->add_panitera_m->get_penetapan_hakim_pertama($idperkara)->penetapan_panitera_pengganti;
			$tgl_penetapan_panitera = $this->input->post('tgl_penunjukan_panitera');
			$tgl_penetapan_panitera = $this->tanggalhelper->convertToMysqlDate($tgl_penetapan_panitera);

			if($tgl_penetapan_panitera==false){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Format Tanggal Tidak Benar. Format tanggal hari/bulan/tahun. Contoh 20/01/2015.'));
				return;
			}
			$selisih = $this->tanggalhelper->getSelisihHari($tgl_penetapan_panitera,$curr_date);
			if($selisih<0){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Penunjukan Panitera Pengganti Tidak Boleh Melebihi Hari Ini. Hari ini Tanggal '.$todayDate));
				return;
			}
			$selisih = $this->tanggalhelper->getSelisihHari($date_penunjukkan_kembali,$tgl_penetapan_panitera);
			if($date_penunjukkan_kembali>$tgl_penetapan_panitera){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Penunjukan Kembali Panitera Pengganti Tidak Boleh Kurang dari Tanggal Penunjukkan Pertama Panitera Pengganti.'));
				return;
			}

			$dayname = $this->tanggalhelper->getDayName($tgl_penetapan_panitera);
			if($dayname=='Saturday' OR $dayname=='Sunday'){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Dapat Memilih Tanggal Penunjukan Panitera Pengganti Hakim Dihari Libur, Sabtu dan Minggu.'));
				return;
			}

			$panitera1 = $this->input->post('panitera1',TRUE);
			$this->panitera_id = $panitera1;
			if (intval($this->input->post('panitera2',TRUE))<>0){
				$panitera2 = $this->input->post('panitera2',TRUE);
				$this->panitera_id .= ",".$this->input->post('panitera2',TRUE);
			}
			if (intval($this->input->post('panitera3',TRUE))<>0){
				$panitera3 = $this->input->post('panitera3',TRUE);
				$this->panitera_id .= ",".$this->input->post('panitera3',TRUE);
			}

			$keterangan = $this->input->post('keterangan');
			if('keterangan'==''){
				$keterangan=null;
			}
			$this->keterangan = $keterangan;
			$namahalaman=$this->input->post('namahalaman', TRUE);			
			
			$this->add_panitera_m->insert_penunjukan_kembali_panitera($idperkara, $tgl_penetapan_panitera,$namahalaman);
			$this->load->model('riwayatperkara/riwayat_perkara_m');
			$this->riwayat_perkara_m->updateproses($idperkara,'31',$tgl_penetapan_panitera,'',$namahalaman,1);
			echo json_encode(array('st'=>1,'msg'=>'Data Penunjukan Berhasil Disimpan'));
		}
	}

	function f_panitera_id_check($str){
		if (intval($str)==0){
			$this->form_validation->set_message('f_panitera_id_check', 'Kolom %s Tidak Boleh Kosong');
			return FALSE;
		}else{
			return TRUE;
		}
	}

	function del_penetapan(){
		if($this->nativesession->is_flash_session('security')==FALSE){
			redirect('main');
		}

		if($this->session->userdata('is_logged_in')==FALSE){
			redirect('login');
		}
		$idperkara = $this->nativesession->get_flash_session('perkara_id');

		if (!is_numeric($idperkara) OR $idperkara<0){
			show_404();
			exit();
		}

		$tanggalinput = $this->add_panitera_m->get_tanggal_input($idperkara);
		if($tanggalinput==FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Data Penetapan Panitera Pengganti Tidak Ditemukan'));
			return;
		}
		$dohapus = FALSE;
		$namahalaman=$this->input->post('namahalaman', TRUE);			
		if($tanggalinput->num_rows ==1){
			$tglpenetapan = $this->add_panitera_m->get_tanggal_penetapan($idperkara);
			if($tglpenetapan!=FALSE){
				if($tglpenetapan->num_rows>0){
					foreach ($tglpenetapan->result() as $row) {
						$tglpenetapanjurusita = $row->penetapan_jurusita;
						$tglpenetapansidang = $row->penetapan_hari_sidang;
					}
					if(!empty($tglpenetapansidang)){
						echo json_encode(array('st'=>0,'msg'=>'Data Penetapan Panitera Pengganti Tidak Dapat Dihapus. Tanggal Sidang Pertama Sudah Ditentukan.'));
						return;
					}
					if(!empty($tglpenetapanjurusita)){
						echo json_encode(array('st'=>0,'msg'=>'Data Penetapan Panitera Pengganti Tidak Dapat Dihapus. Jurusita Telah Ditentukan.'));
						return;
					}
				}

				$jumlahsidang = $this->add_panitera_m->get_jumlah_sidang($idperkara);
				if($jumlahsidang>0){
					echo json_encode(array('st'=>0,'msg'=>'Data Penetapan Panitera Pengganti Tidak Dapat Dihapus. Perkara Telah Memasuki Proses Persidangan.'));
					return;
				}else{
					$tahapan = $this->add_panitera_m->get_tahapan($idperkara);
					if($tahapan>12){
						echo json_encode(array('st'=>0,'msg'=>'Data Penetapan Panitera Pengganti Tidak Dapat Dihapus. Perkara Telah Memasuki Proses Lebih Tinggi.'));
						return;
					}
				}
				$hapusdata = $this->add_panitera_m->hapus_all_penetapan($idperkara,$namahalaman);
				if($hapusdata){
					$this->load->model('riwayatperkara/riwayat_perkara_m');
					$this->riwayat_perkara_m->updateproses($idperkara,'30','','',$namahalaman,2);
					echo json_encode(array('st'=>1,'msg'=>'Data Penetapan Berhasil Dihapus'));
					return;
				}else{
					echo json_encode(array('st'=>0,'msg'=>'Gagal Menghapus Penetapan Panitera Pengganti'));
					return;
				}
			}else{
				echo json_encode(array('st'=>0,'msg'=>'Something Wrong with The Database.'));
				return;
			}
		}else{
			$i=0;
			$ids = array();
			$idUpdate = array();
			$urutan=0;
			$tanggal_sebelumnya='';
			foreach ($tanggalinput->result() as $row) {
				if ($row->aktif=='Y'){
					$ids[] = $row->id;
				}else{
					if ($tanggal_sebelumnya=='' || $tanggal_sebelumnya==$row->tanggal){
						$idUpdate[] = $row->id;	
						$urutan=$row->urutan;
					}else{
						if ($urutan==1){
							break;
						}else{
							$idUpdate[] = $row->id;	
							$urutan=$row->urutan;
						}
					}
					$tanggal_sebelumnya=$row->tanggal;
				}
				$i++;
			}
			$hapusdata = $this->add_panitera_m->hapus_penetapan($idperkara,$ids,$idUpdate,$namahalaman);
			$datasebelum=$this->add_panitera_m->get_jumlah_tanggal_input($idperkara);
			if($hapusdata){
				$this->load->model('riwayatperkara/riwayat_perkara_m');
				$this->riwayat_perkara_m->updateproses($idperkara,'31','','',$namahalaman,2);
				if($tanggalinput->num_rows >2){
					$this->riwayat_perkara_m->updateproses($idperkara,'31',$datasebelum->row(0)->tanggal_penetapan,'',$namahalaman,1);
				}
				echo json_encode(array('st'=>1,'msg'=>'Data Penetapan Berhasil Dihapus'));
				return;
			}else{
				echo json_encode(array('st'=>0,'msg'=>'Gagal Menghapus Penetapan Panitera Pengganti'));
				return;
			}
		}
	}
}