<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class addJuruSita_c extends CI_Controller {
	
	function __construct() {
	    parent::__construct();
	    $this->load->model('penetapan/add_juru_sita_m');
	}

	function index(){
		
	}

	function f_add_juru_sita(){
		if($this->nativesession->get_flash_session('security')==FALSE){
			redirect('main');
		}
		$this->nativesession->set_flash_session('security', TRUE);

		if($this->session->userdata('is_logged_in')==FALSE){
			redirect('login');
		}
		
		$data['current_date'] = date('d/m/Y');
		$data['perkara_id'] = $this->nativesession->get_flash_session('perkara_id');
		if (!is_numeric($data['perkara_id']) OR $data['perkara_id']<0){
			show_404();
			exit();
		}
		$data['enc'] = $this->nativesession->get_flash_session('enc');
		
		$data['perkara'] = $this->add_juru_sita_m->get_no_perkara($data['perkara_id']);
		$data['perkara_penetapan'] = $this->add_juru_sita_m->get_data_penetapan($data['perkara_id']);
		$data['action'] = 'add';
		$list = array('0'=>'Pilih Jurusita Pengganti');
		$res = $this->add_juru_sita_m->get_data_juru_sita_aktif();
		foreach ($res as $row){
			$list[$row['id']] = $row['nama_gelar'];
		};
		$data['data_juru_sita']=$list;
		$data['namahalaman']="TAMBAH PENUNJUKAN JURUSITA/JURUSITA PENGGANTI";
		$this->load->view('perkara_tab/penetapan/edit_juru_sita_v', $data);
	}

	function f_edit_juru_sita(){
		if($this->session->userdata('is_logged_in')==FALSE){
			redirect('login');
		}
		
		$data['current_date'] = date('d/m/Y');
		$data['perkara_id'] = $this->nativesession->get_flash_session('perkara_id');
		if (!is_numeric($data['perkara_id']) OR $data['perkara_id']<0){
			show_404();
			exit();
		}
		$data['enc'] = $this->nativesession->get_flash_session('enc');
		
		$data['perkara'] = $this->add_juru_sita_m->get_no_perkara($data['perkara_id']);
		$data['perkara_penetapan'] = $this->add_juru_sita_m->get_data_penetapan($data['perkara_id']);
		$data['arr_jurusita'] = explode(',', $data['perkara_penetapan'][0]['jurusita_id']);
		$data['action'] = 'edit';
		$list = array('0'=>'Pilih Jurusita Pengganti');
		$res = $this->add_juru_sita_m->get_data_juru_sita_aktif();
		foreach ($res as $row){
			$list[$row['id']] = $row['nama_gelar'];
		};
		$data['data_juru_sita']=$list;
		$data['data_jurusita_detail'] = $this->add_juru_sita_m->get_data_juru_sita_detail($data['perkara_id']);
		$data['namahalaman']="EDIT PENUNJUKAN JURUSITA/JURUSITA PENGGANTI";
		$this->load->view('perkara_tab/penetapan/edit_juru_sita_v', $data);
	}

	function f_penunjukan_kembali(){
		if($this->session->userdata('is_logged_in')==FALSE){
			redirect('login');
		}
		
		$data['current_date'] = date('d/m/Y');
		$data['perkara_id'] = $this->nativesession->get_flash_session('perkara_id');
		if (!is_numeric($data['perkara_id']) OR $data['perkara_id']<0){
			show_404();
			exit();
		}
		$data['enc'] = $this->nativesession->get_flash_session('enc');
		
		$data['perkara'] = $this->add_juru_sita_m->get_no_perkara($data['perkara_id']);
		$data['perkara_penetapan'] = $this->add_juru_sita_m->get_data_penetapan($data['perkara_id']);
		$list = array('0'=>'Pilih Jurusita Pengganti');
		$res = $this->add_juru_sita_m->get_data_juru_sita_aktif();
		foreach ($res as $row){
			$list[$row['id']] = $row['nama_gelar'];
		};
		$data['data_juru_sita']=$list;
		$data['namahalaman']="PENUNJUKAN KEMBALI JURUSITA/JURUSITA PENGGANTI";
		$this->load->view('perkara_tab/penetapan/penunjukan_kembali_juru_sita_v', $data);
	}
	
	function f_validate_input_add(){
		$post=$this->input->post();
		if(empty($post)){
			show_404();
		}

		if($this->session->userdata('is_logged_in')==FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Anda Belum Login, Silahkan Login Terlebih Dahulu.'));
			return;
		}

		$this->form_validation->set_rules('tgl_penunjukan_juru_sita', 'Tanggal Penunjukan Jurusita', 'trim|required|xss_clean|exact_length[10]');
		$this->form_validation->set_rules('juru_sita1', 'Jurusita', 'numeric|required|xss_clean|callback_f_juru_sita_id_check');
		

		if ($this->form_validation->run() === FALSE){
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Berhasil '.validation_errors()));
			return;
		}else{
			//simpan data juru_sita
			$idperkara = $this->encrypt->decode(base64_decode($this->input->post('enc',TRUE)));

			$curr_date = date('Y-m-d');
			$todayDate = date('d/m/Y');

			$date_penetapan_panitera = $this->add_juru_sita_m->get_penetapan_panitera($idperkara)->penetapan_panitera_pengganti;
			$tgl_penetapan_juru_sita = $this->input->post('tgl_penunjukan_juru_sita');
			$tgl_penetapan_juru_sita = $this->tanggalhelper->convertToMysqlDate($tgl_penetapan_juru_sita);

			if($tgl_penetapan_juru_sita==false){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Format Tanggal Tidak Benar. Format tanggal hari/bulan/tahun. Contoh 20/01/2015.'));
				return;
			}
			$selisih = $this->tanggalhelper->getSelisihHari($tgl_penetapan_juru_sita,$curr_date);
			if($selisih<0){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Penunjukan Jurusita Tidak Boleh Melebihi Hari Ini. Hari ini Tanggal '.$todayDate));
				return;
			}
			$selisih = $this->tanggalhelper->getSelisihHari($date_penetapan_panitera,$tgl_penetapan_juru_sita);
			if($date_penetapan_panitera>$tgl_penetapan_juru_sita){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Penunjukan Jurusita/Jurusita Pengganti Tidak Boleh Kurang dari Tanggal Penetapan Panitera Pengganti.'));
				return;
			}

			$dayname = $this->tanggalhelper->getDayName($tgl_penetapan_juru_sita);
			if($dayname=='Saturday' OR $dayname=='Sunday'){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Dapat Memilih Tanggal Penunjukan Jurusita Dihari Libur, Sabtu dan Minggu.'));
				return;
			}

			$juru_sita1 = $this->input->post('juru_sita1');
			$this->juru_sita_id = $juru_sita1;
			if (intval($this->input->post('juru_sita2'))<>0){
				$juru_sita2 = $this->input->post('juru_sita2');
				$this->juru_sita_id .= ",".$this->input->post('juru_sita2');
			}
			if (intval($this->input->post('juru_sita3'))<>0){
				$juru_sita3 = $this->input->post('juru_sita3');
				$this->juru_sita_id .= ",".$this->input->post('juru_sita3');
			}
			
			$namahalaman = $this->input->post('namahalaman',TRUE);
			if ($this->add_juru_sita_m->insert_penunjukan_juru_sita($idperkara, $tgl_penetapan_juru_sita,$namahalaman)){
				$this->load->model('riwayatperkara/riwayat_perkara_m');
				$this->riwayat_perkara_m->updateproses($idperkara,'40',$tgl_penetapan_juru_sita,'',$namahalaman,1);
				echo json_encode(array('st'=>1,'msg'=>'Data Berhasil Disimpan'));
			}else{
				echo json_encode(array('st'=>0,'msg'=>'Tidak Dapat Menyimpan Data ...'));
			}
		}
	}

	function f_validate_input_edit(){

		if($this->session->userdata('is_logged_in')==FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Anda Belum Login, Silahkan Login Terlebih Dahulu.'));
			return;
		}
		if(empty($_POST)){
			show_404();
		}

		$this->form_validation->set_rules('tgl_penunjukan_juru_sita', 'Tanggal Penunjukan Jurusita', 'trim|required|xss_clean|exact_length[10]');
		$this->form_validation->set_rules('juru_sita1', 'Jurusita', 'numeric|required|xss_clean|callback_f_juru_sita_id_check');
		

		if ($this->form_validation->run() === FALSE){
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Berhasil '.validation_errors()));
			return;
		}else{
			//simpan data juru_sita
			$idperkara = $this->encrypt->decode(base64_decode($this->input->post('enc',TRUE)));
			
			
			$curr_date = date('Y-m-d');
			$todayDate = date('d/m/Y');

			$date_penetapan_panitera = $this->add_juru_sita_m->get_penetapan_panitera($idperkara)->penetapan_panitera_pengganti;
			$tgl_penetapan_juru_sita = $this->input->post('tgl_penunjukan_juru_sita');
			$tgl_penetapan_juru_sita = $this->tanggalhelper->convertToMysqlDate($tgl_penetapan_juru_sita);

			if($tgl_penetapan_juru_sita==false){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Format Tanggal Tidak Benar. Format tanggal hari/bulan/tahun. Contoh 20/01/2015.'));
				return;
			}
			$selisih = $this->tanggalhelper->getSelisihHari($tgl_penetapan_juru_sita,$curr_date);
			if($selisih<0){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Penetapan Jurusita Tidak Boleh Melebihi Hari Ini. Hari ini Tanggal '.$todayDate));
				return;
			}
			$selisih = $this->tanggalhelper->getSelisihHari($date_penetapan_panitera,$tgl_penetapan_juru_sita);
			if($date_penetapan_panitera>$tgl_penetapan_juru_sita){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Penunjukan Jurusita/Jurusita Pengganti Tidak Boleh Kurang dari Tanggal Penetapan Panitera Pengganti.'));
				return;
			}

			$dayname = $this->tanggalhelper->getDayName($tgl_penetapan_juru_sita);
			if($dayname=='Saturday' OR $dayname=='Sunday'){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Dapat Memilih Tanggal Penetapan Jurusita Dihari Libur, Sabtu dan Minggu.'));
				return;
			}

			$juru_sita1 = $this->input->post('juru_sita1');
			$this->juru_sita_id = $juru_sita1;
			if (intval($this->input->post('juru_sita2'))<>0){
				$juru_sita2 = $this->input->post('juru_sita2');
				$this->juru_sita_id .= ",".$this->input->post('juru_sita2');
			}
			if (intval($this->input->post('juru_sita3'))<>0){
				$juru_sita3 = $this->input->post('juru_sita3');
				$this->juru_sita_id .= ",".$this->input->post('juru_sita3');
			}

			$jurusita_sebelumnya_id = $this->input->post('jurusita_sebelumnya_id', TRUE);
			$tanggalinput = $this->add_juru_sita_m->get_jumlah_tanggal_input($idperkara);
			$namahalaman = $this->input->post('namahalaman',TRUE);
			$this->load->model('riwayatperkara/riwayat_perkara_m');
			$jml_row=$tanggalinput->num_rows();
			if($jml_row > 1){
				$tanggal_penunjukan_sebelumnya=$tanggalinput->row($jml_row-1)->tanggal_penetapan;
				$selisih = $this->tanggalhelper->getSelisihHari($tanggal_penunjukan_sebelumnya,$tgl_penetapan_juru_sita);
				if($selisih<0){
					echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Penunjukan Panitera Pengganti Tidak Boleh Sebelum '.$this->tanggalhelper->convertDayDate($tanggal_penunjukan_sebelumnya)));
					return;
				}else{
					if ($this->add_juru_sita_m->update_penunjukan_juru_sita($idperkara, $tgl_penetapan_juru_sita, $jurusita_sebelumnya_id, 1, $namahalaman)){
						$this->riwayat_perkara_m->updateproses($idperkara,'41',$tgl_penetapan_juru_sita,'',$namahalaman,1);
						echo json_encode(array('st'=>1,'msg'=>'Data Penunjukan Jurusita Berhasil Disimpan'));
					}else{
						echo json_encode(array('st'=>0,'msg'=>'Data Gagal Disimpan'));
					};
				}
			}else{
				if ($this->add_juru_sita_m->update_penunjukan_juru_sita($idperkara, $tgl_penetapan_juru_sita, $jurusita_sebelumnya_id, 0, $namahalaman)){
					$this->riwayat_perkara_m->updateproses($idperkara,'40',$tgl_penetapan_juru_sita,'',$namahalaman,1);
					echo json_encode(array('st'=>1,'msg'=>'Data Penunjukan Jurusita Berhasil Disimpan'));
				}else{
					echo json_encode(array('st'=>0,'msg'=>'Data Gagal Disimpan'));
				};
			}
		}
	}
	
	function f_validate_input_penunjukan_kembali(){
		if(empty($_POST)){
			show_404();
		}

		if($this->session->userdata('is_logged_in')==FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Anda Belum Login, Silahkan Login Terlebih Dahulu.'));
			return;
		}

		$this->form_validation->set_rules('tgl_penunjukan_juru_sita', 'Tanggal Penunjukan Jurusita', 'trim|required|xss_clean');
		$this->form_validation->set_rules('juru_sita1', 'Jurusita', 'numeric|required|xss_clean|callback_f_juru_sita_id_check');
		
		if ($this->form_validation->run() === FALSE){
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Berhasil '.validation_errors()));
			return;
		}else{
			//simpan data juru_sita
			$idperkara = $this->encrypt->decode(base64_decode($this->input->post('enc',TRUE)));

			$curr_date = date('Y-m-d');
			$todayDate = date('d/m/Y');
			
			$tgl_penetapan_juru_sita = $this->input->post('tgl_penunjukan_juru_sita');
			$tgl_penetapan_juru_sita = $this->tanggalhelper->convertToMysqlDate($tgl_penetapan_juru_sita);
			$tgl_penetapan_juru_sita_sebelumnya = $this->encrypt->decode(base64_decode($this->input->post('lgtatis', true)));

			if($tgl_penetapan_juru_sita==false){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Format Tanggal Tidak Benar. Format tanggal hari/bulan/tahun. Contoh 20/01/2015.'));
				return;
			}
			$selisih = $this->tanggalhelper->getSelisihHari($tgl_penetapan_juru_sita_sebelumnya, $tgl_penetapan_juru_sita);
			if($selisih<0){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Penunjukan Jurusita Tidak Boleh Sebelum Tanggal Penunjukan Sebelumnya  '.$this->tanggalhelper->convertDayDate($tgl_penetapan_juru_sita_sebelumnya)));
				return;
			}
			$selisih=0;
			$selisih = $this->tanggalhelper->getSelisihHari($tgl_penetapan_juru_sita,$curr_date);
			if($selisih<0){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Penunjukan Jurusita Tidak Boleh Melebihi Hari Ini. Hari ini Tanggal '.$todayDate));
				return;
			}

			$dayname = $this->tanggalhelper->getDayName($tgl_penetapan_juru_sita);
			if($dayname=='Saturday' OR $dayname=='Sunday'){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Dapat Memilih Tanggal Penunjukan Jurusita Dihari Libur, Sabtu dan Minggu.'));
				return;
			}

			$juru_sita1 = $this->input->post('juru_sita1');
			$this->juru_sita_id = $juru_sita1;
			if (intval($this->input->post('juru_sita2'))<>0){
				$juru_sita2 = $this->input->post('juru_sita2');
				$this->juru_sita_id .= ",".$this->input->post('juru_sita2');
			}
			if (intval($this->input->post('juru_sita3'))<>0){
				$juru_sita3 = $this->input->post('juru_sita3');
				$this->juru_sita_id .= ",".$this->input->post('juru_sita3');
			}

			$jurusita_sebelumnya_id = $this->encrypt->decode(base64_decode($this->input->post('diatis', true)));
			if ($jurusita_sebelumnya_id==$this->juru_sita_id){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Ada Perubahan Nama dengan Penunjukan Sebelumnya ...'));
				return;
			}
			
			$namahalaman = $this->input->post('namahalaman',TRUE);
			$this->add_juru_sita_m->insert_penunjukan_kembali_juru_sita($idperkara, $tgl_penetapan_juru_sita,$namahalaman);
			$this->load->model('riwayatperkara/riwayat_perkara_m');
			$this->riwayat_perkara_m->updateproses($idperkara,'41',$tgl_penetapan_juru_sita,'',$namahalaman,1);
			echo json_encode(array('st'=>1,'msg'=>'Data Penunjukan Jurusita Berhasil Disimpan'));
			return;
		}
	}

	function f_juru_sita_id_check($str){
		if (intval($str)==0){
			$this->form_validation->set_message('f_juru_sita_id_check', 'Kolom %s Tidak Boleh Kosong');
			return FALSE;
		}else{
			return TRUE;
		}
	}

	function del_penetapan(){
		if($this->nativesession->is_flash_session('security')==FALSE){
			redirect('main');
		}

		if($this->session->userdata('is_logged_in')==FALSE){
			redirect('login');
		}
		$idperkara = $this->nativesession->get_flash_session('perkara_id');
		
		if (!is_numeric($idperkara) OR $idperkara<0){
			show_404();
			exit();
		}
		$tanggalinput = $this->add_juru_sita_m->get_jumlah_tanggal_input($idperkara);
		if($tanggalinput==FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Data Penunjukan Jurusita Tidak Ditemukan'));
			return;
		}
		$dohapus = FALSE;
		$namahalaman = $this->input->post('namahalaman',TRUE);
		if($tanggalinput->num_rows ==1){
			$tglpenetapan = $this->add_juru_sita_m->get_tanggal_penetapan($idperkara);
			if($tglpenetapan!=FALSE){
				$tglpenetapansidang = $this->add_juru_sita_m->get_tanggal_penetapan_sidang_pertama($idperkara);
				if(!empty($tglpenetapansidang)){
					echo json_encode(array('st'=>0,'msg'=>'Data Penunjukan Jurusita Tidak Dapat Dihapus. Tanggal Sidang Pertama Sudah Ditentukan.'));
					return;
				}

				$jumlahsidang = $this->add_juru_sita_m->get_jumlah_sidang($idperkara);
				if($jumlahsidang>0){
					echo json_encode(array('st'=>0,'msg'=>'Data Penunjukan Jurusita Tidak Dapat Dihapus. Perkara Telah Memasuki Proses Persidangan.'));
					return;
				}else{
					$tahapan = $this->add_juru_sita_m->get_tahapan($idperkara);
					if($tahapan>12){
						echo json_encode(array('st'=>0,'msg'=>'Data Penunjukan Jurusita Tidak Dapat Dihapus. Perkara Telah Memasuki Proses Persidangan.'));
						return;
					}
				}
				
				$hapusdata = $this->add_juru_sita_m->hapus_all_penetapan($idperkara,$namahalaman);
				if($hapusdata){
					$this->load->model('riwayatperkara/riwayat_perkara_m');
					$this->riwayat_perkara_m->updateproses($idperkara,'40','','',$namahalaman,2);
					echo json_encode(array('st'=>1,'msg'=>'Data Penunjukan Jurusita Berhasil Dihapus'));
					return;
				}else{
					echo json_encode(array('st'=>0,'msg'=>'Gagal Menghapus Penunjukan Jurusita'));
					return;
				}
			}else{
				echo json_encode(array('st'=>0,'msg'=>'Something Wrong with The Database.'.$tanggalinput->num_rows));
				return;
			}
		}else{
			$i=0;
			$ids = array();
			$idUpdate = array();
			$urutan=0;
			$tanggal_sebelumnya='';
			$tanggalinput = $this->add_juru_sita_m->get_tanggal_input($idperkara);
			foreach ($tanggalinput->result() as $row) {
				if ($row->aktif=='Y'){
					$ids[] = $row->id;
				}else{
					if ($tanggal_sebelumnya=='' || $tanggal_sebelumnya==$row->tanggal){
						$idUpdate[] = $row->id;	
						$urutan=$row->urutan;
					}else{
						if ($urutan==1){
							break;
						}else{
							$idUpdate[] = $row->id;	
							$urutan=$row->urutan;
						}
					}
					$tanggal_sebelumnya=$row->tanggal;
				}
				$i++;
			}
			$hapusdata = $this->add_juru_sita_m->hapus_penetapan($idperkara,$ids,$idUpdate,$namahalaman);
			$datasebelum=$this->add_juru_sita_m->get_jumlah_tanggal_input($idperkara);
			if($hapusdata){
				$this->load->model('riwayatperkara/riwayat_perkara_m');
				$this->riwayat_perkara_m->updateproses($idperkara,'41','','',$namahalaman,2);
				if($tanggalinput->num_rows >2){
					$this->riwayat_perkara_m->updateproses($idperkara,'41',$datasebelum->row(0)->tanggal_penetapan,'',$namahalaman,1);
				}
				echo json_encode(array('st'=>1,'msg'=>'Data Penunjukan Jurusita Berhasil Dihapus'));
				return;
			}else{
				echo json_encode(array('st'=>0,'msg'=>'Gagal Menghapus Penunjukan Jurusita'));
				return;
			}
		}
	}
}