<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class AddIkrar_talak_c extends CI_Controller {

	function index(){
		
	}

	function f_validate_input_add(){
		if(empty($_POST)){
			show_404();
		}

		if($this->session->userdata('is_logged_in')==FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Anda Belum Login, Silahkan Login Terlebih Dahulu.'));
			return;
		}
		$this->form_validation->set_rules('tgl_pendaftaran_verzet', 'Tanggal Pendaftaran Verzet', 'trim|required|xss_clean');
		$this->form_validation->set_rules('tanggal_surat', 'Tanggal Surat', 'trim|required|xss_clean');
	
		if ($this->form_validation->run() === FALSE){
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Berhasil'.validation_errors()));
			return;
		}else{
			$this->load->model('verzet/verzet_m');
			$perkaraid = ($this->encrypt->decode(base64_decode($this->input->post('enc', TRUE))));
			$tgl_putusan = $this->tanggalhelper->convertToMysqlDate($this->input->post('tgl_putusan', TRUE));
			$tgl_pendaftaran_verzet = $this->tanggalhelper->convertToMysqlDate($this->input->post('tgl_pendaftaran_verzet', TRUE));
			if ($tgl_pendaftaran_verzet<$tgl_putusan){
				echo json_encode(array('st'=>0,'msg'=>'Tanggal Pendaftaran Tidak Boleh sebelum Tanggal Putusan'));
				exit();
			}
			$tanggal_surat = $this->tanggalhelper->convertToMysqlDate($this->input->post('tanggal_surat', TRUE));
			if ($tanggal_surat>$tgl_pendaftaran_verzet){
				echo json_encode(array('st'=>0,'msg'=>'Tanggal Surat Tidak Boleh melebihi Tanggal Pendaftaran'));
				exit();
			}

			$todayDate = date('d/m/Y');
			$curr_date = date('Y-m-d');

			$selisih = $this->tanggalhelper->getSelisihHari($tgl_pendaftaran_verzet,$curr_date);
			if($selisih<0){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Pendaftaran Tidak Boleh Melebihi Hari ini. Hari ini Tanggal,'.$todayDate));
				return;
			}

			$selisih = $this->tanggalhelper->getSelisihHari($tanggal_surat,$curr_date);
			if($selisih<0){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Surat Tidak Boleh Melebihi Hari ini. Hari ini Tanggal,'.$todayDate));
				return;
			}


			$dayname = $this->tanggalhelper->getDayName($tgl_pendaftaran_verzet);
			if($dayname=='Saturday' OR $dayname=='Sunday'){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Dapat Memilih Tanggal Pendaftaran Dihari Libur, Sabtu dan Minggu.'));
				return;
			}

			$dayname = $this->tanggalhelper->getDayName($tanggal_surat);
			if($dayname=='Saturday' OR $dayname=='Sunday'){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Dapat Memilih Tanggal Surat Dihari Libur, Sabtu dan Minggu.'));
				return;
			}

			$data = array(
					'perkara_id'=>$perkaraid, 
					'tanggal_pendaftaran_verzet'=>$tgl_pendaftaran_verzet,
					'tanggal_surat'=>$tanggal_surat,
					'pemberitahuan_putusan'=>NULL,
					'diinput_oleh'=>$this->session->userdata('username'),
					'diinput_tanggal'=>date('Y-m-d H:i:s')
				);
			
			if($this->session->userdata('jenis_pengadilan')==3){
				$tahapan_id=13;
				$proses_id=111;
				$proses_nama='Pendaftaran Perlawanan';
			}else{
				$tahapan_id=16;
				$proses_id=240;
				$proses_nama='Pendaftaran Perlawanan(Verzet)';
			}
			
			$tanggal=$tgl_pendaftaran_verzet;
			$this->verzet_m->add_verzet($perkaraid, $data, $tahapan_id, $proses_id, $proses_nama, $tanggal);
			echo json_encode(array('st'=>1,'msg'=>'DATA Berhasil Disimpan '));
			return;

			}	
		
	}

	function f_validate_input_edit(){
		if(empty($_POST)){
			show_404();
		}
		
		if($this->session->userdata('is_logged_in')==FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Anda Belum Login, Silahkan Login Terlebih Dahulu.'));
			return;
		}

		$perkaraid = ($this->encrypt->decode(base64_decode($this->input->post('enc'))));
		if(empty($perkaraid) OR intval($perkaraid)<1){
			echo json_encode(array('st'=>0,'msg'=>'Perkara Tidak Ditemukan.'));
			return;
		}
		
		$this->form_validation->set_rules('tgl_pendaftaran_verzet', 'Tanggal Pendaftaran Verzet', 'trim|required|xss_clean');
		$this->form_validation->set_rules('tanggal_surat', 'Tanggal Surat', 'trim|required|xss_clean');

		if ($this->form_validation->run() === FALSE){
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Berhasil'.validation_errors()));
			return;
		}else{
			$this->load->model('verzet/verzet_m');
			$perkaraid = ($this->encrypt->decode(base64_decode($this->input->post('enc', TRUE))));
			$tgl_putusan = $this->tanggalhelper->convertToMysqlDate($this->input->post('tgl_putusan', TRUE));
			$tgl_pendaftaran_verzet = $this->tanggalhelper->convertToMysqlDate($this->input->post('tgl_pendaftaran_verzet', TRUE));
			if ($tgl_pendaftaran_verzet<$tgl_putusan){
				echo json_encode(array('st'=>0,'msg'=>'Tanggal Pendaftaran Tidak Boleh sebelum Tanggal Putusan'));
				return;
			}
			
			$tanggal_surat = $this->tanggalhelper->convertToMysqlDate($this->input->post('tanggal_surat', TRUE));
			if ($tanggal_surat>$tgl_pendaftaran_verzet){
				echo json_encode(array('st'=>0,'msg'=>'Tanggal Surat Tidak Boleh Melebihi Tanggal Pendaftaran'));
				return;
			}

			$todayDate = date('d/m/Y');
			$curr_date = date('Y-m-d');
			$selisih = $this->tanggalhelper->getSelisihHari($tgl_pendaftaran_verzet,$curr_date);
			if($selisih<0){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Pendaftaran Tidak Boleh Melebihi Hari ini. Hari ini Tanggal,'.$todayDate));
				return;
			}

			$selisih = $this->tanggalhelper->getSelisihHari($tanggal_surat,$curr_date);
			if($selisih<0){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Surat Tidak Boleh Melebihi Hari ini. Hari ini Tanggal,'.$todayDate));
				return;
			}

			$dayname = $this->tanggalhelper->getDayName($tgl_pendaftaran_verzet);
			if($dayname=='Saturday' OR $dayname=='Sunday'){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Dapat Memilih Tanggal Pendaftaran Dihari Libur, Sabtu dan Minggu.'));
				return;
			}
			
			$dayname = $this->tanggalhelper->getDayName($tanggal_surat);
			if($dayname=='Saturday' OR $dayname=='Sunday'){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Dapat Memilih Tanggal Surat Dihari Libur, Sabtu dan Minggu.'));
				return;
			}

			$data = array(
					'perkara_id'=>$perkaraid, 
					'tanggal_pendaftaran_verzet'=>$tgl_pendaftaran_verzet,
					'tanggal_surat'=>$tanggal_surat,
					'diperbaharui_oleh'=>$this->session->userdata('username'),
					'diperbaharui_tanggal'=>date('Y-m-d H:i:s')
				);
			if($this->session->userdata('jenis_pengadilan')==3){
				$tahapan_id=13;
				$proses_id=111;
				$proses_nama='Pendaftaran Perlawanan';
			}else{
				$tahapan_id=16;
				$proses_id=240;
				$proses_nama='Pendaftaran Perlawanan(Verzet)';
			}
			$tanggal=$tgl_pendaftaran_verzet;
			$result = $this->verzet_m->edit_verzet($perkaraid, $data, $tahapan_id, $proses_id, $proses_nama, $tanggal);
			if($result==TRUE){
				echo json_encode(array('st'=>1,'msg'=>'DATA Berhasil Disimpan'));
				return;
			}else{
				echo json_encode(array('st'=>0,'msg'=>'DATA Tidak Berhasil Disimpan'));
				return;
			}
		}	
	}

	function validatePost(){
		$this->load->library('SIPPFileHelper');
		$nomor_perkara = ($this->input->post('nomor_perkara'));
		$perkara_id = $this->encrypt->decode(base64_decode($this->input->post('enc')));
		$splitnoperkara=explode("/",$nomor_perkara);
		$arr = explode("/", $nomor_perkara);
		$tgldaftar = $this->tanggalhelper->getTanggalPendaftaran($perkara_id);

		$splittgldaftar=explode("-",$tgldaftar);
		$direktori="resources/file/doc/".$splittgldaftar[0]."/".$splittgldaftar[1]."/";
		@mkdir($direktori,0755,true);

		$namafile = $_FILES['edoc_amar_putusan']['name'];
		$extension=pathinfo($namafile);
		$extension=$extension['extension'];
		$fileName=$splitnoperkara[3]."_".$splitnoperkara[2]."_".$splitnoperkara[1]."_".$splitnoperkara[0]."_putusan_verzet.".$extension;

		$uploaddir = $direktori;
		$this->load->model('verzet/verzet_m');
		$q=("update perkara_verzet set amar_putusan_verzet_dok='".$fileName."' where perkara_id='".$perkara_id."';");
		$this->verzet_m->exec_simple_query($q);

		$uploadfile = $uploaddir . $fileName;

		$isOK = $this->sippfilehelper->isAcceptableFile($uploadfile);

		if($isOK==FALSE){
			echo json_encode(array('st'=>0,'msg'=>'File Format E-Document Tidak Diizinkan. System Hanya Mengizinkan File dengan Format: Ms. Word, PDF, RTF, PNG.\n'));
			return;
		}
		if (move_uploaded_file($_FILES['edoc_amar_putusan']['tmp_name'], $uploadfile)) {
			chmod($direktori, 0755);
			chmod($uploadfile, 0644);
		    echo json_encode(array('st'=>1,'msg'=>'File is valid, and was successfully uploaded.'));
			return;
		} else {
			chmod($direktori, 0755);
		    echo json_encode(array('st'=>0,'msg'=>'Gagal Melakukan Upload!\n'));
			return;
		}
	}

	function validateDelete(){
		if(empty($_POST)){
			show_404();
		}
		
		if($this->session->userdata('is_logged_in')==FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Anda Belum Login, Silahkan Login Terlebih Dahulu.'));
			return;
		}

		$idperkara = ($this->encrypt->decode(base64_decode($this->input->post('enc'))));
		if(empty($idperkara) OR intval($idperkara)<1){
			echo json_encode(array('st'=>0,'msg'=>'Perkara Tidak Ditemukan.'));
			return;
		}
		$this->load->model('verzet/verzet_m','verzet');
		$delData = $this->verzet->deleteData($idperkara);
		if($delData){
			echo json_encode(array('st'=>1,'msg'=>'Permohonan Verzet Berhasil DiHapus.'));
			return;
		}else{
			echo json_encode(array('st'=>0,'msg'=>'Penghapusan Gagal.'));
			return;
		}
	}
}