<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Update_database extends CI_Model{
	function __construct(){
		$this->run_this();
	}

	function isColumnExist($table_name,$column_name){
		try {
			$result = $this->db->query('
				SELECT COLUMN_NAME AS colname
			    FROM information_schema.columns 
			    WHERE TABLE_NAME = "'.$table_name.'"
			    AND COLUMN_NAME = "'.$column_name.'" AND TABLE_SCHEMA = "'.$this->db->database.'" 
			    GROUP BY column_name;
				');
			if($result->num_rows>0){
				return $result->row()->colname;
			}else{
				return '';
			}
		} catch (Exception $e) {
			return FALSE;
		}
	}

	function run_this(){
		//script update database disini

        
        $this->db->query("SET FOREIGN_KEY_CHECKS=0;");
        $this->db->query("SET SQL_MODE='ALLOW_INVALID_DATES';");
 		
 		$this->db->query("REPLACE INTO `jenis_alur_perkara` (`alur_perkara_id`, `jenis_perkara_id`) values ('10','333'),('10','334');");
 		$this->db->query("DELETE FROM jenis_alur_perkara WHERE alur_perkara_id = '10' AND jenis_perkara_id = '331';");
 		$this->db->query("DELETE FROM jenis_alur_perkara WHERE alur_perkara_id = '9' AND jenis_perkara_id = '331';");
 		$this->db->query("DELETE FROM jenis_alur_perkara WHERE alur_perkara_id = '9' AND jenis_perkara_id = '333';");
 		$this->db->query("DELETE FROM jenis_alur_perkara WHERE alur_perkara_id = '9' AND jenis_perkara_id = '334';");
 		$this->db->query("UPDATE alur_perkara SET kode = 'G/KI' WHERE id = '11';");
 		$this->db->query("UPDATE alur_perkara SET kode = 'P/FP' WHERE id = '12';");
 		$this->db->query("UPDATE alur_perkara SET kode = 'P/PW' WHERE id = '13';");
 		$this->db->query("UPDATE alur_perkara SET kode = 'G/PU' WHERE id = '14';");
 		$this->db->query("UPDATE jenis_perkara SET format_nomor = '#nomor_urut_perkara#/G/PU/#tahun#/PTUN.#kode_pn#' WHERE id = '332';");
 		$this->db->query("UPDATE jenis_perkara SET format_nomor = '#nomor_urut_perkara#/P/FP/#tahun#/PTUN.#kode_pn#' WHERE id = '333';");
 		$this->db->query("UPDATE jenis_perkara SET format_nomor = '#nomor_urut_perkara#/P/PW/#tahun#/PTUN.#kode_pn#' WHERE id = '334';");
 		$this->db->query("UPDATE alur_perkara SET kode = 'P' WHERE id = '10';");
 		$this->db->query("UPDATE alur_perkara SET aktif = 'Y' WHERE id = '10';");
  		$this->db->query("UPDATE alur_perkara SET nama = 'Gugatan Keberatan (KIP)' , keterangan = 'Gugatan Keberatan (KIP)' , aktif = 'Y' WHERE id = '11';");
  		$this->db->query("UPDATE jenis_biaya SET nama = REPLACE(nama,'Materai','Meterai');");
   		$this->db->query("UPDATE kategori_biaya SET nama = REPLACE(nama,'Materai','Meterai'), keterangan = REPLACE(keterangan,'Materai','Meterai');");
  		$this->db->query("UPDATE perkara_biaya SET uraian = REPLACE(uraian,'Materai','Meterai');");
  		$this->db->query("UPDATE perkara_biaya SET uraian = REPLACE(uraian,'MATERAI','METERAI');");

  		$this->db->query("REPLACE INTO perkara_penetapan(
						perkara_id,
						penetapan_majelis_hakim,
						nomor_sk_penetapan_majelis_hakim,
						majelis_hakim_id,
						majelis_hakim_kode,
						majelis_hakim_nama,
						majelis_hakim_text,
						penetapan_panitera_pengganti,
						nomor_sk_penetapan_panitera_pengganti,
						panitera_pengganti_id,
						panitera_pengganti_text,
						penetapan_jurusita,
						nomor_sk_penetapan_jurusita,
						jurusita_id,
						jurusita_text,
						diinput_oleh,
						diinput_tanggal)
						SELECT 
						hakim_1.`perkara_id` 								AS perkara_id, 
						hakim_1.`tanggal_penetapan` 						AS penetapan_majelis_hakim,
						hakim_1.`nomor_sk_penetapan` 						AS nomor_sk_penetapan_majelis_hakim,
						CONCAT(hakim_1.`hakim_id`,IF(hakim_2.`id` IS NULL,'',CONCAT(',',hakim_2.`hakim_id`,',',hakim_3.`hakim_id`))) AS majelis_hakim_id,
						CONCAT(hakim_1.`hakim_kode`,IF(hakim_2.`id` IS NULL,'',CONCAT(',',hakim_2.`hakim_kode`,',',hakim_3.`hakim_kode`))) AS majelis_hakim_kode,
						CONCAT(hakim_1.`hakim_nama`,IF(hakim_2.`id` IS NULL,'',CONCAT('<br/>',hakim_2.`hakim_nama`,'<br/>',hakim_3.`hakim_nama`))) AS majelis_hakim_nama,
						CONCAT(hakim_1.`jabatan_hakim_nama`,' : ',hakim_1.`hakim_nama`,IF(hakim_2.`id` IS NULL,'',CONCAT('<br/>',hakim_2.`jabatan_hakim_nama`,' ',hakim_2.`urutan` - '1',' : ',hakim_2.`hakim_nama`,'<br/>',hakim_3.`jabatan_hakim_nama`,' ',hakim_3.`urutan` - '1',' : ',hakim_3.`hakim_nama`))) AS majelis_hakim_text,
						IF(pp.`id` IS NULL,NULL,pp.`tanggal_penetapan`) 	AS penetapan_panitera_pengganti,
						IF(pp.`id` IS NULL,NULL,pp.`nomor_sk_penetapan`) 	AS nomor_sk_penetapan_panitera_pengganti,
						IF(pp.`id` IS NULL,NULL,pp.`panitera_id`) 			AS panitera_pengganti_id,
						IF(pp.`id` IS NULL,NULL,pp.`panitera_nama`) 		AS panitera_pengganti_text,
						IF(js.`id` IS NULL,NULL,js.`tanggal_penetapan`) 	AS penetapan_jurusita,
						IF(js.`id` IS NULL,NULL,js.`nomor_sk_penetapan`) 	AS nomor_sk_penetapan_jurusita,
						IF(js.`id` IS NULL,NULL,js.`jurusita_id`) 			AS jurusita_id,
						IF(js.`id` IS NULL,NULL,js.`jurusita_nama`) 		AS jurusita_text,
						'System' 					AS diinput_oleh,
						NOW() 						AS diinput_tanggal	
						FROM 		
						(SELECT a.`perkara_id` 
						FROM 
						(SELECT a.`perkara_id` FROM perkara_hakim_pn a JOIN perkara b ON a.`perkara_id`=b.`perkara_id` AND (b.`alur_perkara_id`='15' OR b.`alur_perkara_id`='16') 
						GROUP BY a.`perkara_id`) AS a
						LEFT JOIN (SELECT perkara_id AS id FROM perkara_penetapan) AS b ON a.`perkara_id` = b.`id` WHERE b.`id` IS NULL) AS src
						LEFT JOIN 	(SELECT * FROM perkara_hakim_pn WHERE urutan = '1' AND aktif = 'Y') AS hakim_1 ON src.`perkara_id` = hakim_1.`perkara_id`
						LEFT JOIN 	(SELECT * FROM perkara_hakim_pn WHERE urutan = '1' AND aktif = 'Y') AS hakim_2 ON hakim_1.`perkara_id` = hakim_2.`perkara_id`
						LEFT JOIN 	(SELECT * FROM perkara_hakim_pn WHERE urutan = '1' AND aktif = 'Y') AS hakim_3 ON hakim_1.`perkara_id` = hakim_3.`perkara_id`
						LEFT JOIN 	(SELECT * FROM perkara_panitera_pn WHERE aktif = 'Y' GROUP BY perkara_id ORDER BY urutan DESC) AS pp ON hakim_1.`perkara_id` = pp.`perkara_id`
						LEFT JOIN 	(SELECT * FROM perkara_jurusita WHERE aktif = 'Y' GROUP BY perkara_id ORDER BY urutan DESC) AS js ON hakim_1.`perkara_id` = js.`perkara_id`;");

 		$this->db->query("UPDATE perkara_penetapan AS src 
 						JOIN perkara AS dst ON src.perkara_id=dst.perkara_id AND (dst.`alur_perkara_id`='15' OR dst.`alur_perkara_id`='16')
						LEFT JOIN (SELECT * FROM perkara_hakim_pn WHERE urutan='1' AND aktif='Y') AS hakim_1 ON src.`perkara_id`= hakim_1.`perkara_id`
						LEFT JOIN (SELECT * FROM perkara_hakim_pn WHERE urutan='1' AND aktif='Y') AS hakim_2 ON hakim_1.`perkara_id`= hakim_2.`perkara_id`
						LEFT JOIN (SELECT * FROM perkara_hakim_pn WHERE urutan='1' AND aktif='Y') AS hakim_3 ON hakim_1.`perkara_id`= hakim_3.`perkara_id`
						SET 
						src.`majelis_hakim_id` = CONCAT(hakim_1.`hakim_id`,IF(hakim_2.`id` IS NULL,'',CONCAT(',',hakim_2.`hakim_id`,',',hakim_3.`hakim_id`))),
						src.`majelis_hakim_kode` = CONCAT(hakim_1.`hakim_kode`,IF(hakim_2.`id` IS NULL,'',CONCAT(',',hakim_2.`hakim_kode`,',',hakim_3.`hakim_kode`)))
						WHERE src.`majelis_hakim_nama` IS NOT NULL AND src.`majelis_hakim_nama` !='' AND src.`majelis_hakim_id` IS NULL;");

 		$this->db->query("UPDATE perkara_penetapan AS src
						JOIN perkara AS dst ON src.perkara_id=dst.perkara_id AND (dst.alur_perkara_id='15' OR dst.alur_perkara_id='16')
						LEFT JOIN (SELECT * FROM perkara_panitera_pn WHERE aktif = 'Y' GROUP BY perkara_id ORDER BY urutan DESC) AS pp ON src.perkara_id=pp.perkara_id
						SET src.panitera_pengganti_id= IF(pp.id IS NULL,NULL,pp.panitera_id)
						WHERE src.panitera_pengganti_text IS NOT NULL AND src.panitera_pengganti_text !='' AND src.panitera_pengganti_id IS NULL;");

 		$this->db->query("UPDATE perkara_penetapan AS src
						JOIN perkara AS dst ON src.`perkara_id`=dst.`perkara_id` AND (dst.`alur_perkara_id`='15' OR dst.`alur_perkara_id`='16')
						LEFT JOIN (SELECT * FROM perkara_jurusita WHERE aktif = 'Y' GROUP BY perkara_id ORDER BY urutan DESC) AS js ON src.`perkara_id`=js.`perkara_id`
						SET src.`jurusita_id`= IF(js.`id` IS NULL,NULL,js.`jurusita_id`)
						WHERE src.`jurusita_text` IS NOT NULL AND src.`jurusita_text` !='' AND src.`jurusita_id` IS NULL;");

 		$this->db->query("REPLACE INTO `template_dokumen` (`id`,`alur_perkara_id`, `tahapan_id`, `proses_id`, `nomor`, `kode`, `nama`) 
						SELECT * FROM (SELECT '2088','15', '10' AS tahap, '10' AS proses, '1', 'PDT_15_10_10_1', 'SKUM') AS tmp
						WHERE NOT EXISTS (SELECT id FROM template_dokumen WHERE id = '2088') LIMIT 1;");

 		$this->db->query("UPDATE proses_alur_perkara SET batas_waktu = '30' , nama_tabel_dari = 'perkara_persiapan' , nama_kolom_dari = 'tanggal_penetapan_persiapan' 
 						WHERE alur_perkara_id = '9' AND tahapan_id = '12' AND proses_id = '80';");

		$this->db->query("UPDATE proses_alur_perkara SET batas_waktu = '60' WHERE alur_perkara_id = '9' AND tahapan_id = '42' AND proses_id = '370';");

 		$this->db->query("REPLACE INTO jenis_perkara (`id`, `parent_id`, `nama`, `nama_lengkap`) 
						VALUES ('621', '337', 'Ketidakhadiran Tanpa Ijin', 'Ketidakhadiran Tanpa Ijin');"); 

		$this->db->query("UPDATE jenis_perkara SET format_nomor = '#nomor_urut_perkara#-#kode_alur_perkara#/#kode_pn#/#matra#/#bulan#/#tahun#' WHERE `id` = '621'; ");
 		
 		$this->db->query("REPLACE INTO `jenis_alur_perkara` (`alur_perkara_id`, `jenis_perkara_id`) 
						VALUES ('120', '621'); ");

 		$this->db->query("UPDATE pengadilan_negeri SET `alamat` = 'Jl. Pomorouw No. 66 Manado' WHERE `id` = '376';");


 		$this->db->query("REPLACE INTO `biaya_perkara` (alur_perkara_id,jenis_biaya_id,jumlah,keterangan) 
 						VALUES ('8','343','3000.00','Uang Leges'),('10','343','3000.00','Uang Leges'),('11','343','3000.00','Uang Leges'), 
 						('15','343','3000.00','Uang Leges'),('16','343','3000.00','Uang Leges');");

  		$this->db->query("REPLACE INTO `sys_groups` (`groupid`,`parent_id`,`level`,`lft`,`rgt`,`name`,`description`,`ordering`) 
  						VALUES ('650','30','5','75','76','Koordinator Delegasi','Koordinator Delegasi','14');");
  		

 		$this->db->query("REPLACE INTO `sys_group_rule` (`groupid`, `ruleid`) 
 						values ('650','44'),('650','45'),('650','46'),('650','47'),('650','62'),('650','63'),('650','64'),('650','65'),('650','83'),('650','88'),('650','89'),('650','90'),
 						('650','91'),('650','92'),('650','93'),('650','105'),('650','106'),('650','121'),('650','122'),('650','129'),('650','130'),('650','131'),('650','132'),('650','133'),
 						('650','134'),('650','135'),('650','136'),('650','137'),('650','145'),('650','148'),('650','151'),('650','154'),('650','190'),('650','193'),('650','196'),
 						('650','217'),('650','220'),('650','223'),('650','226'),('650','258'),('650','261'),('650','284'),('650','287'),('650','290'),('650','330'),('650','332'),
 						('650','333'),('650','334'),('650','335'),('650','336'),('650','338'),('650','340'),('650','341'),('650','342'),('650','344'),('650','345'),('650','346'),
 						('650','347'),('650','348'),('650','364'),('650','367'),('650','370'),('650','373'),('650','379'),('650','385'),('650','388'),('650','394'),('650','397'),
 						('650','400'),('650','403'),('650','477'),('650','526');");

  		$this->db->query("REPLACE INTO `sumber_hukum` (`id`,`kode`,`nama`,`jenis_pengadilan`) 
  						VALUES ('14','Yurisprudensi','Yurisprudensi','1'),('15','RV','RV','1'),('16','Yurisprudensi','Yurisprudensi','4');");
  		
  		$this->db->query("UPDATE perkara SET proses_terakhir_text='Minutasi' WHERE proses_terakhir_text='Pembuatan Minutasi';");

  		$this->db->query("UPDATE perkara_proses SET proses_nama='Minutasi' WHERE proses_nama='Pembuatan Minutasi';");

  		$this->db->query("UPDATE proses_alur_perkara SET proses_nama='Minutasi' WHERE proses_nama='Pembuatan Minutasi';");

  		$this->db->query("UPDATE proses SET STATUS='Minutasi' WHERE STATUS='Pembuatan Minutasi';");
  		
  		$this->db->query("DELETE FROM sys_groups WHERE groupid >= '470' AND groupid <= '483';");

  		$this->db->query("REPLACE INTO jenis_perkara (id,parent_id,nama,nama_lengkap,format_nomor,urutan,level,lft,rgt,diinput_oleh,diinput_tanggal) 
						VALUES('622','119','Keberatan atas ganti kerugian pengadaan tanah bagi pembangunan untuk kepentingan umum','Objek Sengketa Bukan Tanah/Keberatan atas ganti kerugian pengadaan tanah bagi pembangunan untuk kepentingan umum','#nomor_urut_perkara#/#kode_alur_perkara#/#tahun#/PN #kode_pn#','10','4','87','88','admin2','2016-10-03 11:50:31');");

  		$this->db->query("REPLACE INTO jenis_alur_perkara (`alur_perkara_id`,`jenis_perkara_id`) VALUES ('1','622');");

  		$this->db->query("REPLACE INTO jenis_perkara (id, parent_id, nama, nama_lengkap, format_nomor, urutan, level, lft, rgt, diinput_oleh, diinput_tanggal) 
						VALUES('623','119','Keterbukaan Informasi Publik','Objek Sengketa Bukan Tanah/Keterbukaan Informasi Publik','#nomor_urut_perkara#/Pdt.Sus-KIP/#tahun#/PN #kode_pn#','11','4','89','90','admin2','2016-10-03 11:50:31');");

  		$this->db->query("REPLACE INTO jenis_alur_perkara (`alur_perkara_id`, `jenis_perkara_id`) VALUES ('1', '623');");

  		$this->db->query("UPDATE jenis_perkara SET format_nomor = '#nomor_urut_perkara#/Pdt.G/LH/#tahun#/PN #kode_pn#' WHERE parent_id = '372';");

  		$this->db->query("UPDATE jenis_perkara SET format_nomor = '#nomor_urut_perkara#/Pid.B/LH/#tahun#/PN #kode_pn#' WHERE parent_id = '392';");

  		$this->db->query("REPLACE INTO `jenis_biaya` (`id`,`tahapan_id`,`jenis_transaksi`,`kategori_id`,`kode`,`nama`,`jumlah`,`keterangan`,`aktif`,`diedit_oleh`,`diedit_tanggal`,`diinput_oleh`,`diinput_tanggal`,`diperbaharui_oleh`,`diperbaharui_tanggal`) 
						VALUES('377','50','-1','7','PST A1','Pemeriksaan Setempat','0.00','Biaya Pemeriksaan Setempat','Y','',NULL,'system','2016-10-11 10:44:17','admin','2016-10-11 23:03:48');");

  		$this->db->query("REPLACE INTO biaya_perkara (alur_perkara_id,jenis_biaya_id,jumlah)
						VALUES ('1','377','0.00'),('2','377','0.00'),('3','377','0.00'),('4','377','0.00'),('5','377','0.00'),('6','377','0.00'),('7','377','0.00'),
						('8','377','0.00'),('9','377','0.00'),('10','377','0.00'),('11','377','0.00'),('15','377','0.00'),('16','377','0.00');");

  		$this->db->query("REPLACE INTO `jenis_biaya` (`id`, `tahapan_id`, `jenis_transaksi`, `kategori_id`, `nama`, `jumlah`, `keterangan`,  `diinput_oleh`, `diinput_tanggal`) 
  						VALUES ('378','50','-1','4','Biaya Panggilan Pemohon','0.00','Biaya Panggilan Pemohon','system','2016-11-09 10:32:28'), 
  						('379','50','-1','4','Biaya Panggilan Termohon','0.00','Biaya Panggilan Termohon','system','2016-11-09 10:32:57');");

  		$this->db->query("REPLACE INTO biaya_perkara (alur_perkara_id,jenis_biaya_id,jumlah) 
  						VALUES ('1','378','0.00'),('2','378','0.00'),('3','378','0.00'),('4','378','0.00'),('5','378','0.00'),('6','378','0.00'),('7','378','0.00'),
  						('8','378','0.00'),('9','378','0.00'),('10','378','0.00'),('11','378','0.00'),('15','378','0.00'),('16','378','0.00'),('1','379','0.00'),
  						('2','379','0.00'),('3','379','0.00'),('4','379','0.00'),('5','379','0.00'),('6','379','0.00'),('7','379','0.00'),('8','379','0.00'),
  						('9','379','0.00'),('10','379','0.00'),('11','379','0.00'),('15','379','0.00'),('16','379','0.00');");

  		$this->db->query("REPLACE INTO status_putusan (`id`, `jenis_perkara_id`, `nama`, `urutan`, `satuan`, `jenis_pengadilan`) 
						VALUES ('84', '2', 'Putusan NO', '19', '3', '2');");


  		$cekkolom = $this->isColumnExist('perkara_putusan','sumber_hukum');
        if(!$cekkolom){
		$this->db->query("ALTER TABLE `perkara_putusan` CHANGE sumber_hukum_id sumber_hukum_id VARCHAR(20) NULL COMMENT 'Diputus Dengan: pilihan (KUH Perdata,KUH Dagang, Adat, UU/PP)';");
        }   

  		$this->db->query("UPDATE `biaya_perkara` SET jumlah='6000' WHERE jenis_biaya_id='152' OR jenis_biaya_id='167' OR jenis_biaya_id='182' OR jenis_biaya_id='197' OR jenis_biaya_id='212'");

  		$this->db->query("DROP VIEW IF EXISTS `viewperkaralalulintasweb`;"); 
  		$this->db->query("CREATE VIEW `viewperkaralalulintasweb` AS SELECT perkara_id AS IDPerkara,
						(CASE 
							WHEN ditilang_oleh='1' THEN 'Polisi'
							WHEN ditilang_oleh='2' THEN 'Dinas Perhubungan'
							ELSE 'Lainnya'
						END) AS ditilangOleh,
						nomor_tilang AS nomorTilang,
						(CASE
							WHEN jenis_kendaraan_id='1' THEN 'Sepeda Motor'
							WHEN jenis_kendaraan_id='2' THEN 'Mobil Pick Up'
							WHEN jenis_kendaraan_id='3' THEN 'Mobil Penumpang Pribadi'
							WHEN jenis_kendaraan_id='4' THEN 'Mobil Penumpang Umum'
							WHEN jenis_kendaraan_id='5' THEN 'Bus'
							WHEN jenis_kendaraan_id='6' THEN 'Truk'
							WHEN jenis_kendaraan_id='7' THEN 'Truk Gandeng'
							ELSE 'Lainnya'
						END) AS jenisKendaraan,
						nomor_polisi AS nomorPolisi,
						(CASE
							WHEN bukti_tilang_id='10' THEN 'SIM C'
							WHEN bukti_tilang_id='11' THEN 'SIM A'
							WHEN bukti_tilang_id='12' THEN 'SIM BI'
							WHEN bukti_tilang_id='13' THEN 'SIM A UMUM'
							WHEN bukti_tilang_id='14' THEN 'SIM BI UMUM'
							WHEN bukti_tilang_id='15' THEN 'SIM BII UMUM'
							WHEN bukti_tilang_id='20' THEN 'STNK'
							WHEN bukti_tilang_id='30' THEN 'SIM & STNK'
							WHEN bukti_tilang_id='40' THEN 'Kendaraan'
							WHEN bukti_tilang_id='50' THEN 'Buku KIR'
							ELSE 'Lainnya'
						END) AS buktiTilang
						FROM perkara_lalulintas;");

  		$this->db->query("DROP TABLE IF EXISTS `perkaralalulintasweb`;");

  		$this->db->query("CREATE TABLE `perkaralalulintasweb` (  
  						IDPerkara BIGINT(20) NOT NULL,
  						ditilangOleh VARCHAR(100),
  						nomorTilang VARCHAR(50),
  						jenisKendaraan VARCHAR(100),
  						nomorPolisi VARCHAR(50),
  						buktiTilang VARCHAR(100),
  						PRIMARY KEY (IDPerkara)
						) ENGINE=INNODB;");

  		$this->db->query("DROP TABLE IF EXISTS `delegasiproseskeluarweb`;");

  		$this->db->query("CREATE TABLE `delegasiproseskeluarweb` AS SELECT * FROM `viewdelegasiproseskeluarweb`;");

  		$cekkolum = $this->isColumnExist('delegasiproseskeluarweb','IDDelegasi');  		
        if($cekkolum){
		$this->db->query("ALTER TABLE `delegasiproseskeluarweb` ADD PRIMARY KEY (IDDelegasi,IDPerkara,idPNAsal), ENGINE=INNODB;");
        }   

  		$this->db->query("DROP TABLE IF EXISTS `delegasiprosesmasukweb`;");

  		$this->db->query("CREATE TABLE `delegasiprosesmasukweb` AS SELECT * FROM `viewdelegasiprosesmasukweb`;");

  		$periksakolom = $this->isColumnExist('delegasiprosesmasukweb','IDDelegasi');
        if($periksakolom){
		$this->db->query("ALTER TABLE `delegasiprosesmasukweb` ADD PRIMARY KEY (IDDelegasi,IDPerkara,idPNAsal), ENGINE=INNODB;");
        }   

  		$this->db->query("ALTER VIEW `viewbarangbuktiweb` AS SELECT
  						A.`id` 			       	 AS IDBarangBukti,
  						A.`perkara_id`  	   	 AS IDPerkara,
  						A.`nomor_perkara`      	 AS noPerkara,
  						A.`tanggal_penerimaan`   AS tglPenerimaan,
  						(CASE WHEN B.`pihak_dipublikasikan`='T' THEN 'Disamarkan' ELSE A.`jenis_barang_bukti` END) AS jenisBB,
  						A.`tempat_penyimpanan`   AS tempatSimpan,
  						A.`tempat_penyerahan`    AS tempatPenyerahan,
  						A.`nama_penerima`        AS penerima,
  						A.`tanggal_penyerahan`   AS tglPenyerahan,
  						A.`catatan_barang_bukti` AS Catatan
						FROM perkara_barang_bukti AS A
						LEFT JOIN perkara AS B ON B.`perkara_id`=A.`perkara_id`;");

  		$this->db->query("ALTER VIEW `viewpihakweb` AS SELECT 
						'1' AS pihak_ke,
						p1.`pihak_id` AS ID,
						p1.`perkara_id` AS IDPerkara,
						(CASE 
    						WHEN p.`alur_perkara_id`= '1' AND p.`jenis_perkara_id`= '64' AND p1.`nama` IS NOT NULL AND p1.`nama` <> '' THEN 'Disamarkan'
    						WHEN p.`alur_perkara_id`= '1' AND p.`jenis_perkara_id`= '137' AND p1.`nama` IS NOT NULL AND p1.`nama` <> '' THEN 'Disamarkan' 
    						WHEN p.`alur_perkara_id`= '15' AND p.`jenis_perkara_id`= '346' AND p1.`nama` IS NOT NULL AND p1.`nama` <> '' THEN 'Disamarkan'
    						WHEN p.`alur_perkara_id`= '15' AND p.`jenis_perkara_id`= '347' AND p1.`nama` IS NOT NULL AND p1.`nama` <> '' THEN 'Disamarkan'
    						WHEN p.`pihak_dipublikasikan` = 'Y' THEN p1.`nama` 
    						WHEN p.`pihak_dipublikasikan` = 'T' AND p1.`nama` IS NOT NULL AND p1.`nama` <> '' THEN 'Disamarkan' 
    						ELSE p1.`nama` 
						END ) AS nama,
						(CASE WHEN pihak.`tanggal_lahir` IS NOT NULL THEN TIMESTAMPDIFF(YEAR,pihak.`tanggal_lahir`,p.`tanggal_pendaftaran`) ELSE NULL END) AS umur,
						pihak.`jenis_kelamin`,
						p1.`urutan` AS urutan 
						FROM perkara_pihak1 AS p1 
						LEFT JOIN perkara AS p ON p.`perkara_id` = p1.`perkara_id`
						LEFT JOIN pihak ON pihak.`id`=p1.`pihak_id`
						UNION ALL
						SELECT 
						'2' AS pihak_ke,
						p2.`pihak_id` AS ID,
						p2.`perkara_id` AS IDPerkara,
						(CASE
    						WHEN p.`alur_perkara_id` = '118' AND p2.`nama` IS NOT NULL AND p2.`nama` <> '' THEN CONVERT(CONCAT('Anak Berhadapan Dengan Hukum',p2.`urutan`) USING latin1) 
    						WHEN p.`jenis_perkara_id` = '98' AND p2.`nama` IS NOT NULL AND p2.`nama` <> '' THEN 'Terdakwa' 
    						WHEN p.`alur_perkara_id` = '1' AND p.`jenis_perkara_id` = '64' AND p2.`nama` IS NOT NULL AND p2.`nama` <> '' THEN 'Disamarkan' 
    						WHEN p.`alur_perkara_id` = '1' AND p.`jenis_perkara_id` = '137' AND p2.`nama` IS NOT NULL AND p2.`nama` <> '' THEN 'Disamarkan' 
    						WHEN p.`alur_perkara_id` = '15' AND p.`jenis_perkara_id` = '346' AND p2.`nama` IS NOT NULL AND p2.`nama` <> '' THEN 'Disamarkan' 
    						WHEN p.`alur_perkara_id` = '15' AND p.`jenis_perkara_id` = '347' AND p2.`nama` IS NOT NULL AND p2.`nama` <> '' THEN 'Disamarkan' 
    						WHEN p.`pihak_dipublikasikan` = 'T' AND p2.`nama` IS NOT NULL AND p2.`nama` <> '' THEN 'Disamarkan' 
    						ELSE p2.`nama` 
						END) AS nama,
						(CASE WHEN pihak.`tanggal_lahir` IS NOT NULL THEN TIMESTAMPDIFF(YEAR,pihak.`tanggal_lahir`,p.`tanggal_pendaftaran`) ELSE NULL END) AS umur,
						pihak.`jenis_kelamin`,
						p2.`urutan` AS urutan 
						FROM perkara_pihak2 AS p2 
						LEFT JOIN perkara AS p ON p.`perkara_id` = p2.`perkara_id`
						LEFT JOIN pihak ON pihak.`id`=p2.`pihak_id`
						UNION ALL 
						SELECT 
						'3' AS pihak_ke,
						p3.`pihak_id` AS ID,
						p3.`perkara_id` AS IDPerkara,
						(CASE
    						WHEN p.`alur_perkara_id` = '1' AND p.`jenis_perkara_id` = '64' AND p3.`nama` IS NOT NULL AND p3.`nama` <> '' THEN 'Disamarkan' 
    						WHEN p.`alur_perkara_id` = '1' AND p.`jenis_perkara_id` = '137' AND p3.`nama` IS NOT NULL AND p3.`nama` <> '' THEN 'Disamarkan' 
    						WHEN p.`alur_perkara_id` = '15' AND p.`jenis_perkara_id` = '346' AND p3.`nama` IS NOT NULL AND p3.`nama` <> '' THEN 'Disamarkan' 
    						WHEN p.`alur_perkara_id` = '15' AND p.`jenis_perkara_id` = '347' AND p3.`nama` IS NOT NULL AND p3.`nama` <> '' THEN 'Disamarkan' 
    						WHEN p.`pihak_dipublikasikan` = 'T' AND p3.`nama` IS NOT NULL AND p3.`nama` <> '' THEN 'Disamarkan' 
    						ELSE p3.`nama` 
						END) AS nama,
						(CASE WHEN pihak.`tanggal_lahir` IS NOT NULL THEN TIMESTAMPDIFF(YEAR,pihak.`tanggal_lahir`,p.`tanggal_pendaftaran`) ELSE NULL END) AS umur,
						pihak.`jenis_kelamin`,
						p3.`urutan` AS urutan 
						FROM perkara_pihak3 AS p3 
						LEFT JOIN perkara AS p ON p.`perkara_id` = p3.`perkara_id`
						LEFT JOIN pihak ON pihak.`id` = p3.`pihak_id`
						UNION ALL 
						SELECT 
						'4' AS pihak_ke,
						p4.`pihak_id` AS ID,
						p4.`perkara_id` AS IDPerkara,
						(CASE 
    						WHEN p.`alur_perkara_id` = '1' AND p.`jenis_perkara_id` = '64' AND p4.`nama` IS NOT NULL AND p4.`nama` <> '' THEN 'Disamarkan' 
    						WHEN p.`alur_perkara_id` = '1' AND p.`jenis_perkara_id` = '137' AND p4.`nama` IS NOT NULL AND p4.`nama` <> '' THEN 'Disamarkan' 
    						WHEN p.`alur_perkara_id` = '15' AND p.`jenis_perkara_id` = '346' AND p4.`nama` IS NOT NULL AND p4.`nama` <> '' THEN 'Disamarkan' 
    						WHEN p.`alur_perkara_id` = '15' AND p.`jenis_perkara_id` = '347' AND p4.`nama` IS NOT NULL AND p4.`nama` <> '' THEN 'Disamarkan' 
    						WHEN p.`pihak_dipublikasikan` = 'T' AND p4.`nama` IS NOT NULL AND p4.`nama` <> '' THEN 'Disamarkan' 
    						ELSE p4.`nama` 
						END ) AS nama,
						(CASE WHEN pihak.`tanggal_lahir` IS NOT NULL THEN TIMESTAMPDIFF(YEAR,pihak.`tanggal_lahir`,p.`tanggal_pendaftaran`) ELSE NULL END) AS umur,
						pihak.`jenis_kelamin`,
						p4.`urutan` AS urutan 
						FROM `perkara_pihak4` AS p4 
						LEFT JOIN `perkara` AS p ON p.`perkara_id` = p4.`perkara_id`
						LEFT JOIN pihak ON pihak.`id` = p4.`pihak_id`;");

  		$periksakolum = $this->isColumnExist('pihakweb','umur');
        if(!$periksakolum){
		$this->db->query("ALTER TABLE `pihakweb` ADD COLUMN umur INT(3) NULL AFTER nama, ADD COLUMN jenisKelamin VARCHAR(1) NULL AFTER umur, 
						CHANGE urutan urutan INT(20) NULL AFTER jenisKelamin;");
        }    		 				 

  		$this->db->query("DROP VIEW IF EXISTS `viewbandingdetilweb`;");

  		$this->db->query("DROP VIEW IF EXISTS `viewbandingweb`;");

  		$this->db->query("CREATE VIEW `viewbandingweb` AS SELECT
  						A.`perkara_id`                               AS IDPerkara,
  						A.`nomor_perkara_banding`           		 AS noPerkarabanding,
  						A.`permohonan_banding`                       AS tglPermohonanBanding,
  						A.`pemohon_banding`                          AS pemohonBanding,
  						A.`pemberitahuan_permohonan_banding`         AS tglPemberitahuanPermohonan,
  						A.`penerimaan_memori_banding`                AS tglPenerimaanMemori,
  						A.`penyerahan_memori_banding`                AS tglPenyerahanMemori,
  						A.`penerimaan_kontra_banding`                AS tglPenerimaanKontra,
  						A.`penyerahan_kontra_banding`                AS tglPenyerahanKontra,
  						A.`pemberitahuan_inzage_pembanding`          AS tglPemberitahuanInzagePembanding,
  						A.`pemberitahuan_inzage_terbanding`          AS tglPemberitahuanInzageTerbanding,
  						A.`pelaksanaan_inzage_pembanding`            AS tglPelaksanaanInzagePembanding,
  						A.`pelaksanaan_inzage_terbanding`            AS tglPelaksanaanInzageTerbanding,
  						A.`pengiriman_berkas_banding`                AS tglPengirimanBerkas,
  						A.`nomor_surat_pengiriman_berkas_banding`    AS nomorSuratPengiriman,
  						A.`penerimaan_kembali_berkas_banding`        AS tglPenerimaanKembaliBerkas,
  						A.`hakim1_banding`                           AS hakimPertama,
  						A.`hakim2_banding`                           AS hakimKedua,
  						A.`hakim3_banding`                           AS hakimKetiga,
  						A.`hakim4_banding`                           AS hakimKeempat,
  						A.`hakim5_banding`                           AS hakimKelima,
  						A.`panitera_pengganti_banding`               AS paniteraPengganti,
  						A.`putusan_banding`                          AS tglPutusan,
  						A.`nomor_putusan_banding`                    AS noPutusanBanding,
  						(CASE 
							WHEN A.`alur_perkara_id` = '118' THEN 'Disamarkan'
							WHEN B.`jenis_perkara_id` IN ('64','98','242','346','347','248','312','349','350','352') THEN 'Disamarkan'
							ELSE A.`amar_putusan_banding` 
						END) AS amarPutusan,
  						A.`minutasi_banding`                         AS tglMinutasi,
  						A.`pemberitahuan_putusan_banding_pembanding` AS tglPemberitahuanPutusanPembanding,
  						A.`pemberitahuan_putusan_banding_terbanding` AS tglPemberitahuanPutusanTerbanding,
  						A.`catatan_banding`                          AS keterangan
						FROM perkara_banding AS A
						LEFT JOIN perkara AS B ON B.`perkara_id`=A.`perkara_id`;"); 		

  		$this->db->query("CREATE VIEW `viewbandingdetilweb` AS SELECT
  						b.`id`                               AS ID,
  						b.`perkara_id`                       AS IDPerkara,
  						(CASE 
  							WHEN ((b.`alur_perkara_id` = '118') AND (b.`pihak_asal` = '2')) THEN 'Anak Berhadapan Dengan Hukum' 
  							WHEN (p.`jenis_perkara_id` IN ('64','98','242','346','347','248','312','349','350','352')) THEN 'Disamarkan' ELSE b.`pihak_nama` 
  						END) AS nama,
  						b.`status_pihak_id`                  AS IDStatusPihak,
  						CONCAT(IFNULL(b.`status_pihak_text`,''),' (',b.`pihak_asal_text`,')') AS statusPihak,
  						(CASE 
  							WHEN ((b.`alur_perkara_id` = '118') AND (b.`pihak_asal` = '2')) THEN 'Anak Berhadapan Dengan Hukum' 
  							WHEN (p.`jenis_perkara_id` IN ('64','98','242','346','347','248','312','349','350','352')) THEN 'Disamarkan' ELSE b.`pihak_nama` 
  						END) AS pihakNama,
  						b.`pihak_diwakili`                   AS pihakDiwakili,
  						b.`pemohon_nama`                     AS pemohonNama,
  						b.`permohonan_banding`               AS tglPermohonan,
  						b.`pemberitahuan_permohonan_banding` AS tglPemberitahuanPermohonan,
  						b.`penerimaan_memori_banding`        AS tglPenerimaanMemori,
  						b.`penyerahan_memori_banding`        AS tglPenyerahanMemori,
 						b.`penerimaan_kontra_banding`        AS tglPenerimaanKontra,
  						b.`penyerahan_kontra_banding`        AS tglPenyerahanKontra,
  						b.`pemberitahuan_inzage`             AS tglPemberitahuanInzage,
  						b.`pelaksanaan_inzage`               AS tglPelaksanaanInzage,
  						b.`pemberitahuan_putusan_banding`    AS tglPemberitahuanPutusanBanding,
  						b.`tanggal_cabut`                    AS tglCabut,
  						b.`keterangan`                       AS keterangan
						FROM perkara_banding_detil AS b
						LEFT JOIN perkara AS p ON p.`perkara_id` = b.`perkara_id`;"); 	

  		$this->db->query("DROP TABLE IF EXISTS bandingdetilweb;"); 	

  		$this->db->query("DROP TABLE IF EXISTS bandingweb;"); 	

  		$this->db->query("CREATE TABLE `bandingweb` AS SELECT * FROM `viewbandingweb`;"); 	

  		$checkkolum = $this->isColumnExist('bandingweb','IDPerkara');
        if($checkkolum){
		$this->db->query("ALTER TABLE `bandingweb` ADD PRIMARY KEY (IDPerkara);");
        }  

  		$this->db->query("CREATE TABLE `bandingdetilweb` AS SELECT * FROM viewbandingdetilweb;"); 	

  		$checkcols = $this->isColumnExist('bandingdetilweb','ID');
        if($checkcols){
		$this->db->query("ALTER TABLE `bandingdetilweb` ADD PRIMARY KEY (ID,IDPerkara);");
        }  

  		$this->db->query("DROP VIEW IF EXISTS `viewkasasiweb`;"); 	

  		$this->db->query("DROP VIEW IF EXISTS `viewkasasidetilweb`;"); 	

  		$this->db->query("CREATE VIEW `viewkasasiweb` AS SELECT
  						A.`perkara_id`                           AS IDPerkara,
  						A.`nomor_perkara_kasasi`                 AS noPerkaraKasasi,
  						A.`permohonan_kasasi`                    AS tglPermohonankasasi,
  						A.`pemohon_kasasi`                       AS pemohonkasasi,
  						A.`pengiriman_berkas_kasasi`             AS tglPengirimanBerkas,
  						A.`nomor_surat_pengiriman_berkas_kasasi` AS noSuratPengiriman,
  						A.`penerimaan_berkas_kasasi`             AS tglPenerimaanKembaliBerkas,
  						A.`hakim1_kasasi`                        AS hakimPertama,
  						A.`hakim2_kasasi`                        AS hakimKedua,
  						A.`hakim3_kasasi`                        AS hakimKetiga,
  						A.`hakim4_kasasi`                        AS hakimKeempat,
  						A.`hakim5_kasasi`                        AS hakimKelima,
  						A.`panitera_pengganti_kasasi`            AS paniteraPengganti,
  						A.`putusan_kasasi`                       AS tglPutusan,
  						A.`nomor_putusan_kasasi`                 AS noPutusankasasi,
  						(CASE 
							WHEN A.`alur_perkara_id` = '118' THEN 'Disamarkan'
							WHEN B.`jenis_perkara_id` IN ('64','98','242','346','347','248','312','349','350','352') THEN 'Disamarkan'
							ELSE A.`amar_putusan_kasasi` 
						END) AS amarPutusan,
  						A.`minutasi_kasasi`                      AS tglMinutasi,
  						A.`tanggal_berita_putusan_kasasi`        AS tglBeritaPutusan,
  						A.`nama_media_berita_putusan_kasasi`     AS namaMediaBerita,
  						A.`tanggal_surat_kabar_putusan_kasasi`   AS tglSuratKabar,
  						A.`nama_surat_kabar_putusan_kasasi`      AS namaSuratKabar,
  						A.`prodeo_kasasi`                        AS prodeo,
  						A.`catatan_putusan_kasasi`               AS keterangan
						FROM perkara_kasasi AS A
						LEFT JOIN perkara AS B ON B.`perkara_id`=A.`perkara_id`;"); 	

  		$this->db->query("CREATE VIEW `viewkasasidetilweb` AS SELECT
  						k.`id`                           AS ID,
  						k.`perkara_id`                   AS IDPerkara,
  						(CASE 
  							WHEN ((p.`jenis_perkara_id` IN ('248','312')) AND (k.`pihak_asal` = '2')) THEN 'Anak Berhadapan Dengan Hukum' 
  							WHEN (p.`jenis_perkara_id` IN ('64','98','242','346','347','349','350','352')) THEN 'Disamarkan' ELSE k.`pihak_nama` 
  						END) AS nama,
  						k.`status_pihak_id`              AS IDStatusPihak,
  						CONCAT(IFNULL(k.`status_pihak_text`,''),' (',k.`pihak_asal_text`,')') AS statusPihak,
  						(CASE 
  							WHEN ((p.`jenis_perkara_id` IN ('248','312')) AND (k.`pihak_asal` = '2')) THEN 'Anak Berhadapan Dengan Hukum' 
  							WHEN (p.`jenis_perkara_id` IN ('64','98','242','346','347','349','350','352')) THEN 'Disamarkan' ELSE k.`pihak_nama` 
  						END) AS pihak_nama,
  						k.`pihak_diwakili`               AS pihak_diwakili,
  						k.`pemohon_nama`                 AS pemohon_nama,
  						k.`permohonan_kasasi`            AS tglPermohonan,
  						k.`pemberitahuan_kasasi`         AS tglPemberitahuanPermohonan,
  						k.`penerimaan_memori_kasasi`     AS tglPenerimaanMemori,
  						k.`penyerahan_memori_kasasi`     AS tglPenyerahanMemori,
  						k.`penerimaan_kontra_kasasi`     AS tglPenerimaanKontra,
  						k.`penyerahan_kontra_kasasi`     AS tglPenyerahanKontra,
  						k.`pemberitahuan_inzage_kasasi`  AS tglPemberitahuanInzage,
  						k.`pelaksanaan_inzage_kasasi`    AS tglPelaksanaanInzage,
  						k.`pemberitahuan_putusan_kasasi` AS tglPemberitahuanPutusanKasasi,
  						k.`tanggal_cabut`                AS tglCabut
						FROM perkara_kasasi_detil AS k
						LEFT JOIN perkara AS p ON p.`perkara_id` = k.`perkara_id`;"); 	

  		$this->db->query("DROP TABLE IF EXISTS `kasasidetilweb`;"); 	

  		$this->db->query("DROP TABLE IF EXISTS `kasasiweb`;"); 	

  		$this->db->query("CREATE TABLE `kasasiweb` AS SELECT * FROM `viewkasasiweb`;"); 	

  		$checkcolumns = $this->isColumnExist('kasasiweb','IDPerkara');
        if($checkcolumns){
		$this->db->query("ALTER TABLE `kasasiweb` ADD PRIMARY KEY (IDPerkara);");
        }  

  		$this->db->query("CREATE TABLE `kasasidetilweb` AS SELECT * FROM viewkasasidetilweb;"); 

  		$checkcolumn = $this->isColumnExist('kasasidetilweb','ID');
        if($checkcolumn){
		$this->db->query("ALTER TABLE `kasasidetilweb` ADD PRIMARY KEY (ID,IDPerkara);");
        }  	

  		$this->db->query("ALTER VIEW `viewjenisperkaraweb` AS SELECT
  						jenis_perkara.`id`   AS id,
  						alur_perkara.`id`    AS idalurperkara,
  						(CASE WHEN sys_config.`value` = '1'
						THEN (CASE WHEN alur_perkara.`id` < 100 THEN CONCAT('[PERDATA] ',jenis_perkara.`nama_lengkap`) ELSE CONCAT('[PIDANA] ',jenis_perkara.`nama_lengkap`) END)
						ELSE jenis_perkara.`nama` END
						) AS namaKU
						FROM jenis_perkara
						LEFT JOIN jenis_alur_perkara ON jenis_perkara.`id` = jenis_alur_perkara.`jenis_perkara_id`
						LEFT JOIN alur_perkara ON jenis_alur_perkara.`alur_perkara_id` = alur_perkara.`id`
						LEFT JOIN sys_config ON alur_perkara.`jenis_pengadilan`= sys_config.`value`
						WHERE sys_config.`id` = '83'
						AND alur_perkara.`aktif` = 'Y'
						GROUP BY jenis_perkara.`id`
						ORDER BY jenis_perkara.`nama`;"); 	

  		$periksa = $this->isColumnExist('dataumumweb','nilai_sengketa');
        if($periksa){
		$this->db->query("ALTER TABLE dataumumweb CHANGE nilai_sengketa nilai_sengketa BIGINT(20) NULL;");
        }
        $isthere = FALSE;
		$result = $this->db->query("SHOW INDEXES FROM dataumumweb WHERE Key_name = 'jenisPerkara'");
		if(!empty($result)){
		    if($result->num_rows>0){
		        $isthere = TRUE;
		    }
		}
		if($isthere){
			$this->db->query("ALTER TABLE dataumumweb DROP INDEX jenisPerkara, ENGINE=INNODB;");
		}  	  		

        $periksa2 = $this->isColumnExist('perkaraputusanweb','nilaiGantiRugi');
        if($periksa2){
		$this->db->query("ALTER TABLE perkaraputusanweb CHANGE nilaiGantiRugi nilaiGantiRugi BIGINT(20) NULL;");
        }  	  		

		$periksa3 = $this->isColumnExist('biaya_perkara','jumlah');
        if($periksa3){
		$this->db->query("ALTER TABLE biaya_perkara MODIFY COLUMN jumlah DECIMAL(16,2) UNSIGNED NOT NULL;");
        } 

        $periksa4 = $this->isColumnExist('jenis_biaya','jumlah');
        if($periksa4){
		$this->db->query("ALTER TABLE jenis_biaya MODIFY COLUMN jumlah DECIMAL(16,2) UNSIGNED DEFAULT 0.00 NOT NULL COMMENT 'Jumlah Nominal: (dalam rupiah)';");
        } 

        $periksa5 = $this->isColumnExist('perkara_biaya','jumlah');
        if($periksa5){
		$this->db->query("ALTER TABLE perkara_biaya MODIFY COLUMN jumlah DECIMAL(16,2) UNSIGNED NOT NULL COMMENT 'Jumlah nominal tansaksi(dalam Rp)', MODIFY COLUMN sisa DECIMAL(16,2) UNSIGNED NULL  COMMENT 'Jumlah Nominal Sisa: isian bilangan (Rp)';");
        } 

        $periksa6 = $this->isColumnExist('perkara_biaya_ht','jumlah');
        if($periksa6){
		$this->db->query("ALTER TABLE perkara_biaya_ht MODIFY COLUMN jumlah DECIMAL(16,2) UNSIGNED NOT NULL, MODIFY COLUMN sisa  DECIMAL(16,2) UNSIGNED NULL;");
        } 

        $this->db->query("UPDATE `penahanan_terdakwa` SET lama_penahanan=(DATEDIFF(sampai,mulai) + 1);");

  		$this->db->query("DROP FUNCTION IF EXISTS `GetListPengacaraPihak4Text`;");
		$this->db->query("CREATE FUNCTION `GetListPengacaraPihak4Text`(var_id BIGINT(20)) RETURNS VARCHAR(3000) CHARSET latin1
						BEGIN
						  DECLARE listpihak VARCHAR(3000);
						  	SELECT IF(COUNT(perkara_id)>1, GROUP_CONCAT(CONCAT(CAST(urutan AS CHAR(2)),'.', nama) ORDER BY urutan SEPARATOR '<br />'),nama ) INTO listpihak FROM 
							perkara_pengacara 
							WHERE perkara_id=var_id AND pihak_ke=4
							GROUP BY perkara_id;
						  RETURN listpihak;
						END");

		$this->db->query("REPLACE INTO `sys_groups` (`groupid`, `parent_id`, `level`, `lft`, `rgt`, `name`, `description`, `enable`, `ordering`, `lock_by`, `lock_on`, `created_by`, `created_on`, `modified_by`, `modified_on`) values
					('470','30','5','54','61','Panmud Pidana Khusus Perikanan','Panitera Muda Pidana Khusus Perikanan','1','7','',NULL,'system','2012-09-04 19:44:29','','2012-11-15 20:50:41'),
					('471','470','6','55','56','Admin Panmud Pidana Khusus Perikanan','Admin Panitera Muda Pidana Khusus Perikanan','0','1','',NULL,'system','2012-09-04 20:04:36','','2012-11-15 20:11:54'),
					('472','470','6','57','58','Meja I Pidana Khusus Perikanan','Meja I Pidana Khusus Perikanan','1','2','',NULL,'system','2012-09-04 20:05:12','','2012-09-04 23:11:38'),
					('473','470','6','59','60','Meja II Pidana Khusus Perikanan','Meja II Pidana Khusus Perikanan','1','3','',NULL,'system','2012-09-04 20:05:47','','2012-09-05 18:26:18');");		
		$this->db->query("REPLACE INTO `sys_group_rule` (`groupid`, `ruleid`) values
					('470','1'),('470','6'),('470','80'),('470','229'),('470','338'),('470','340'),('470','341'),('470','342'),('470','378'),
					('470','379'),('470','384'),('470','385'),('470','387'),('470','388'),('470','390'),('470','391'),('470','477'),('470','490'),
					('471','338'),('471','340'),('471','341'),('471','342'),('471','379'),('471','385'),('471','388'),('471','391'),('471','477'),
					('472','338'),('472','340'),('472','341'),('472','342'),('472','477'),('473','338'),('473','340'),('473','341'),('473','342'),
					('473','477');");

		$cekdata = $this->isColumnExist('perkaraputusanterdakwa','ID');
        if($cekdata){
			$this->db->query("RENAME TABLE perkaraputusanterdakwa TO perkaraputusanterdakwaweb;");
        }
		
		$this->db->query("DROP VIEW IF EXISTS viewperkaraputusanterdakwa;");
		$this->db->query("DROP VIEW IF EXISTS viewperkaraputusanterdakwaweb;");
		$this->db->query("CREATE VIEW viewperkaraputusanterdakwaweb AS 
							SELECT
							  p.id                      AS ID,
							  p.perkara_id              AS IDPerkara,
							  pp.status_putusan_id      AS IDStatusPutusan,
							  (CASE WHEN (v_perkara.pihak_dipublikasikan = 'T') THEN CONVERT(CONCAT('Terdakwa',p.urutan) USING latin1) WHEN (v_perkara.alur_perkara_id = 118) THEN CONVERT(CONCAT('Anak Berhadapan Dengan Hukum ',p.urutan) USING latin1) ELSE p.nama END) AS nama,
							  pp.durasi_nominal         AS durasiNominal,
							  v_perkara.tanggal_putusan AS tglPutusan,
							  s.nama                    AS statusPutusan,
							  pp.satuan                 AS satuan
							FROM perkara_pihak2 AS p
							LEFT JOIN perkara_putusan_terdakwa AS pp ON pp.perkara_id=p.perkara_id AND pp.pihak2_id=p.id
							LEFT JOIN status_putusan AS s ON s.id=pp.status_putusan_id
							LEFT JOIN v_perkara ON v_perkara.perkara_id=pp.perkara_id
							WHERE v_perkara.alur_perkara_id>100
							ORDER BY p.urutan;");

		$this->db->query("DROP VIEW IF EXISTS viewpkweb;");		
		$this->db->query("CREATE VIEW viewpkweb AS 
							SELECT
							  perkara_pk.perkara_id                       AS IDPerkara,
							  perkara_pk.nomor_perkara_pk                 AS noPerkarapk,
							  perkara_pk.permohonan_pk                    AS tglPermohonan,
							  perkara_pk.pemohon_pk                       AS pemohon,
							  perkara_pk.pemberitahuan_pk                 AS tglPemberitahuanPermohonan,
							  perkara_pk.penerimaan_memori_pk             AS tglPenerimaanMemori,
							  perkara_pk.penyerahan_memori_pk             AS tglPenyerahanMemori,
							  perkara_pk.penerimaan_kontra_pk             AS tglPenerimaanKontra,
							  perkara_pk.penyerahan_kontra_pk             AS tglPenyerahanKontra,
							  perkara_pk.pemberitahuan_inzage_pemohon_pk  AS tglPemberitahuanInzagePihak1,
							  perkara_pk.pemberitahuan_inzage_termohon_pk AS tglPemberitahuanInzagePihak2,
							  perkara_pk.pelaksanaan_inzage_pemohon_pk    AS tglPelaksanaanInzagePihak1,
							  perkara_pk.pelaksanaan_inzage_termohon_pk   AS tglPelaksanaanInzagePihak2,
							  perkara_pk.pengiriman_berkas_pk             AS tglPengirimanBerkas,
							  perkara_pk.nomor_surat_pengiriman_berkas_pk AS nomorSuratPengiriman,
							  perkara_pk.penerimaan_berkas_pk             AS tglPenerimaanKembaliBerkas,
							  perkara_pk.majelis_hakim_pk                 AS majelisHakim,
							  perkara_pk.panitera_pengganti_pk            AS paniteraPengganti,
							  perkara_pk.putusan_pk                       AS tglPutusan,
							  perkara_pk.nomor_putusan_pk                 AS noPutusanPK,
							  perkara_pk.amar_putusan_pk                  AS amarPutusan,
							  perkara_pk.minutasi_pk                      AS tglMinutasi,
							  perkara_pk.pemberitahuan_putusan_pk_pihak1  AS tglPemberitahuanPutusanPihak1,
							  perkara_pk.pemberitahuan_putusan_pk_pihak2  AS tglPemberitahuanPutusanPihak2
							FROM perkara_pk;");
		
		$this->db->query("DROP VIEW IF EXISTS viewpkdetilweb;");
		$this->db->query("CREATE VIEW viewpkdetilweb AS 
							SELECT
							  pk.id                       AS ID,
							  pk.perkara_id               AS IDPerkara,
							  (CASE WHEN ((p.jenis_perkara_id IN (248,312)) AND (pk.pihak_asal = 2)) THEN 'Anak Berhadapan dengan Hukum' WHEN (p.jenis_perkara_id IN (64,98,242,346,347,349,350,352)) THEN 'disamarkan' ELSE pk.pihak_nama END) AS nama,
							  pk.status_pihak_id          AS IDStatusPihak,
							  CONCAT(IFNULL(pk.status_pihak_text,''),' (',pk.pihak_asal_text,')') AS statusPihak,
							  (CASE WHEN ((p.jenis_perkara_id IN (248,312)) AND (pk.pihak_asal = 2)) THEN 'Anak Berhadapan dengan Hukum' WHEN (p.jenis_perkara_id IN (64,98,242,346,347,349,350,352)) THEN 'disamarkan' ELSE pk.pihak_nama END) AS pihak_nama,
							  pk.pihak_diwakili           AS pihak_diwakili,
							  pk.pemohon_nama             AS pemohon_nama,
							  pk.permohonan_pk            AS tglPermohonan,
							  pk.pemberitahuan_pk         AS tglPemberitahuanPermohonan,
							  pk.penerimaan_memori_pk     AS tglPenerimaanMemori,
							  pk.penyerahan_memori_pk     AS tglPenyerahanMemori,
							  pk.penerimaan_kontra_pk     AS tglPenerimaanKontra,
							  pk.penyerahan_kontra_pk     AS tglPenyerahanKontra,
							  pk.pemberitahuan_inzage_pk  AS tglPemberitahuanInzage,
							  pk.pelaksanaan_inzage_pk    AS tglPelaksanaanInzage,
							  pk.pemberitahuan_putusan_pk AS tglPemberitahuanPutusan,
							  pk.tanggal_cabut            AS tglCabut
							FROM perkara_pk_detil AS pk
							LEFT JOIN perkara AS p ON p.perkara_id=pk.perkara_id;");
		
		$this->db->query("DROP TABLE IF EXISTS pkweb;");
		$this->db->query("CREATE TABLE pkweb AS SELECT * FROM viewpkweb;");

		$cekdata = $this->isColumnExist('pkweb','IDPerkara');
        if($cekdata){
		$this->db->query("ALTER TABLE pkweb ADD PRIMARY KEY (IDPerkara);");
        }

        $this->db->query("DROP TABLE IF EXISTS pkdetilweb;"); 
		$this->db->query("CREATE TABLE pkdetilweb AS SELECT * FROM viewpkdetilweb;");
		$cekdata = $this->isColumnExist('pkdetilweb','ID');
        if($cekdata){
		$this->db->query("ALTER TABLE pkdetilweb ADD PRIMARY KEY (ID);");
        }

        $this->db->query("DROP VIEW vieweksekusidetilweb;");
        $this->db->query("CREATE VIEW vieweksekusidetilweb AS
							SELECT
							  perkara_eksekusi_detil.id                  AS ID,
							  perkara_eksekusi_detil.perkara_id          AS IDPerkara,
							  perkara_eksekusi_detil.pihak_nama          AS nama,
							  perkara_eksekusi_detil.status_pihak_id     AS IDStatusPihak,
							  CONCAT(perkara_eksekusi_detil.status_pihak_text,'(',perkara_eksekusi_detil.pihak_asal_text,')') AS statusPihak,
							  IF((perkara_eksekusi_detil.pihak_diwakili = 'Y'),perkara_eksekusi_detil.pemohon_nama,NULL) AS pihakDimohonkan,
							  perkara_eksekusi_detil.permohonan_eksekusi AS tglPemberitahuanPermohonan
							FROM perkara_eksekusi_detil;");

        $this->db->query("DROP VIEW vieweksekusiweb;");
        $this->db->query("CREATE VIEW vieweksekusiweb AS
							SELECT
								perkara_eksekusi.perkara_id AS IDPerkara,
								perkara_eksekusi.alur_perkara_id AS IDAlurPerkara,
								perkara_eksekusi.nomor_perkara_pn AS noPerkaraPN,
								perkara_eksekusi.putusan_pn AS PutusanPN,
								perkara_eksekusi.nomor_perkara_banding AS noPerkaraBanding,
								perkara_eksekusi.putusan_banding AS putusanBanding,
								perkara_eksekusi.nomor_perkara_kasasi AS noPerkaraKasasi,
								perkara_eksekusi.putusan_kasasi AS putusanKasasi,
								perkara_eksekusi.nomor_perkara_pk AS noPerkaraPK,
								perkara_eksekusi.putusan_pk AS putusanPK,
								perkara_eksekusi.eksekusi_putusan AS eksekusiPutusan,
								perkara_eksekusi.eksekusi_nomor_perkara AS eksekusiNomorPerkara,
								perkara_eksekusi.eksekusi_amar_putusan AS eksekusiAmarPutusan,
								perkara_eksekusi.pihak_pemohon_eksekusi AS pihakPemohonEksekusi,
								perkara_eksekusi.permohonan_eksekusi AS permohonanEsekusi,
								perkara_eksekusi.pemohon_eksekusi AS pemohonEksekusi,
								perkara_eksekusi.para_pihak AS paraPihak,
								perkara_eksekusi.penetapan_teguran_eksekusi AS penetapanTeguranEksekusi,
								perkara_eksekusi.nomor_penetapan_teguran_eksekusi AS nomorPenetapanTeguranEksekusi,
								perkara_eksekusi.pelaksanaan_teguran_eksekusi AS pelaksanaanTeguranEksekusi,
								perkara_eksekusi.penetapan_sita_eksekusi AS penetapanSitaEksekusi,
								perkara_eksekusi.nomor_penetapan_sita_eksekusi AS nomorPenetapanSitaEksekusi,
								perkara_eksekusi.pelaksanaan_sita_eksekusi AS pelaksanaanSitaEksekusi,
								perkara_eksekusi.jurusita_nama AS jurusitaNama,
								perkara_eksekusi.penetapan_perintah_eksekusi_lelang AS penetapanPerintahEksekusiLelang,
								perkara_eksekusi.pelaksanaan_eksekusi_lelang AS pelaksanaanEksekusiLelang,
								perkara_eksekusi.penyerahan_hasil_lelang AS penyerahanHasilLelang,
								perkara_eksekusi.penetapan_perintah_eksekusi_rill AS penetapanPerintahEksekusiRill,
								perkara_eksekusi.pelaksanaan_eksekusi_rill AS pelaksanaanEksekusiRill,
								perkara_eksekusi.penetapan_noneksekusi AS penetapanNoneksekusi,
								perkara_eksekusi.diterima_permohonan AS diterimaPermohonan,
								perkara_eksekusi.panggilan_parapihak AS panggilanParapihak,
								perkara_eksekusi.penetapan_ketua AS penetapanKetua,
								perkara_eksekusi.sk_objek_tidak_punya_kekuatan_hukum AS skObjekTidakPunyaKekuatanHukum,
								perkara_eksekusi.surat_tergugat_objek_non_executable AS suratTergugatObjekNonExecutable,
								perkara_eksekusi.panggilan_pihak_non_executable AS panggilanPihakNonExecutable,
								perkara_eksekusi.upaya_kesepakatan_kompensasi AS upayaKesepakatanKompensasi,
								perkara_eksekusi.penetapan_ketua_kompensasi AS penetapanKetuaKompensasi,
								perkara_eksekusi.upaya_hukum_kma AS upayaHukumKma,
								perkara_eksekusi.penetapan_kma_kompensasi AS penetapanKmaKompensasi,
								perkara_eksekusi.uangpaksa_putusan_hakim AS uangpaksaPutusanHakim,
								perkara_eksekusi.uangpaksa_penetapan_ketua AS uangpaksaPenetapanKetua,
								perkara_eksekusi.surat_ketua_tergugat_uangpaksa AS suratKetuaTergugatUangpaksa,
								perkara_eksekusi.surat_peringatan_uangpaksa AS suratPeringatanUangpaksa,
								perkara_eksekusi.perintah_ketua_saksi_administratif AS perintahKetuaSaksiAdministratif,
								perkara_eksekusi.sanksi_administratif_dari_pejabat AS sanksiAministratifDariPejabat,
								perkara_eksekusi.pengumuman_ketua_panitera_js AS pengumumanKetuaPaniteraJs,
								perkara_eksekusi.pengumuman_media AS pengumumanMedia,
								perkara_eksekusi.surat_presiden AS surat_Pesiden,
								perkara_eksekusi.surat_lembaga_perwakilan_rakyat AS suratLembagaPerwakilanRakyat,
								perkara_eksekusi.alasan_eksekusi AS alasanEksekusi,
								perkara_eksekusi.catatan_eksekusi AS catatanEksekusi,
								perkara_eksekusi.prodeo_eksekusi AS prodeoEksekusi,
								perkara_eksekusi.status_eksekusi_text AS statusEksekusiText,
								perkara.prodeo AS prodeo,
								perkara.tanggal_pendaftaran AS tglPendaftaranAction
							FROM perkara_eksekusi
							LEFT JOIN perkara ON perkara_eksekusi.perkara_id=perkara.perkara_id;");
		
		$this->db->query("DROP TABLE IF EXISTS eksekusidetilweb;");
		$this->db->query("CREATE TABLE eksekusidetilweb AS SELECT * FROM vieweksekusidetilweb;");

		$cekdata = $this->isColumnExist('eksekusidetilweb','ID');
        if($cekdata){
		$this->db->query("ALTER TABLE eksekusidetilweb ADD PRIMARY KEY (ID);");
        }

		$this->db->query("DROP TABLE IF EXISTS eksekusiweb;");
		$this->db->query("CREATE TABLE eksekusiweb AS SELECT * FROM vieweksekusiweb;");
		$cekdata = $this->isColumnExist('eksekusiweb','IDPerkara');
        if($cekdata){
		$this->db->query("ALTER TABLE eksekusiweb ADD PRIMARY KEY (IDPerkara);");
        }

		$this->db->query("DROP PROCEDURE IF EXISTS updateTable;");
		$this->db->query("CREATE PROCEDURE updateTable()
							BEGIN
								DELETE FROM dataumumweb;
								REPLACE INTO dataumumweb SELECT * FROM viewdataumumweb;
								DELETE FROM jenisperkaraweb;
								REPLACE INTO jenisperkaraweb SELECT * FROM viewjenisperkaraweb;
								DELETE FROM pihakweb;
								REPLACE INTO pihakweb SELECT * FROM viewpihakweb;
								DELETE FROM pengacaraweb;
								REPLACE INTO pengacaraweb SELECT * FROM viewpengacaraweb;
								DELETE FROM hakimweb;
								REPLACE INTO hakimweb SELECT * FROM viewhakimweb;
								DELETE FROM ppweb;
								REPLACE INTO ppweb SELECT * FROM viewppweb;
								DELETE FROM jurusitaweb;
								REPLACE INTO jurusitaweb SELECT * FROM viewjurusitaweb;
								DELETE FROM mediasiweb;
								REPLACE INTO mediasiweb SELECT * FROM viewmediasiweb;
								DELETE FROM jadwalsidangweb;
								REPLACE INTO jadwalsidangweb SELECT * FROM viewjadwalsidangweb;
								DELETE FROM perkarabiayaweb;
								REPLACE INTO perkarabiayaweb SELECT * FROM viewperkarabiayaweb ORDER BY idperkara,tgltransaksi ASC;
								DELETE FROM verzetweb;
								REPLACE INTO verzetweb SELECT * FROM viewverzetweb;
								DELETE FROM penahananweb;
								REPLACE INTO penahananweb SELECT * FROM viewpenahananweb;
								DELETE FROM putusanselaweb;
								REPLACE INTO putusanselaweb SELECT * FROM viewputusanselaweb;
								DELETE FROM pihakintervensiweb;
								REPLACE INTO pihakintervensiweb SELECT * FROM viewpihakintervensiweb;
								DELETE FROM bandingweb;
								REPLACE INTO bandingweb SELECT * FROM viewbandingweb;
								DELETE FROM bandingdetilweb;
								REPLACE INTO bandingdetilweb SELECT * FROM viewbandingdetilweb;
								DELETE FROM diversiweb;
								REPLACE INTO diversiweb SELECT * FROM viewdiversiweb;
								DELETE FROM eksekusiweb;
								REPLACE INTO eksekusiweb SELECT * FROM vieweksekusiweb;
								DELETE FROM eksekusidetilweb;
								REPLACE INTO eksekusidetilweb SELECT * FROM vieweksekusidetilweb; 
								DELETE FROM kasasiweb;	
								REPLACE INTO kasasiweb SELECT * FROM viewkasasiweb;
								DELETE FROM kasasidetilweb;
								REPLACE INTO kasasidetilweb SELECT * FROM viewkasasidetilweb;
								DELETE FROM pkweb;
								REPLACE INTO pkweb SELECT * FROM viewpkweb;
								DELETE FROM pkdetilweb;
								REPLACE INTO pkdetilweb SELECT * FROM viewpkdetilweb;
								DELETE FROM prosesweb;
								REPLACE INTO prosesweb SELECT * FROM viewprosesweb;
								DELETE FROM grasiweb;
								REPLACE INTO grasiweb SELECT * FROM viewgrasiweb;
								DELETE FROM perkarapenuntutanweb;
								REPLACE INTO perkarapenuntutanweb SELECT * FROM viewperkarapenuntutanweb;   
								DELETE FROM actiopaulianaweb;
								REPLACE INTO actiopaulianaweb SELECT * FROM viewactiopaulianaweb;
								DELETE FROM perkaraprosesweb;
								REPLACE INTO perkaraprosesweb SELECT * FROM viewperkaraprosesweb;
								DELETE FROM perkarakeberatanweb;
								REPLACE INTO perkarakeberatanweb SELECT * FROM viewperkarakeberatanweb;
								DELETE FROM perkaraeksekusihtweb;
								REPLACE INTO perkaraeksekusihtweb SELECT * FROM viewperkaraeksekusihtweb;
								DELETE FROM putusanpemberitahuanweb;
								REPLACE INTO putusanpemberitahuanweb SELECT * FROM viewputusanpemberitahuanweb;
								DELETE FROM barangbuktiweb;
								REPLACE INTO barangbuktiweb SELECT * FROM viewbarangbuktiweb;
								DELETE FROM perkaralalulintasweb;
								REPLACE INTO perkaralalulintasweb SELECT * FROM viewperkaralalulintasweb;
								DELETE FROM perkaraputusanweb;
								REPLACE INTO perkaraputusanweb SELECT * FROM viewperkaraputusanweb;
								DELETE FROM perkaraputusanterdakwaweb;
								REPLACE INTO perkaraputusanterdakwaweb SELECT * FROM viewperkaraputusanterdakwaweb;
								DELETE FROM rekonvensiweb;
								REPLACE INTO rekonvensiweb SELECT * FROM viewrekonvensiweb;
								DELETE FROM alurperkaraweb;
								REPLACE INTO alurperkaraweb SELECT * FROM viewalurperkaraweb;
								DELETE FROM statuspihakweb;
								REPLACE INTO statuspihakweb SELECT * FROM viewstatuspihakweb;
								DELETE FROM ikrarweb;
								REPLACE INTO ikrarweb SELECT * FROM viewikrarweb;
								DELETE FROM perkaramatraweb;
								REPLACE INTO perkaramatraweb SELECT * FROM viewperkaramatraweb;
								DELETE FROM panggilandismissalweb;
								REPLACE INTO panggilandismissalweb SELECT * FROM viewpanggilandismissalweb;
								DELETE FROM penetapandismissalweb;
								REPLACE INTO penetapandismissalweb SELECT * FROM viewpenetapandismissalweb;
								DELETE FROM sidangpertamaweb;
								REPLACE INTO sidangpertamaweb SELECT * FROM viewsidangpertamaweb;
								DELETE FROM penetapanpersiapanweb;
								REPLACE INTO penetapanpersiapanweb SELECT * FROM viewpenetapanpersiapanweb;
								DELETE FROM penetapanpersiapanprosesweb;
								REPLACE INTO penetapanpersiapanprosesweb SELECT * FROM viewpenetapanpersiapanprosesweb;
								DELETE FROM statusputusanweb;
								REPLACE INTO statusputusanweb SELECT * FROM viewstatusputusanweb;
								DELETE FROM jenisperkaraweb;
								REPLACE INTO jenisperkaraweb SELECT * FROM viewjenisperkaraweb;
								DELETE FROM delegasikeluarweb;
								REPLACE INTO delegasikeluarweb SELECT * FROM viewdelegasikeluarweb;
								DELETE FROM delegasimasukweb;
								REPLACE INTO delegasimasukweb SELECT * FROM viewdelegasimasukweb;
								DELETE FROM delegasiproseskeluarweb;
								REPLACE INTO delegasiproseskeluarweb SELECT * FROM viewdelegasiproseskeluarweb;
								DELETE FROM delegasiprosesmasukweb;
								REPLACE INTO delegasiprosesmasukweb SELECT * FROM viewdelegasiprosesmasukweb;
							END");


		$this->db->query("UPDATE sys_config SET `value` = '3.1.4' WHERE id = '80';");
		
		//update table update patch 3.1.3
		$data = array('updated' => 1,'updated_stamp'=>date("Y-m-d H:i:s"));
		$this->db->where('patch_ver', '3.1.4');
		$this->db->update('updates', $data); 
		
		$this->db->query("SET FOREIGN_KEY_CHECKS=1;");

		return true;
	}

}