<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class detil_perkara_mil extends CI_Controller {
	function index(){
		#prevent direct access to page
		#the user should only access the page through menu
		if($this->nativesession->get_flash_session('security')==FALSE){
			redirect('main');
		}
		
		if($this->session->userdata('is_logged_in')==FALSE){
			redirect('login');
		}

		$idperkara = $this->nativesession->get_flash_session('perkara_id');
		if(!is_numeric($idperkara)){
			redirect('main');
		}
		$isDataUmum = $this->nativesession->get_flash_session('open_dataumum');
		if($isDataUmum=="No"){
			$this->show_data($idperkara);
		}elseif($isDataUmum=="Yes"){
			$this->show_dataumum($idperkara);
		}
	}

	function show_data($idperkara){
		$this->load->model('perkara/info_perkara_mil','perkara');
		$this->perkara->repair_riwayat_perkara_sidang_pertama($idperkara);
		$data = $this->parseData($this->perkara->getInfoPerkara($idperkara));
		$data['ada_barang_bukti']=$this->perkara->get_barang_bukti($idperkara);
		$data['alur_perkara_id']=$data['idalurperkara'];
		$data['perkaraid']=$idperkara;
		$data['pihak_pertama'] = $this->perkara->getInfoPihakPertama($idperkara);
		
		$data['terdakwa_tidak_hadir'] = 0;
		$data["ada_data_banding"] = $this->perkara->getInfoBanding($idperkara);
		$data["ada_data_kasasi"] = $this->perkara->getInfoKasasi($idperkara);
		$data["ada_data_PK"] = $this->perkara->getInfoPK($idperkara);
		$data["ada_data_grasi"] = '';
		
		$data['pihak_kedua'] = $this->perkara->getInfoPihakKedua($idperkara);
		$data['terdakwa_tidak_hadir'] = $this->perkara->getInfoTerdakwaTidakHadir($idperkara);
		$data["ada_data_grasi"] = $this->perkara->getInfoGrasi($idperkara);	
		$data["pengacara_pihak_pertama"] = $this->perkara->getInfoPengacara($idperkara,1,$data['idalurperkara']);
		$data["pengacara_pihak_kedua"] = $this->perkara->getInfoPengacara($idperkara,2,$data['idalurperkara']);

		$data["ada_data_saksi"] = $this->perkara->get_jumlah_saksi($idperkara);

		$data['page_title'] = 'INFORMASI DETAIL PERKARA';
		$data['enc'] = $this->nativesession->get_flash_session('enc');
		$data['main_body'] = 'perkara/detil_perkara_mil';
		$data['main_history'] = $this->nativesession->get('main_url_requested');
		$data['history'] = $this->nativesession->get_flash_session('url_requested');
		$this->load->vars($data);
		$this->load->view('header');
		$this->load->view('body/body_new');
	}

	function show_dataumum($idperkara){
		$data['history'] = $this->nativesession->get_flash_session('url_requested');
		$this->load->model('perkara/info_perkara_mil','perkara');
		$data = $this->parseData($this->perkara->getInfoPerkara($idperkara));
		$data['ada_barang_bukti']=$this->perkara->get_barang_bukti($idperkara);
		$data['perkaraid']=$idperkara;
		$data['pihak_pertama'] = $this->perkara->getInfoPihakPertama($idperkara);
		$data['pihak_kedua'] = $this->perkara->getInfoPihakKedua($idperkara);
		
		$data["pengacara_pihak_pertama"] = $this->perkara->getInfoPengacara($idperkara,1,$data['idalurperkara']);
		$data["pengacara_pihak_kedua"] = $this->perkara->getInfoPengacara($idperkara,2,$data['idalurperkara']);

		$data['enc'] = $this->nativesession->get_flash_session('enc');
		$data['alur_perkara_id']=$data['idalurperkara'];
		$this->load->vars($data);
		$this->load->view('perkara_tab/data_umum_mil');
	}

	function parseData($info_perkara){
		if($info_perkara!=''){
			if($info_perkara->num_rows>0){
				foreach ($info_perkara->result() as $row) {
					$data['idalurperkara'] = $row->alur_perkara_id;
					$data['noPerkara'] = $row->nomor_perkara;
					$data['noUrut'] = $row->nomor_urut_register;
					$data['tglSurat'] = $row->tanggal_surat;
					$data['noSurat'] = $row->nomor_surat;
					$data['idProses'] = $row->proses_terakhir_id;
					$data['prosesText'] = $row->proses_terakhir_text;
					$data['idTahapan'] = $row->tahapan_terakhir_id;
					$data['tahapanText'] = $row->tahapan_terakhir_text;
					$data['pihak1'] = $row->pihak1_text;
					$data['pihak2'] = $row->pihak2_text;
					$data['tglPendaftaran'] = $row->tanggal_pendaftaran;
					$data['statuTerakhir'] = $row->proses_terakhir_text;
					$data['tglPutusan'] = $row->tanggal_putusan;
					$data['jenisPerkara'] = $row->jenis_perkara_nama;
					$data['idjenisperkara'] = $row->jenis_perkara_id;
					$data['isPublish'] = ($row->pihak_dipublikasikan=='Y')? 'Ya':'Tidak';
					$data['petitum'] = $row->petitum;
					$data['nilai_sengketa'] = number_format($row->nilai_sengketa,2,",",".");
					$data['petitum_dok'] = $row->petitum_dok;
					$data['dakwaan'] = $row->dakwaan;
					$data['dakwaan_dok'] = $row->dakwaan_dok;
					$data['prodeo'] = ($row->pihak_dipublikasikan=='1')? 'Ya':'Tidak';
					$data['ada_data_penuntutan'] = !empty($row->tanggal_penuntutan)?1:0;
					$data['ada_data_putusan_sela'] = !empty($row->tanggal_putusan_sela)?1:0;
					$data['sudah_putusan'] = 0;
					$data['ada_data_umum']=0;
					if(!empty($row->tanggal_putusan) && $row->amar_putusan!=''){
						$data['sudah_putusan']=1;
					}
					if (!empty($row->pihak1_text) && !empty($row->pihak2_text)){
						if (!empty($row->dakwaan)){
							$data['ada_data_umum']=1;
						}
					}
					$jenis_pengadilan = $this->session->userdata('jenis_pengadilan');
					if($jenis_pengadilan==2){
						$data['matra'] = $row->matra;
						$data['BerkasDari'] = $row->berkas_dari;
						$data['tglKejadian'] = $row->tanggal_kejadian;
						$data['tempatKejadian'] = $row->tempat_kejadian;
						$data['tanggal_skeppera'] = $row->tanggal_skeppera;
						$data['noSkeppera'] = $row->nomor_skeppera;
						$data['tglSuratDakwaan'] = $row->tanggal_surat_dakwaan;
						$data['noSuratDakwaan'] = $row->nomor_surat_dakwaan;
						$data['pasal_dakwaan'] = $row->pasal_dakwaan;
						$data['pejabatSkeppera']= $row->pejabat_skeppera;
						$data['penyidik_mil'] =$row->penyidik_mil;
						$data['no_bap_penyidik_mil'] =$row->no_bap_penyidik_mil;
						$data['tgl_penyidik_mil'] =$row->tgl_penyidik_mil;
					}
					if ($row->tanggal_bht!=''){
						$data['tgl_bht']=$this->tanggalhelper->convertDayDate($row->tanggal_bht);
						$data['isbht']="1";
					}else{
						if ($this->authorization->HasRuleAddBHT()){
							$data['tgl_bht']='Tambah';
						}else{
							$data['tgl_bht']='Belum BHT';
						}
					}
				}
			}
		}
		return $data;
	}

	function manage_bht($enc){
		if($this->session->userdata('is_logged_in')===FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Anda Belum Login, Silahkan Login Terlebih Dahulu.'));
			return;
		}
		$data['enc']=$enc;
		$data['perkara_id']=$this->encrypt->decode(base64_decode($enc));
		$this->load->model('perkara/info_perkara','perkara');		
		$result = $this->perkara->getInfoPerkara($data['perkara_id'])->result();
		$tgl_bht=($result[0]->tanggal_bht);
		if ($tgl_bht!=''){
			$data['act']='edit';
			$data['tgl_bht']=$tgl_bht;
		}else{
			$data['act']='add';
			$data['tgl_bht']='';
		}
		$this->load->view('perkara/edit_bht', $data);
	}

	function validation_tgl_bht($act){
		if($this->session->userdata('is_logged_in')===FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Anda Belum Login, Silahkan Login Terlebih Dahulu.'));
			return;
		}
		$this->form_validation->set_rules('tgl_bht', 'Tanggal BHT', 'trim|required|xss_clean');
		if ($this->form_validation->run() === FALSE){
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Berhasil'.validation_errors()));
			return;
		}else{
			//echo $act;
			$enc=$this->input->post('enc',true);
			$tgl_bht=$this->tanggalhelper->convertToMysqlDate(trim($this->input->post('tgl_bht',true)));
			if($tgl_bht==false){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Format Tanggal Tidak Benar. Format tanggal hari/bulan/tahun. Contoh 20/01/2015.'));
				return;
			}
			$perkara_id=$this->encrypt->decode(base64_decode($enc));
			$this->load->model('perkara/info_perkara','perkara');
			$resultbanding = $this->perkara->resultbanding($perkara_id);
			$resultkasasi = $this->perkara->resultkasasi($perkara_id);
			if(!empty($resultbanding)){
				if($resultbanding->num_rows>0){
					foreach ($resultbanding->result() as $row) {
						$tglpermohonan = $row->permohonan_banding;
						$tglPemberitahuanPembanding = $row->pemberitahuan_putusan_banding;
						$tglCabutBanding = $row->tanggal_cabut;
					}
				}				
			}
			if(!empty($resultkasasi)){
				if($resultkasasi->num_rows>0){
					foreach ($resultkasasi->result() as $row) {
						$tglpermohonankasasi = $row->permohonan_kasasi;
						$tglPemberitahuanKasasi = $row->pemberitahuan_putusan_kasasi;
						$tglCabutKasasi = $row->tanggal_cabut;
						$tglTMSKasasi = $row->tidak_memenuhi_syarat;
					}
				}				
			}		
			
			$tgl_putusan = $this->tanggalhelper->getTanggalPutusan($perkara_id);			
			$selisih = $this->tanggalhelper->getSelisihHari($tgl_putusan,$tgl_bht);
			if($selisih<0){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal BHT Tidak Boleh Kurang dari Tanggal Putusan. '));
				return;
			}

			if(!empty($tglpermohonan) AND (($tglPemberitahuanPembanding=='') AND ($tglCabutBanding==''))){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Bisa di BHT, Perkara Masih Dalam Upaya Hukum Banding'));
				return;
			}
			if(!empty($tglpermohonankasasi) AND (empty($tglPemberitahuanKasasi) AND empty($tglCabutKasasi) AND empty($tglTMSKasasi))){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Bisa di BHT, Perkara Masih Dalam Upaya Hukum Kasasi'));
				return;
			}
			if($this->perkara->update_bht($tgl_bht,$perkara_id)){
				echo json_encode(array('st'=>1,'msg'=>'Data Berhasil Disimpan'));
			}else{
				echo json_encode(array('st'=>0,'msg'=>'ERROR SIMPAN KE DATABASE'));
			}
		}
	}

	function hapus_bht(){
		if($this->session->userdata('is_logged_in')===FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Anda Belum Login, Silahkan Login Terlebih Dahulu.'));
			return;
		}		
		$idperkara = $this->encrypt->decode(base64_decode($this->input->post('enc')));
		if(!is_numeric($idperkara) OR !intval($idperkara)>0){
			echo json_encode(array('st'=>0,'msg'=>'Perkara Tidak Ditemukan.'));
			return;
		}
		$tglBht = $this->input->post('tgl_bht');
		if(!empty($tglBht)){
		//	$tglBht=NULL;		
			$this->load->model('perkara/info_perkara','perkara');
			if($this->perkara->hapus_bht($idperkara))	{				
				echo json_encode(array('st'=>1,'msg'=>'Penghapusan Tanggal BHT Berhasil'));
				return;
			}else{
				echo json_encode(array('st'=>0,'msg'=>'Error:<br /> Tidak Berhasil'));
				return;
			}
		}
	}
}
/* End of file detil_perkara_mil.php */
/* Location: ./application/controllers/detil_perkara_mil.php */