<?php 
if (!defined('BASEPATH')) exit('No direct script access allowed');
class m_template_penetapan extends CI_Model {
	function getDataPenetapanSidang($idperkara){
		try{
			if(!is_numeric($idperkara)){ return '';	}
			$sql = "SELECT a.penetapan_hari_sidang, a.sidang_pertama, b.tanggal_sidang,  b.jam_sidang
					FROM perkara_penetapan AS a, perkara_jadwal_sidang AS b
					WHERE a.perkara_id=b.perkara_id AND b.urutan=1 AND a.perkara_id=$idperkara";
			$query=$this->db->query($sql);
			return $query;
		}catch(Exception $e){ return false; }
	}

	function getDataPenetapanPanitera($idperkara){
		try{
			if(!is_numeric($idperkara)) { return ''; }
			$sql = "SELECT * FROM 
						(SELECT perkara_id, panitera_id, tanggal_penetapan 
							FROM perkara_panitera_pn 
							WHERE perkara_id = $idperkara AND aktif='Y'
							GROUP BY panitera_id) AS ph
					LEFT JOIN
						(SELECT id, nama_gelar FROM panitera_pn) AS h
					ON ph.panitera_id = h.id";
			$query=$this->db->query($sql);
			return $query;
		}catch(Exception $e) { return false; }
	}

	function getRefJenisTahanan(){
		try{
			$sql = "SELECT * 
					FROM jenis_tahanan";
			$query=$this->db->query($sql);
			return $query;
		}catch(Exception $e) { return false; }
	}

	function getDataPerkara($idperkara){
		try{
			if(!is_numeric($idperkara)) { return ''; }
			$sql = "SELECT nomor_perkara,nomor_surat,tanggal_surat, tanggal_pendaftaran, dakwaan 
					FROM perkara 
					WHERE perkara_id =$idperkara";
			$query=$this->db->query($sql);
			return $query;	
		}catch(Exception $e) { return false; }
	}

	function getJenisPerkara($idperkara){
		try{
			if(!is_numeric($idperkara)) { return ''; }
			$sql = "SELECT nama 
					FROM jenis_perkara 
					WHERE id=(SELECT jenis_perkara_id 
								FROM perkara 
								WHERE perkara_id=$idperkara)";
			$query=$this->db->query($sql);
			return $query;	
		}catch(Exception $e) { return false; }
	}

	function getDataPN(){
		try{
			$sql = "SELECT * FROM 
					(SELECT value AS NamaPN FROM sys_config WHERE id = 62) AS T1,
					(SELECT value AS KetuaPNNama FROM sys_config WHERE id = 64) AS T2,
					(SELECT value AS AlamatPN FROM sys_config WHERE id = 63) AS T3,
					(SELECT value AS WakilKetuaPNNama FROM sys_config WHERE id = 66) AS T4,
					(SELECT value AS PansekPNNama FROM sys_config WHERE id = 68) AS T5,
					(SELECT value AS WaPanNama FROM sys_config WHERE id = 70) AS T6, 
					(SELECT value AS ZonaWaktu FROM sys_config WHERE id = 75) AS T7";
			$query=$this->db->query($sql);
			return $query;	
		}catch(Exception $e) { return false; }
	}

	function getDataPihak($pihak_id){
		try{
			if(!is_numeric($pihak_id)) { return ''; }
			$sql = "SELECT * 
					FROM pihak 
					WHERE id=$pihak_id";
			$query=$this->db->query($sql);
			return $query;	
		}catch(Exception $e) { return false; }
	}

	function getDataPanitera($idperkara){
		try{
			if(!is_numeric($idperkara)) { return ''; }
			$sql = "SELECT DISTINCT perkara_id,urutan,panitera_id,panitera_nama,tanggal_penetapan 
					FROM perkara_panitera_pn 
					WHERE perkara_id=$idperkara";
			$query=$this->db->query($sql);
			return $query;	
		}catch(Exception $e) { return false; }
	}

	function getDataTerdakwa($idperkara){
		try{
			if(!is_numeric($idperkara)) { return ''; }
			 $sql="SELECT 		a.*
								,b.tempat_lahir
								,b.tanggal_lahir
								,b.jenis_kelamin
								,d.nama AS warga_negara
								,c.nama AS agama_nama
								,b.pekerjaan
							FROM perkara_pihak2 AS a
							LEFT JOIN pihak AS b
							ON b.id=a.pihak_id
							LEFT JOIN agama AS c
							ON c.id=b.agama_id
							LEFT JOIN negara AS d
							ON d.id=b.warga_negara_id
							
							WHERE a.perkara_id=$idperkara
							ORDER BY a.urutan";
			$query=$this->db->query($sql);
			return $query;	
		}catch(Exception $e) { return false; }
	}

	function getDataPihakTerdakwa1($idperkara, $idpihak){
		try{
			if(!is_numeric($idperkara) OR !is_numeric($idpihak)) { return ''; }
			$sql = "SELECT 	a.pihak_id, a.urutan, 
						b.nama, b.alamat, b.tempat_lahir, b.tanggal_lahir, b.jenis_kelamin, a.pangkat, a.nrp, a.jabatan, a.kesatuan,
						c.`nama` AS agama_nama, d.`nama` AS warga_negara, b.pekerjaan 
					FROM 		perkara_pihak2 a
					LEFT JOIN pihak AS b ON a.pihak_id=b.id
					LEFT JOIN agama AS c ON  b.`agama_id`=c.`id`
					LEFT JOIN negara AS d ON b.`warga_negara_id`=d.`id`
					WHERE a.perkara_id = $idperkara AND a.pihak_id=$idpihak
					ORDER BY urutan ASC";
			$query=$this->db->query($sql);
			return $query;	
		}catch(Exception $e) { return false; }
	}

	function getDataPenahananTerdakwa($idperkara,$idpihak){
		try{
			if(!is_numeric($idperkara)) { return ''; }
			$sql = "SELECT 	pihak_id,
							jp.id AS idjns_penahanan,
							jp.nama AS oleh, 
							sp.nama AS status_penahanan, 
							jt.nama AS jenis_tahanan,
							pt.mulai AS sejak, 
							pt.sampai, 
							pt.lama_penahanan,
							pt.tanggal_surat as tglPenetapan,
							pt.id ,
							pt.tanggal_surat, pt.nomor_surat 
					FROM (SELECT * FROM penahanan_terdakwa WHERE perkara_id = $idperkara AND pihak_id = $idpihak ORDER BY jenis_penahanan_id, mulai ASC) pt 
					LEFT JOIN jenis_penahanan jp ON pt.jenis_penahanan_id=jp.id
					LEFT JOIN status_penahanan sp ON pt.status_penahanan_id=sp.id
					LEFT JOIN jenis_tahanan jt ON pt.jenis_tahanan_id=jt.id
					ORDER BY jp.id" ;
			$query=$this->db->query($sql);
			return $query;	
		}catch(Exception $e) { return false; }
	}

	function get_data_penahanan($idperkara,$idpihak,$tglMulai){
		try{
			if(!is_numeric($idperkara)) { return ''; }
			$sql = "SELECT 	pihak_id,
							jp.id AS idjns_penahanan,
							jp.nama AS oleh, 
							sp.nama AS status_penahanan, 
							jt.nama AS jenis_tahanan,
							pt.mulai AS sejak, 
							pt.sampai, 
							pt.lama_penahanan,
							pt.tanggal_surat as tglPenetapan,
							pt.id ,
							pt.tanggal_surat, pt.nomor_surat 
					FROM (SELECT * FROM penahanan_terdakwa WHERE perkara_id = $idperkara AND pihak_id = $idpihak ORDER BY jenis_penahanan_id, mulai ASC) pt 
					LEFT JOIN jenis_penahanan jp ON pt.jenis_penahanan_id=jp.id
					LEFT JOIN status_penahanan sp ON pt.status_penahanan_id=sp.id
					LEFT JOIN jenis_tahanan jt ON pt.jenis_tahanan_id=jt.id 
					WHERE pt.id IN (SELECT id FROM penahanan_terdakwa WHERE perkara_id = $idperkara AND mulai < '$tglMulai')
					ORDER BY jp.id" ;
			$query=$this->db->query($sql);
			return $query;	
		}catch(Exception $e) { return false; }
	}
	
	function getDataPenahanan($idpenahanan){
		try{
		$sql= "SELECT 	A.id,
						A.perkara_id,
						A.pihak_id,
						B.nama AS jenis_penahanan,
						C.nama AS status_penahanan,
						D.nama AS jenis_tahanan,
						A.tanggal_surat,
						A.nomor_surat,
						A.mulai,
						A.sampai,
						A.waktu_penahanan,
						A.lama_penahanan,
						A.rutan_id,
						E.nama
				FROM penahanan_terdakwa A 
				LEFT JOIN jenis_penahanan B ON A.jenis_penahanan_id=B.id 
				LEFT JOIN status_penahanan C ON A.status_penahanan_id=C.id
				LEFT JOIN jenis_tahanan D ON A.jenis_tahanan_id=D.id
				LEFT JOIN lembaga_pemasyarakatan AS E ON A.rutan_id = E.id
				WHERE A.id=$idpenahanan ";				
			$query=$this->db->query($sql);
			return $query;	
		}catch(Exception $e) { return false; }
	}

	function getDataHakim($idperkara){
		try{
			if(!is_numeric($idperkara)) { return ''; }
			$sql = "SELECT * 
					FROM (SELECT perkara_id,urutan,jabatan_hakim_id, jabatan_hakim_nama, hakim_id, tanggal_penetapan 
							FROM perkara_hakim_pn 
							WHERE perkara_id = $idperkara AND aktif='Y'
							GROUP BY hakim_id) AS ph
					LEFT JOIN (SELECT id, nama_gelar FROM hakim_pn) AS h
					ON ph.hakim_id = h.id
					ORDER BY jabatan_hakim_id ASC";		
			$query=$this->db->query($sql);
			return $query;	
		}catch(Exception $e) { return false;	}
	}

	function getDataPenetapanHakim($idperkara){
		try{
			if(!is_numeric($idperkara)) { return ''; }
			$sql = "SELECT * 
					FROM (SELECT perkara_id,urutan,jabatan_hakim_id, jabatan_hakim_nama, hakim_nama, hakim_id,tanggal_penetapan,aktif
							FROM perkara_hakim_pn 
							WHERE perkara_id = $idperkara AND aktif='Y'
							GROUP BY hakim_id) AS ph
					LEFT JOIN (SELECT id, nama_gelar FROM hakim_pn) AS h
					ON ph.hakim_id = h.id
					ORDER BY urutan ASC";
			$query=$this->db->query($sql);
			return $query;	
		}catch(Exception $e) { return false; }
	}

	function getPenahananBefore($idperkara){
		try{
			if(!is_numeric($idperkara)) { return ''; }
			$sql = "SELECT * FROM penahanan_terdakwa WHERE id = ";
			$query=$this->db->query($sql);
			return $query;	
		}catch(Exception $e) { return false; }
	}

	function getKejaksaan($idperkara){
		try{
			if(!is_numeric($idperkara)) { return ''; }
			$sql = "SELECT b.kejaksaan AS kejaksaan  FROM 
					perkara_pihak1 AS a
					LEFT JOIN  pihak_jaksa AS b ON a.pihak_id=b.pihak_id
					WHERE a.perkara_id='".$idperkara."' ";
			$query=$this->db->query($sql);
			return $query;	
		}catch(Exception $e) { return false; }
	}
}
?>