<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class ManagePutusanSela extends CI_Controller {
	function index(){
		if($this->nativesession->get_flash_session('security')===FALSE){
			redirect('main');
		}
		$sec = $this->nativesession->get_flash_session('security');
		$this->nativesession->get_flash_session('url_requested');
		if($this->session->userdata('is_logged_in')===FALSE){
			redirect('login');
		}
		
		$idperkara=$this->encrypt->decode(base64_decode($this->nativesession->get_flash_session('enc',TRUE)));
		if(!is_numeric($idperkara)){
			show_404();
		}
		
		$act = $this->nativesession->get_flash_session('action');
		if($act=='add'){
			$this->add($idperkara,$act);
		} elseif ($act=='edit'){
			$idputsela=$this->encrypt->decode(base64_decode($this->nativesession->get_flash_session('encputsela',TRUE)));
			if(!is_numeric($idputsela)){
				show_404();
			}
			$this->edit($idperkara,$idputsela,$act);
		} else{
			$this->show_data($idperkara);
		}	
	}

	function show_data($idperkara){
		$data['enc']=base64_encode($this->encrypt->encode($idperkara));
		$this->load->model('putusan/data_putusan','putusan');
		$data['putusan'] = $this->putusan->getDataPutusanSela($idperkara,"");
		$dataumum = $this->putusan->getDataUmum($idperkara);
		$data['tglpendaftaran']=$dataumum->row()->tanggal_pendaftaran;
		$data['idperkara'] =$idperkara;
		$data['alur_perkara_id']=$this->tanggalhelper->getIDAlurPerkara($data['idperkara']);
		$data['jenis_perkara_id']=$this->tanggalhelper->getIDJenisPerkara($data['idperkara']);
		$this->load->vars($data);
		$this->load->view('putusan/putusan_sela');
	}

	function add($idperkara,$action){
		$data['enc']=base64_encode($this->encrypt->encode($idperkara));
		$data['act'] = base64_encode($this->encrypt->encode($action));
		
		$this->load->model('putusan/data_putusan','putusan');
		
		$dataumum = $this->putusan->getDataUmum($idperkara);
		$data['tglpendaftaran']=$dataumum->row()->tanggal_pendaftaran;

		$putusan=$this->putusan->getDataPutusanSela($idperkara,$action);
		$data['jumdata']=count($putusan->result());
		if ($data['jumdata']>0){
			$putselasebelum=$this->putusan->getDataPutusanByUrutan($idperkara,$data['jumdata']);
			$data['tgl_putsela_sebelum']=$putselasebelum->row()->tanggal_putusan_sela;
		}
		$data['tglsidangpertama']=$this->putusan->getTanggalSidangPertama($idperkara);
		
		$data['title'] = 'Tambah Data Putusan Sela';
		$data['current_date'] = date('d/m/Y');
		$data['tglPutusanSela'] ='';
		$data['amar_sela'] ='';
		$data['E_doc'] ='';
		$data['isi'] =FALSE;
		$data['urutan']='';
		$data['pemberitahuanPenggugat'] ='';
		$data['pemberitahuanTergugat'] ='';
		$data['pemberitahuanIntervensi'] ='';
		
		$data['enc_a']=$this->tanggalhelper->getIDAlurPerkara($idperkara);
		$data['jenis_perkara_id']=$this->tanggalhelper->getIDJenisPerkara($idperkara);
		$this->load->library('ckeditor');
		$this->ckeditor->basePath = base_url().'resources/ckeditor/';
		$this->ckeditor->config['toolbar'] = array(
			array('-','Cut','Copy','Paste','PasteText','PasteFromWord',
				'-','Bold', 'Italic', 'Underline','Subscript', 'Superscript',
					'-', 'RemoveFormat','-', 'Blockquote',
					'-', 'JustifyLeft', 'JustifyCenter', 'JustifyRight', 'JustifyBlock',
					'-','Undo','Redo','-','NumberedList','BulletedList','/',
					'-','Image'),
			array('-','Format', 'Font', 'FontSize',
				'-','TextColor', 'BGColor','Table',
				'-','Find', 'Replace', '-', 'SelectAll', '-', 'Scayt','-','HorizontalRule',
				'-','Print','Preview'
				));
		$this->ckeditor->config['pasteFromWordNumberedHeadingToList'] = 'true';
		$this->ckeditor->config['pasteFromWordPromptCleanup'] = 'true';
		$this->ckeditor->config['resize'] = 'false';
		$this->ckeditor->config['language'] = 'en';
		$this->ckeditor->config['width'] = '800px';
		$this->ckeditor->config['height'] = '180px';
		
		$this->load->vars($data);
		$this->load->view('putusan/edit_putusan_sela');
	}

	function edit($idperkara,$idputsela,$action){
		$data['act'] = base64_encode($this->encrypt->encode($action));
		$data['enc']=base64_encode($this->encrypt->encode($idperkara));

		$this->load->model('putusan/data_putusan','putusan');
		
		$dataumum = $this->putusan->getDataUmum($idperkara);
		$data['tglpendaftaran']=$dataumum->row()->tanggal_pendaftaran;

		$putusan=$this->putusan->getDataPutusanSela($idputsela,$action);
		$data['jumdata']=count($putusan->result());

		$data['tglsidangpertama']=$this->putusan->getTanggalSidangPertama($idperkara);
		
		$data['prosesid']=$this->putusan->getProsesId($idperkara);
		
		$data['title'] = 'Edit Data Putusan Sela';
		$data['current_date'] = date('d/m/Y');
		
		if($putusan !=''){
			if($putusan->num_rows>0){
				foreach ($putusan->result() as $row) {
					$data['encputsela']=base64_encode($this->encrypt->encode($row->putusansela_id));
					$data['tglPutusanSela'] = $this->tanggalhelper->convertToInputDate($row->tanggal_putusan_sela);
					$data['amar_sela'] = $row->amar_sela;
					$data['namadokumen'] = $row->amar_sela_dok;
					$data['pemberitahuanPenggugat'] = $this->tanggalhelper->convertToInputDate($row->pemberitahuan_putusan_sela_pihak1);
					$data['pemberitahuanTergugat'] = $this->tanggalhelper->convertToInputDate($row->pemberitahuan_putusan_sela_pihak2);
					$data['pemberitahuanIntervensi'] = $this->tanggalhelper->convertToInputDate($row->pemberitahuan_putusan_sela_pihak3);
					$data['pemberitahuanTuruttergugat'] = $this->tanggalhelper->convertToInputDate($row->pemberitahuan_putusan_sela_pihak4);
					$data['urutan']=$row->urutan;
					$data['isi'] =TRUE;
					$putselasebelum=$this->putusan->getDataPutusanByUrutan($idperkara,($data['urutan'])-1);
					if (count($putselasebelum->result())>0){
					$data['tgl_putsela_sebelum']=$putselasebelum->row()->tanggal_putusan_sela;
					}
				}
			}
		}
		
		$data['enc_a']=$this->tanggalhelper->getIDAlurPerkara($idperkara);
		$this->load->library('ckeditor');
		$this->ckeditor->basePath = base_url().'resources/ckeditor/';
		$this->ckeditor->config['toolbar'] = array(
			array('-','Cut','Copy','Paste','PasteText','PasteFromWord',
				'-','Bold', 'Italic', 'Underline','Subscript', 'Superscript',
					'-', 'RemoveFormat','-', 'Blockquote',
					'-', 'JustifyLeft', 'JustifyCenter', 'JustifyRight', 'JustifyBlock',
					'-','Undo','Redo','-','NumberedList','BulletedList','/',
					'-','Image'),
			array('-','Format', 'Font', 'FontSize',
				'-','TextColor', 'BGColor','Table',
				'-','Find', 'Replace', '-', 'SelectAll', '-', 'Scayt','-','HorizontalRule',
				'-','Print','Preview'
				));
		$this->ckeditor->config['pasteFromWordNumberedHeadingToList'] = 'true';
		$this->ckeditor->config['pasteFromWordPromptCleanup'] = 'true';
		$this->ckeditor->config['resize'] = 'false';
		$this->ckeditor->config['language'] = 'en';
		$this->ckeditor->config['width'] = '800px';
		$this->ckeditor->config['height'] = '180px';
		
		$this->load->vars($data);
		$this->load->view('putusan/edit_putusan_sela');
	}

	function validateInput(){
		if(empty($_POST)){
			show_404();
		}

		if($this->session->userdata('is_logged_in')===FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Anda Belum Login, Silahkan Login Terlebih Dahulu.'));
			return;
		}

		$alur_perkara_id=$this->input->post('enc_alur',TRUE);
		$namapihak1=$this->nativesession->getStatusPihak(10,$alur_perkara_id,1);
		$namapihak2=$this->nativesession->getStatusPihak(10,$alur_perkara_id,2);
		$namapihak3=$this->nativesession->getStatusPihak(10,$alur_perkara_id,3);
		$namapihak4=$this->nativesession->getStatusPihak(10,$alur_perkara_id,4);
		$this->form_validation->set_rules('amar_text', 'Amar Putusan Sela', 'trim|required|xss_clean|min_length[50]');
		$this->form_validation->set_rules('tgl_sela', 'Tanggal Putusan Sela', 'trim|required|xss_clean|exact_length[10]');
		$this->form_validation->set_rules('tgl_pihak1', 'Tanggal Pemberitahuan Putusan Sela Kepada '.$namapihak1, 'trim|xss_clean|exact_length[10]');
		$this->form_validation->set_rules('tgl_pihak2', 'Tanggal Pemberitahuan Putusan Sela Kepada '.$namapihak2, 'trim|xss_clean|exact_length[10]');
		$this->form_validation->set_rules('tgl_pihak3', 'Tanggal Pemberitahuan Putusan Sela Kepada '.$namapihak3, 'trim|xss_clean|exact_length[10]');
		$this->form_validation->set_rules('tgl_pihak4', 'Tanggal Pemberitahuan Putusan Sela Kepada '.$namapihak4, 'trim|xss_clean|exact_length[10]');

		if ($this->form_validation->run() === FALSE){
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Berhasil'.validation_errors()));
			return;
		}else{
			$idperkara = $this->encrypt->decode(base64_decode($this->input->post('enc',TRUE)));
			$this->load->model('putusan/data_putusan','putusan');
			$date_sidang = $this->putusan->getTanggalSidangPertama($idperkara);
			$curr_date = date('Y-m-d');

			$tgl_sela = $this->tanggalhelper->convertToMysqlDate($this->input->post('tgl_sela',TRUE));
			
			$selisih = $this->tanggalhelper->getSelisihHari($curr_date,$tgl_sela);
			if($selisih>0){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Putusan Sela Tidak Boleh Lebih Dari Hari Ini.'));
				return;
			}

			$selisih = $this->tanggalhelper->getSelisihHari($date_sidang,$tgl_sela);
			if($selisih<0){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Putusan Sela Tidak Boleh Kurang dari Tanggal Sidang Pertama.'));
				return;
			}
			
			$amar = trim($this->input->post('amar_text',TRUE));
			$amar = str_replace("&nbsp;", " ", $amar);
			$data = array(
				'tanggal_putusan_sela' => $tgl_sela,
				'amar_sela' => $amar
			);

			$pihak1 = $this->input->post('tgl_pihak1',TRUE);
			if(!empty($pihak1)){
				$tgl_pihak1 = $this->tanggalhelper->convertToMysqlDate($this->input->post('tgl_pihak1',TRUE));
				$selisih = $this->tanggalhelper->getSelisihHari($date_sidang,$tgl_pihak1);
				if($selisih<0){
					echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Pemberitahuan Putusan Sela Kepada '.$namapihak1.' Tidak Boleh Kurang dari Tanggal Sidang Pertama.'));
					return;
				}
				
				$selisih = $this->tanggalhelper->getSelisihHari($tgl_sela,$tgl_pihak1);
				if($selisih<0){
					echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Pemberitahuan Putusan Sela Kepada '.$namapihak1.' Tidak Boleh Kurang dari Tanggal Putusan Sela.'));
					return;
				}
				$data['pemberitahuan_putusan_sela_pihak1'] = $tgl_pihak1;
			}

			$pihak2 = $this->input->post('tgl_pihak2',TRUE);
			if(!empty($pihak2)){
				$tgl_pihak2 = $this->tanggalhelper->convertToMysqlDate($this->input->post('tgl_pihak2',TRUE));
				$selisih = $this->tanggalhelper->getSelisihHari($date_sidang,$tgl_pihak2);
				if($selisih<0){
					echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Pemberitahuan Putusan Sela Kepada '.$namapihak2.' Tidak Boleh Kurang dari Tanggal Sidang Pertama.'));
					return;
				}
				
				$selisih = $this->tanggalhelper->getSelisihHari($tgl_sela,$tgl_pihak2);
				if($selisih<0){
					echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Pemberitahuan Putusan Sela Kepada '.$namapihak2.' Tidak Boleh Kurang dari Tanggal Putusan Sela.'));
					return;
				}
				$data['pemberitahuan_putusan_sela_pihak2'] = $tgl_pihak2;
			}
			$pihak3 = $this->input->post('tgl_pihak3',TRUE);
			if(!empty($pihak3)){
				$tgl_pihak3 = $this->tanggalhelper->convertToMysqlDate($this->input->post('tgl_pihak3',TRUE));
				$selisih = $this->tanggalhelper->getSelisihHari($date_sidang,$tgl_pihak3);
				if($selisih<0){
					echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Pemberitahuan Putusan Sela Kepada Pihak '.$namapihak3.' Tidak Boleh Kurang dari Tanggal Sidang Pertama.'));
					return;
				}
				
				$selisih = $this->tanggalhelper->getSelisihHari($tgl_sela,$tgl_pihak3);
				if($selisih<0){
					echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Pemberitahuan Putusan Sela Kepada Pihak '.$namapihak3.' Tidak Boleh Kurang dari Tanggal Sidang Pertama.'));
					return;
				}
				$data['pemberitahuan_putusan_sela_pihak3'] = $tgl_pihak3;
			}
			$pihak4 = $this->input->post('tgl_pihak4',TRUE);
			if(!empty($pihak4)){
				$tgl_pihak4 = $this->tanggalhelper->convertToMysqlDate($this->input->post('tgl_pihak4',TRUE));
				$selisih = $this->tanggalhelper->getSelisihHari($date_sidang,$tgl_pihak4);
				if($selisih<0){
					echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Pemberitahuan Putusan Sela Kepada Pihak '.$namapihak4.' Tidak Boleh Kurang dari Tanggal Sidang Pertama.'));
					return;
				}
				
				$selisih = $this->tanggalhelper->getSelisihHari($tgl_sela,$tgl_pihak4);
				if($selisih<0){
					echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Pemberitahuan Putusan Sela Kepada Pihak '.$namapihak4.' Tidak Boleh Kurang dari Tanggal Sidang Pertama.'));
					return;
				}
				$data['pemberitahuan_putusan_sela_pihak4'] = $tgl_pihak4;
			}

			$amar = trim($this->input->post('amar_text',TRUE));
			$amar = strip_tags($amar);
			$amar = htmlentities($amar, null, 'utf-8');
			$amar = str_replace("&nbsp;", " ", $amar);
			if(strlen($amar)<50){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Amar Putusan Sela Tidak Boleh kurang dari 50 Karakter'));
				return;
			}
			
			$act = $this->encrypt->decode(base64_decode($this->input->post('act',TRUE)));
			if($act=='add'){
				$data['perkara_id'] = $idperkara;
				$data['diinput_oleh'] = $this->session->userdata('username');
				$data['diinput_tanggal'] = date("Y-m-d h:i:s",time());
				
				$result = $this->putusan->add($data);
				if($result){
					echo json_encode(array('st'=>1,'msg'=>'Data Berhasil Disimpan'));
					return;
				}else{
					echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br/> Proses Simpan Gagal'));
					return;
				}
				
			}elseif($act=='edit'){
				$data['diinput_oleh'] = $this->session->userdata('username');
				$data['diinput_tanggal'] = date("Y-m-d h:i:s",time());
				$idputsela = $this->encrypt->decode(base64_decode($this->input->post('encputsela',TRUE)));
				
				$result = $this->putusan->update($data,$idputsela);
				if($result){
					echo json_encode(array('st'=>1,'msg'=>'Data Berhasil Disimpan'));
					return;
				}else{
					echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br/> Proses Simpan Gagal'));
					return;
				}
			}else{
				echo json_encode(array('st'=>0,'msg'=>'ERROR!! PLEASE REFRESH YOUR BROWSER'));
				return;
			}
		}
	}

	function validateDelete(){
		if(empty($_POST)){
			show_404();
		}

		if($this->session->userdata('is_logged_in')===FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Anda Belum Login, Silahkan Login Terlebih Dahulu.'));
			return;
		}
		$idperkara = $this->encrypt->decode(base64_decode($this->input->post('enc',TRUE)));
		if(!is_numeric($idperkara)){
			echo json_encode(array('st'=>0,'msg'=>'ERROR.<br> Perkara Tidak Diketahui.'));
			return;
		}
		$idputsela = $this->encrypt->decode(base64_decode($this->input->post('encputsela',TRUE)));
        if(!is_numeric($idputsela) OR !intval($idputsela)>0){
            show_404();
            exit();
        }
		
		$act = $this->encrypt->decode(base64_decode($this->input->post('act',TRUE)));
		if($act=='edit'){

			// ===== Script ini disesuaikan dengan yang ada di fileupload_c =====
			$this->load->model('fileupload/fileupload_m');
			$idkirim=$idputsela;
			$from="putsela";
			$namadokumen=$this->fileupload_m->get_nama_dok($idkirim,$from);

			//check file and directory to delete
			$arrdirectory=explode('/',$namadokumen);
			array_pop($arrdirectory);
			$direktori=implode("/",$arrdirectory);
			$arrparentdirectory=explode('/',$direktori);
			array_pop($arrparentdirectory);
			$parentdirektori=implode("/",$arrparentdirectory);
			
			//delete the file
			@unlink($namadokumen);
			//delete the directories if empty. if at least one file inside, this script is passed automaticaly
			@rmdir($direktori); 
			@rmdir($parentdirektori); 

			// ===================================================================
			
			$this->load->model('putusan/data_putusan','putusan');
			$delData = $this->putusan->del_data($idputsela);
			if($delData==TRUE){
				echo json_encode(array('st'=>1,'msg'=>'Penghapusan Data Putusan Sela Berhasil.'));
				return;
			}
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br>Penghapusan Data Putusan Sela Tidak Berhasil.'));
		}else{
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br> Terjadi Kesalahan Sistem.'));
			return;
		}
	}
}