<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class ManageDataUmum extends CI_Controller {
	function index(){
		if($this->nativesession->get_flash_session('security')==FALSE){
			redirect('main');
		}
		$sec = $this->nativesession->get_flash_session('security');
		if($this->session->userdata('is_logged_in')==FALSE){
			redirect('login');
		}

		$idperkara = $this->nativesession->get_flash_session('perkara_id');
		if(!is_numeric($idperkara)){
			show_404();
		}
		$this->show_data($idperkara);
	}

	
	function show_data($idperkara){
		$jenis_pengadilan = $this->session->userdata('jenis_pengadilan');

		if($jenis_pengadilan==4){
			$this->load->model('perkara/info_perkara_agama', 'perkara');
		}else{
			$this->load->model('perkara/info_perkara', 'perkara');
		}

		$data['current_date'] = date('d/m/Y');
		$data['noPerkara'] = "";
		$data['tglPendaftaran'] = "";
		$data['jenisPerkara'] = "";
		$data['tglSurat'] = "";
		$data['noSurat'] = "";
		$data['petitum'] = "";
		$data['nilai_sengketa'] = "";
		$data['publikasikan'] ="";
		$data['alur_perkara_id'] = "";
		
		if($jenis_pengadilan==2){
			$data['matra'] = "";
			$data['BerkasDari'] = "";
			$data['tglKejadian'] = "";
			$data['tempatKejadian'] = "";
			$data['tglSkeppera'] = "";
			$data['noSkeppera'] = "";
			$data['pejabatSkeppera'] = "";
			$data['tglSuratDakwaan'] = "";
			$data['noSuratDakwaan'] = "";
			$data['pasal_dakwaan'] = "";
			$data['penyidik_mil'] = "";
			$data['no_bap_penyidik_mil'] = "";
			$data['tgl_penyidik_mil'] = "";		
		}

		if($jenis_pengadilan==4){
			$data['tgl_nikah'] = "";
			$data['tgl_kutipan_akta_nikah'] = "";
			$data['no_kutipan_akta_nikah'] = "";
			$data['kua_tempat_nikah'] = "";
		}
				
		$result = $this->perkara->getInfoPerkara($idperkara);
		if($result!=''){
			if($result->num_rows()>0){
				foreach ($result->result() as $row) {
					$data['noPerkara'] = $row->nomor_perkara;
					$data['tglPendaftaran'] = $row->tanggal_pendaftaran;
					$data['jenisPerkara'] = $row->jenis_perkara_nama;
					$data['jenisPerkaraId'] = $row->jenis_perkara_id;
					$data['tglSurat'] = $row->tanggal_surat;
					$data['noSurat'] = $row->nomor_surat;
					$data['nilai_sengketa'] = $row->nilai_sengketa;
					if ($row->alur_perkara_id > 100) {
						$data['petitum'] = $row->dakwaan;
					} else {
						$data['petitum'] = $row->petitum;
					}
					$data['publikasikan'] = $row->pihak_dipublikasikan;
					$data['idalurperkara'] = $row->alur_perkara_id;

					if ($row->alur_perkara_id==114) {
						$queryTilang = $this->perkara->getInfoPerkaraTilang($idperkara);
						$data['ditilang_id'] = $queryTilang->row()->ditilang_id;
						$data['noSurat'] = $queryTilang->row()->nomor_tilang;
						$data['jenis_kendaraan_id'] = $queryTilang->row()->jenis_kendaraan_id;
						$data['nama_kendaraan'] = $queryTilang->row()->nama_kendaraan;
						$data['nomor_polisi'] = $queryTilang->row()->nomor_polisi;
						$data['bukti_tilang_id'] = $queryTilang->row()->bukti_tilang_id;
						$data['nama_bukti'] = $queryTilang->row()->nama_bukti;

						$data['kendaraan'] = $this->perkara->getJenisKendaraanTilang();
						$data['barangBukti'] = $this->perkara->getBarangBuktiTilang();

					}


					if($jenis_pengadilan==2){
						$data['matra'] = $row->matra;
						$data['BerkasDari'] = $row->berkas_dari;
						$data['tglKejadian'] = $row->tanggal_kejadian;
						$data['tempatKejadian'] = $row->tempat_kejadian;
						$data['tglSkeppera'] = $row->tanggal_skeppera;
						$data['noSkeppera'] = $row->nomor_skeppera;
						$data['pejabatSkeppera'] = $row->pejabat_skeppera;
						$data['tglSuratDakwaan'] = $row->tanggal_surat_dakwaan;
						$data['noSuratDakwaan'] = $row->nomor_surat_dakwaan;
						$data['pasal_dakwaan'] = $row->pasal_dakwaan;
						$data['matra'] = $row->matra;
						$data['penyidik_mil'] =$row->penyidik_mil;
						$data['no_bap_penyidik_mil'] =$row->no_bap_penyidik_mil;
						$data['tgl_penyidik_mil'] =$row->tgl_penyidik_mil;
					}

					if($jenis_pengadilan==4){
						$data['tgl_nikah'] = $row->tgl_nikah;
						$data['tgl_kutipan_akta_nikah'] = $row->tgl_kutipan_akta_nikah;
						$data['no_kutipan_akta_nikah'] = $row->no_kutipan_akta_nikah;
						$data['kua_tempat_nikah'] = $row->kua_tempat_nikah;
					}
				}
			}else{
				$this->error_page->show_error_msg('Error Found','Something the right happen. Perkara Not Found. Error Code = 188');
				exit();
			}
		}else{
			$this->error_page->show_error_msg('Error Found','Something the right happen. Perkara Not Found. Error Code = 188');
			exit();
		}

		$idalurperkara=$data['idalurperkara'];
		$jenis_perkara = $this->perkara->getKlasifikasiPerkara($idalurperkara);
		$data['jenis_perkara']['-1']='Pilih Klasifikasi Perkara';
		if($jenis_perkara !=''){
			if($jenis_perkara->num_rows>0){
				foreach ($jenis_perkara->result() as $row) {
					$data['jenis_perkara'][$row->id]=$row->nama;
				}
			}
		}
		$data['enc'] = $this->nativesession->get_flash_session('enc');
		#configurasi CKeditor, this editior has been costumize for SIPP need.
		$this->load->library('ckeditor');
		$this->ckeditor->basePath = base_url().'resources/ckeditor/';
		$this->ckeditor->config['toolbar'] = array(
			array('-','Cut','Copy','Paste','PasteText','PasteFromWord',
				'-','Bold', 'Italic', 'Underline','Subscript', 'Superscript',
					'-', 'RemoveFormat','-', 'Blockquote',
					'-', 'JustifyLeft', 'JustifyCenter', 'JustifyRight', 'JustifyBlock',
					'-','Undo','Redo','-','NumberedList','BulletedList','/',
					'-','Image'),
			array('-','Format', 'Font', 'FontSize',
				'-','TextColor', 'BGColor','Table',
				'-','Find', 'Replace', '-', 'SelectAll', '-', 'Scayt','-','HorizontalRule',
				'-','Print','Preview'
				));
		$this->ckeditor->config['pasteFromWordNumberedHeadingToList'] = 'true';
		$this->ckeditor->config['pasteFromWordPromptCleanup'] = 'true';
		$this->ckeditor->config['resize'] = 'false';
		$this->ckeditor->config['language'] = 'en';
		$this->ckeditor->config['width'] = '810px';
		$this->ckeditor->config['height'] = '250px';
		
		$this->load->vars($data);
		$this->load->view('perkara_tab/edit_data_umum');
	}

	function validateInput(){
		if(empty($_POST)){ show_404(); }
		if($this->session->userdata('is_logged_in')===FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Anda Belum Login, Silahkan Login Terlebih Dahulu.'));
			return;
		}

		$idperkara = $this->encrypt->decode(base64_decode($this->input->post('enc',TRUE)));
		$idalurperkara=$this->tanggalhelper->getIDAlurPerkara($idperkara);
		$idjenisperkara=$this->input->post('klasifikasi',TRUE);
		if($idalurperkara>100 AND $idalurperkara<=122){
			$this->form_validation->set_rules('tgl_surat', 'Tanggal Surat', 'trim|required|exact_length[10]|xss_clean');
			$this->form_validation->set_rules('no_surat', 'No Surat', 'trim|required|xss_clean');
			$pesan = "Dakwaan";
		}else{
			$this->form_validation->set_rules('tgl_surat', 'Tanggal Surat', 'trim|exact_length[10]|xss_clean');
			$this->form_validation->set_rules('no_surat', 'No Surat', 'trim|xss_clean');
			$pesan = "Petitum";
		}
		
		$this->form_validation->set_rules('klasifikasi', 'Klasifikasi Perkara', 'trim|required|numeric|greater_than[0]|xss_clean');

		if($idalurperkara==114){
			$this->form_validation->set_rules('petitum_text', 'Kolom '.$pesan, 'trim|required|xss_clean|min_length[5]');
		} else {
			$this->form_validation->set_rules('petitum_text', 'Kolom '.$pesan, 'trim|required|xss_clean|min_length[50]');
		}

		$jenis_pengadilan = $this->session->userdata('jenis_pengadilan');
		if($jenis_pengadilan==2){
			if ($idalurperkara==120){
				$this->form_validation->set_rules('berkas_dari', 'Berkas Dari', 'trim|required|xss_clean');
				$this->form_validation->set_rules('tgl_kejadian', 'Tanggal Kejadian', 'trim|required|xss_clean');
				$this->form_validation->set_rules('tempat_kejadian', 'Tempat Kejadian', 'trim|required|xss_clean');
				$this->form_validation->set_rules('tgl_skeppera', 'Tanggal Skeppera', 'trim|required|exact_length[10]|xss_clean');
				$this->form_validation->set_rules('no_skeppera', 'Nomor Skeppera', 'trim|required|xss_clean');
				$this->form_validation->set_rules('pejabat_skeppera', 'Pejabat Skeppera', 'trim|required|xss_clean');
				$this->form_validation->set_rules('no_surat_dakwaan', 'Nomor Surat Dakwaan', 'trim|required|xss_clean');
				$this->form_validation->set_rules('tgl_surat_dakwaan', 'Tanggal Surat Dakwaan', 'trim|required|exact_length[10]|xss_clean');
				$this->form_validation->set_rules('pasal_yang_didakwakan, Pasal Dakwaan', 'trim|required|xss_clean');
				$this->form_validation->set_rules('penyidik_mil', 'Penyidik Militer', 'trim|required|xss_clean');
				$this->form_validation->set_rules('no_bap_penyidik_mil', 'Nomor Berita Acara Penyidik Militer', 'trim|required|xss_clean');
				$this->form_validation->set_rules('tgl_penyidik_mil', 'Tanggal Penyidik Militer', 'trim|required|exact_length[10]|xss_clean');
			}
		}

		if($jenis_pengadilan==4 AND $idalurperkara==15 AND ($idjenisperkara==346 OR $idjenisperkara==347)){
			$this->form_validation->set_rules('tgl_nikah', 'Tanggal Menikah', 'trim|required|exact_length[10]|xss_clean');
			$this->form_validation->set_rules('tgl_kutipan_akta_nikah', 'Tanggal Kutipan Akta Nikah', 'trim|required|exact_length[10]|xss_clean');
			$this->form_validation->set_rules('no_kutipan_akta_nikah', 'No. Kutipan Akta Nikah', 'trim|required|max_length[100]|xss_clean');			
			$this->form_validation->set_rules('kua_tempat_nikah', 'KUA Tempat Menikah', 'trim|required|max_length[255]|xss_clean');
		}

		if ($this->form_validation->run() === FALSE){
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Berhasil'.validation_errors()));
			return;
		}else{
			
			$petitum = trim($this->input->post('petitum_text',TRUE));
			$petitum = str_replace("&nbsp;", " ", $petitum);
			
			if($idalurperkara==114){
				if(strlen($petitum)<5){
					echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> '.$pesan.' Harus Dilengkapi'));
					return;
				}
			}else{
				if(strlen($petitum)<50){
					echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> '.$pesan.' Tidak Boleh kurang dari 50 Karakter'));
					return;
				}
			}


			
			if(!is_numeric($idperkara) OR $idperkara<0){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Berhasil Perkara Tidak ditemukan. Code Error = 194.'));
				return;
			}else{
				// letakkan validasi tanggal input di sini

				$tglSurat = trim($this->input->post('tgl_surat',TRUE));
				//$tgl_kejadian=$this->tanggalhelper->convertToMysqlDate(trim($this->input->post('tgl_kejadian',TRUE)));
				$tgl_kejadian=trim($this->input->post('tgl_kejadian',TRUE));
				$tgl_skeppera=$this->tanggalhelper->convertToMysqlDate(trim($this->input->post('tgl_skeppera',TRUE)));
				$tgl_surat_dakwaan=$this->tanggalhelper->convertToMysqlDate(trim($this->input->post('tgl_surat_dakwaan',TRUE)));
				$tgl_penyidik_mil=$this->tanggalhelper->convertToMysqlDate(trim($this->input->post('tgl_penyidik_mil',TRUE)));
				$nomor_perkara = trim($this->input->post('nomor_perkara',TRUE));
				$idklasifikasi = $this->input->post('klasifikasi',TRUE);

				if($jenis_pengadilan==4 AND $idalurperkara==15 AND ($idjenisperkara==346 OR $idjenisperkara==347)){
					$tglNikah = $this->tanggalhelper->convertToMysqlDate(trim($this->input->post('tgl_nikah',TRUE)));
					$tglKutipanAktaNikah = $this->tanggalhelper->convertToMysqlDate(trim($this->input->post('tgl_kutipan_akta_nikah',TRUE)));
					$noKutipanAktaNikah = trim($this->input->post('no_kutipan_akta_nikah',TRUE));
					$kuaTempatNikah = trim($this->input->post('kua_tempat_nikah',TRUE));
				}

				if($jenis_pengadilan==4){
					$this->load->model('perkara/info_perkara_agama', 'dataumum');
				}else{
					$this->load->model('perkara/info_perkara', 'dataumum');
				}
				$jenisPerkara = $this->dataumum->getJenisPerkaraNama($idklasifikasi);
				if($jenisPerkara->num_rows>0){
					foreach ($jenisPerkara->result() as $row) {
						$kode = $row->kode;
						$jenisPerkaraNama = $row->nama;
						$jenisPerkaraText = $row->nama_lengkap;
					}
				}else{
					echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Please Refresh Your Browser'));
					return;
				}

				if(!empty($tglSurat)){
					if(strlen($tglSurat)!=10){
						echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Tidak Valid'));
						return;
					}
					$tglSurat = $this->tanggalhelper->convertToMysqlDate(trim($this->input->post('tgl_surat',TRUE)));
					if($tglSurat==false){
						echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Format Tanggal Tidak Benar. Format tanggal hari/bulan/tahun. Contoh 20/01/2015.'));
						return;
					}
					$tglPendaftaran = $this->tanggalhelper->getTanggalPendaftaran($idperkara);
					$selisih = $this->tanggalhelper->getSelisihHari($tglSurat,$tglPendaftaran);
					if($selisih<0){
						echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Surat Tidak Boleh Melebihi Tanggal Pendaftaran.'));
						return;
					}
					if($this->session->userdata('jenis_pengadilan')==2){
					/*$selisih = $this->tanggalhelper->getSelisihHari($tgl_kejadian,$tglSurat);
					if($selisih<=0){
						echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Kejadian Tidak Boleh Sama Atau Melebihi Tanggal Surat'));
						return;
					}*/
					$selisih = $this->tanggalhelper->getSelisihHari($tgl_skeppera,$tglSurat);
					if($selisih<=0){
						echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Skeppera Tidak Boleh Sama Atau Melebihi Tanggal Surat'));
						return;
					}
					/*
					$selisih = $this->tanggalhelper->getSelisihHari($tgl_penyidik_mil,$tglSurat);
					if($selisih<0){
						echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal BAP Penyidik Tidak Boleh Melebihi Tanggal Pendaftaran.'));
						return;
					}*/
					}
					$selisih = $this->tanggalhelper->getSelisihHari($tgl_surat_dakwaan,$tglSurat);
					if($selisih<=0){
						echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Surat Dakwaan Tidak Boleh Sama Atau Melebihi Tanggal Surat'));
						return;
					}

					
					if($this->session->userdata('jenis_pengadilan')==2){
					/*$selisih = $this->tanggalhelper->getSelisihHari($tgl_kejadian,$tglPendaftaran);
					if($selisih<0){
						echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Kejadian Tidak Boleh Melebihi Tanggal Pendaftaran.'));
						return;
					}*/
					$selisih = $this->tanggalhelper->getSelisihHari($tgl_skeppera,$tglPendaftaran);
					if($selisih<0){
						echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Skeppera Tidak Boleh Melebihi Tanggal Pendaftaran.'));
						return;
					}
					/*
					$selisih = $this->tanggalhelper->getSelisihHari($tgl_penyidik_mil,$tglPendaftaran);
					if($selisih<0){
						echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal  BAP Penyidik  Tidak Boleh Melebihi Tanggal Pendaftaran.'));
						return;
					}*/
					}
					$selisih = $this->tanggalhelper->getSelisihHari($tgl_surat_dakwaan,$tglPendaftaran);
					if($selisih<0){
						echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Surat Dakwaan Tidak Boleh Melebihi Tanggal Pendaftaran.'));
						return;
					}
				}

				if($this->session->userdata('jenis_pengadilan')==2){
					/*$selisih = $this->tanggalhelper->getSelisihHari($tgl_kejadian,$tgl_skeppera);
					if($selisih<=0){
						echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Skeppera Tidak Boleh Sama Atau Sebelum Dengan Tanggal Kejadian'));
						return;
					}*/
					
					/*$selisih = $this->tanggalhelper->getSelisihHari($tgl_kejadian,$tgl_surat_dakwaan);
					if($selisih<=0){
						echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Surat Dakwaan Tidak Boleh Sama Atau Sebelum Tanggal Kejadian'));
						return;
					}*/
					$selisih = $this->tanggalhelper->getSelisihHari($tgl_skeppera,$tgl_surat_dakwaan);
					if($selisih<=0){
						echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Surat Dakwaan Tidak Boleh Sama Atau Sebelum Tanggal Skeppera'));
						return;
					}
					/*$selisih = $this->tanggalhelper->getSelisihHari($tgl_penyidik_mil,$tgl_surat_dakwaan);
					if($selisih<=0){
						echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal BAP Penyidik Tidak Boleh Sama Atau Sebelum Tanggal Skeppera'));
						return;
					}*/
				}

				if($this->session->userdata('jenis_pengadilan')==4 AND $idalurperkara==15 AND ($idjenisperkara==346 OR $idjenisperkara==347)){
					if($tglNikah==FALSE){
						echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Format Tanggal Tidak Benar. Format tanggal hari/bulan/tahun. Contoh 20/01/2015.'));
						return;
					}
					if($tglKutipanAktaNikah==FALSE){
						echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Format Tanggal Tidak Benar. Format tanggal hari/bulan/tahun. Contoh 20/01/2015.'));
						return;
					}
					$selisih = $this->tanggalhelper->getSelisihHari($tglNikah,$tglKutipanAktaNikah);
					if($selisih<0){
						echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Kutipan Akta Nikah Tidak Boleh Mendahului Tanggal Menikah'));
						return;
					}
					if(strlen($noKutipanAktaNikah)<10){
						echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Nomor Kutipan Akta Nikah Minimal 10 Karakter'));
						return;
					}
					if(strlen($kuaTempatNikah)<15){
						echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> KUA Tempat Menikah Minimal 15 Karakter'));
						return;
					}
				}

				$publikasikan = trim($this->input->post('aktif',TRUE));
				$nilai_sengketa = trim($this->input->post('nilai_sengketa',TRUE));
				$nilai_sengketa = str_replace('.','',$nilai_sengketa);	


				if($idalurperkara==114){
					$data = array(
						'perkara_id' => $idperkara,
						'jenis_perkara_id' => $idklasifikasi,
						'jenis_perkara_kode' => $kode,
						'jenis_perkara_nama' => $jenisPerkaraNama,
						'jenis_perkara_text' => $jenisPerkaraText,	
						'nomor_perkara' => $nomor_perkara,
						'pihak_dipublikasikan' => $publikasikan,
						'diperbaharui_oleh' => $this->session->userdata('username'),
						'diperbaharui_tanggal' => date("Y-m-d h:i:s",time())
					);

				} else {
					$data = array(
						'perkara_id' => $idperkara,
						'jenis_perkara_id' => $idklasifikasi,
						'jenis_perkara_kode' => $kode,
						'jenis_perkara_nama' => $jenisPerkaraNama,
						'jenis_perkara_text' => $jenisPerkaraText,	
						'nomor_perkara' => $nomor_perkara,
						'pihak_dipublikasikan' => $publikasikan,
						'nomor_surat' => trim($this->input->post('no_surat',TRUE)),
						'diperbaharui_oleh' => $this->session->userdata('username'),
						'diperbaharui_tanggal' => date("Y-m-d h:i:s",time())
					);
				}


				if(!empty($tglSurat)){
					$data['tanggal_surat'] = $tglSurat;
				}				
				
				if($idalurperkara==8){
					if(!empty($nilai_sengketa)){						
						if($nilai_sengketa>200000000){
							echo json_encode(array('st'=>0,'msg'=>'Object Sengketa Melebihi Ketentuan Rp. 200.000.000,00;'));
							return;
						}
						$data['nilai_sengketa']=$nilai_sengketa;
					}
					
				}elseif($idalurperkara==1){
					$data['nilai_sengketa']=$nilai_sengketa;
				}			
				if($idalurperkara<100){
					$data['petitum'] = trim($this->input->post('petitum_text',TRUE));
				} else {
					$data['dakwaan'] = trim($this->input->post('petitum_text',TRUE));
				}

				/* Khusus Militer */
				if($jenis_pengadilan==2){
					$data['pasal_dakwaan'] = trim($this->input->post('pasal_yang_didakwakan',TRUE));
					$datamil = array(
						'perkara_id' => $idperkara,
						'berkas_dari' => trim($this->input->post('berkas_dari',TRUE)),
						'tanggal_kejadian' => $tgl_kejadian,
						'tempat_kejadian' => trim($this->input->post('tempat_kejadian',TRUE)),
						'tanggal_skeppera' => $tgl_skeppera,	
						'nomor_skeppera' => trim($this->input->post('no_skeppera',TRUE)),
						'pejabat_skeppera' => trim($this->input->post('pejabat_skeppera',TRUE)),
						'tanggal_surat_dakwaan' => $tgl_surat_dakwaan,	
						'nomor_surat_dakwaan' => trim($this->input->post('no_surat_dakwaan',TRUE)),		
						'penyidik_mil' => trim($this->input->post('penyidik_mil',TRUE)),
						'no_bap_penyidik_mil' => trim($this->input->post('no_bap_penyidik_mil',TRUE)),
						'tgl_penyidik_mil' => $tgl_penyidik_mil
					);
				}

				// Khusus Perkara Perceraian Peradilan Agama
				if($jenis_pengadilan==4 AND $idalurperkara==15 AND ($idjenisperkara==346 OR $idjenisperkara==347)){
					$datanikah = array(
						'perkara_id' => $idperkara,
						'tgl_nikah' => $tglNikah,
						'tgl_kutipan_akta_nikah' => $tglKutipanAktaNikah,
						'no_kutipan_akta_nikah' => $noKutipanAktaNikah,
						'kua_tempat_nikah' => $kuaTempatNikah
					);
					if($this->dataumum->check_ada_data_nikah($idperkara)){
						$datanikah['diperbaharui_oleh'] = $this->session->userdata('username');
						$datanikah['diperbaharui_tanggal'] = date("Y-m-d h:i:s",time());
					}else{
						$datanikah['diinput_oleh'] = $this->session->userdata('username');
						$datanikah['diinput_tanggal'] = date("Y-m-d h:i:s",time());
					}
				}
			

				$update = $this->dataumum->updt_data($idperkara,$data);
				if($update==TRUE){
					if($jenis_pengadilan==1 AND $idalurperkara==114){
						$this->form_validation->set_rules('jenis_kendaraan_id', 'Jenis Kendaraan', 'trim|required|xss_clean');
						$this->form_validation->set_rules('nomor_polisi', 'Tanda Nomor Kendaraan Bermotor', 'trim|required|xss_clean');
						$this->form_validation->set_rules('bukti_tilang_id', 'Bukti Tilang', 'trim|required|xss_clean');
						$this->form_validation->set_rules('ditilang_id', 'Ditilang Oleh', 'trim|required|xss_clean');
						$this->form_validation->set_rules('no_surat', 'Nomor Surat Tilang', 'trim|required|xss_clean');
						if ($this->form_validation->run() === FALSE){
							echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Berhasil'.validation_errors()));
							return;
						}else{
							$jenis_kendaraan_id=trim($this->input->post('jenis_kendaraan_id',TRUE));
							if($jenis_kendaraan_id=='-1'){
								echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan: Tentukan Jenis Kendaraan'));
								return;	
							}

							$nomor_polisi=trim($this->input->post('nomor_polisi',TRUE));
							$bukti_tilang_id=trim($this->input->post('bukti_tilang_id',TRUE));
							if($bukti_tilang_id=='-1'){
								echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan: Tentukan Bukti Tilang'));
								return;	
							}						

							$ditilang_id=trim($this->input->post('ditilang_id',TRUE));
							if($ditilang_id=='-1'){
								echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan: Tentukan ditilang oleh'));
								return;	
							}							
							$nomor_tilang=trim($this->input->post('no_surat',TRUE));


							$data = array(
								'ditilang_oleh' => $ditilang_id,
								'nomor_tilang' => $nomor_tilang,
								'jenis_kendaraan_id' => $jenis_kendaraan_id,
								'nomor_polisi' => $nomor_polisi,	
								'bukti_tilang_id' => $bukti_tilang_id,
								'diperbaharui_oleh' => $this->session->userdata('username'),
								'diperbaharui_tanggal' => date("Y-m-d h:i:s",time())
							);
							$this->dataumum->updt_data_tilang($idperkara,$data);
						}
					}

					if($jenis_pengadilan==2){
						$this->dataumum->update_mil($datamil);
					}
					if($jenis_pengadilan==4 AND $idalurperkara==15){
						if($idjenisperkara==346 OR $idjenisperkara==347){
							$this->dataumum->update_data_nikah($datanikah,$this->dataumum->check_ada_data_nikah($idperkara));
						}else{
							if($this->dataumum->check_ada_data_nikah($idperkara)){
								$this->dataumum->hapus_data_nikah($idperkara);
							}
						}
					}
					echo json_encode(array('st'=>1,'msg'=>'Data Berhasil Disimpan'));
				}else{
					echo json_encode(array('st'=>0,'msg'=>'ERROR SIMPAN KE DATABASE'));
				}
				return;
			}
		}
	}

	// function validatePost(){
		// if(empty($_POST)){
			// show_404();
		// }
		// $this->load->model('perkara/info_perkara');
		// $idperkara = $this->encrypt->decode(base64_decode($this->input->post('enc')));
		// if(empty($idperkara) OR intval($idperkara)<1){
			// echo json_encode(array('st'=>0,'msg'=>'Gagal Melakukan Upload! Data Tidak Valid.'));
			// return;
		// }

		// $idalurperkara = $this->tanggalhelper->getIDAlurPerkara($idperkara);
		// if($idalurperkara<100){
			// $nameDoc = 'petitum';
		// }else{
			// $nameDoc = 'dakwaan';
		// }

		// $datautama=$this->info_perkara->get_detil_data_utama($idperkara);
		// foreach ($datautama as $datautama){
			// $no_perkara=$datautama->nomor_perkara;
			// $tgldaftar=$datautama->tanggal_pendaftaran;
		// }
		// if($idalurperkara<100){
			// $namakolom='petitum_dok';
		// }else{
			// $namakolom='dakwaan_dok';
		// }
			
		// $namadokumen=$this->info_perkara->get_nama_dok($idperkara,$namakolom);
		// if (!empty($namadokumen)){
			// //check file and directory to delete
			// $splittgldaftar=explode("-",$tgldaftar);
			// $direktori="resources/file/doc/".$splittgldaftar[0]."/".$splittgldaftar[1];
			// $filenya=$direktori."/".$namadokumen;
			// //delete the file
			// @unlink($filenya);
		// }

		// //===== create file directory in not exist
		// $splittgldaftar=explode("-",$tgldaftar);
		// $direktori="resources/file/doc/".$splittgldaftar[0]."/".$splittgldaftar[1];
		// @mkdir($direktori,0777,true);

		// $splitnoperkara=explode("/",$no_perkara);
		// $namafile = $_FILES['edoc_petitum']['name'];
		// $extension=pathinfo($namafile);
		// $extension=$extension['extension'];

		// $fileName=$splitnoperkara[3]."_".$splitnoperkara[2]."_".$splitnoperkara[1]."_".$splitnoperkara[0]."_".$nameDoc.".".$extension;
		// $fileName=str_replace(' ','_',$fileName);
				
		// $fileTmpName = $_FILES['edoc_petitum']['tmp_name'];
		// $uploadpath=$direktori."/".$fileName;
		// if (move_uploaded_file($fileTmpName, $uploadpath)) {
			// if($idalurperkara<100){
				// $datainsert=array('petitum_dok'=>$fileName,);
			// }else{
				// $datainsert=array('dakwaan_dok'=>$fileName,);
			// }

			// $this->info_perkara->update_dataumum($idperkara,$datainsert);
	    	// echo json_encode(array('st'=>1,'msg'=>'File is valid, and was successfully uploaded.'));
			// return;
		// }else {
		    // echo json_encode(array('st'=>0,'msg'=>'Gagal Melakukan Upload!\n'));
			// return;
		// }
	// }

	function getFormat(){
		$idalurperkara = $this->encrypt->decode(base64_decode($this->input->post('enc',TRUE)));
		$idjenisperkara = $this->input->post('val',TRUE);
		$urutan = $this->encrypt->decode(base64_decode($this->input->post('urutan',TRUE)));
		if(empty($urutan) OR intval($urutan)<1){
			echo json_encode(array('st'=>0,'msg'=>'Data Invalid'));
			return;
		}
		$matra = trim($this->input->post('matra',TRUE));

		$date = $this->input->post('date',TRUE);
		if(is_numeric($idalurperkara) AND $idalurperkara>0){
			$this->load->model('perkara/new_perdata','perkara');

			if($idjenisperkara=='-1' AND $idalurperkara>0){
				$format = '#nomor_urut_perkara#/#kode_alur_perkara#/#tahun#/PN #kode_pn#';
			}else if($idalurperkara==7){
				$format = '#nomor_urut_perkara#/Pdt.Bth/#tahun#/PN #kode_pn#';
			}else if($idalurperkara==118){
				$format = '#nomor_urut_perkara#/Pid.Sus-Anak/#tahun#/PN #kode_pn#';
			}else if($idalurperkara==119){
				$format = '#nomor_urut_perkara#/Pid.Pra/#tahun#/PN #kode_pn#';
			}else{
				$format = $this->perkara->getFormatPerkara($idjenisperkara);
			}

			$kode = $this->perkara->getKodePerkara($idalurperkara);
			$kodePN1 = $this->perkara->getKodePN();
			
			$tmp = explode("/", $date);
			$tahun = $tmp[2];
			$bulan = $tmp[1];
			$tglNomor = $this->tanggalhelper->convertToMysqlDate($date);
			$selisih = $this->tanggalhelper->getSelisihHari($tglNomor,'2014-03-20');
			if($selisih>0 && $this->session->userdata('jenis_pengadilan')==1){
				if (file_exists(FCPATH."resources/ini/pnformat.ini")){
		            $iniArray = parse_ini_file(FCPATH."resources/ini/pnformat.ini");
		            $kodepn = $iniArray[$kodePN1];
		            $kode = strtoupper($kode);
		            $format = str_replace('PN ', 'PN.', $format);
	        	}
			}else{
				$kodepn = $kodePN1;
			}
			$format = $this->parseFormat($format,$urutan,$tahun,$kode,$kodepn,$matra,$this->convertToRomawi($bulan));
			$nourutregister= $this->perkara->getNomorUrutRegister($idalurperkara,$tahun.'-'.$bulan);
			echo json_encode(array('st'=>1,'msg'=>$format,'nourutregister'=>$nourutregister));
		}else{
			echo json_encode(array('st'=>0,'msg'=>"Error, Please refresh your Page",'nourutregister'=>"Error, Please refresh your Page"));
		}
	}

	function parseFormat($format,$urutan,$tahun,$kode,$kodePN,$matra='',$bulan=''){
		$format = str_replace("#nomor_urut_perkara#",$urutan,$format);
		$format = str_replace("#kode_alur_perkara#",$kode,$format);
		$format = str_replace("#tahun#",$tahun,$format);
		$format = str_replace("#kode_pn#",$kodePN,$format);
		$format = str_replace("#matra#",$matra,$format);
		$format = str_replace("#bulan#",$bulan,$format);
		return $format;
	}

	function convertToRomawi($bulan){
		switch ($bulan) {
			case '01':
				$bulan='I';
			break;
			case '02':
				$bulan='II';
			break;
			case '03':
				$bulan='III';
			break;
			case '04':
				$bulan='IV';
			break;
			case '05':
				$bulan='V';
			break;	
			case '06':
				$bulan='VI';
			break;		
			case '07':
				$bulan='VII';
			break;
			case '08':
				$bulan='VIII';
			break;
			case '09':
				$bulan='IX';
			break;	
			case '10':
				$bulan='X';
			break;
			case '11':
				$bulan='XI';
			break;
			case '12':
				$bulan='XII';
			break;
		}
		return $bulan;
	}

}