<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Add_pidana extends CI_Controller {
	function index(){
		#prevent direct access to page
		#the user should only access the page through menu
		if($this->nativesession->get_flash_session('security')==FALSE){
			redirect('main');
		}

		if($this->session->userdata('is_logged_in')==FALSE){
			redirect('login');
		}

		$idalurperkara = $this->nativesession->get_flash_session('alur_perkara_id');
		$idtahapan = $this->nativesession->get_flash_session('tahapan_id');
		$this->show_data($idalurperkara,$idtahapan);
	}

	function show_data($idalurperkara,$idtahapan){
		$this->load->model('perkara/new_pidana','perkara');
		$data['page_title'] = 'TAMBAH - DATA PERKARA '.strtoupper($this->perkara->getJenisPerkara($idalurperkara));
		$data['main_body'] = 'perkara/new_pidana';
		$data['previous'] = $this->nativesession->get_flash_session('url_requested');
		$data['idalurperkara'] = $idalurperkara;
		if (!$this->authorization->HasRuleAddPendaftaran($idalurperkara)){
			show_404();
		}
		$data['current_date'] = date('d/m/Y');
		if($idalurperkara==118){
			$format = '#nomor_urut_perkara#/Pid.Sus-Anak/#tahun#/PN #kode_pn#';
			$format_tmp = '/Pid.Sus-Anak/#tahun#/PN #kode_pn#';
		}else{
			$format = '#nomor_urut_perkara#/#kode_alur_perkara#/#tahun#/PN #kode_pn#';
			$format_tmp = '/#kode_alur_perkara#/#tahun#/PN #kode_pn#';
		}
		
		if($this->session->userdata('jenis_pengadilan')==2){
			$format = '#nomor_urut_perkara#-#kode_alur_perkara#/#kode_pn#/#matra#/#bulan#/#tahun#';
			$format_tmp = '-#kode_alur_perkara#/#kode_pn#/#matra#/#bulan#/#tahun#';
		}elseif($this->session->userdata('jenis_pengadilan')==4){
			$format = '#nomor_urut_perkara#/#kode_alur_perkara#/#tahun#/#kode_pn#';
			$format_tmp = '/#kode_alur_perkara#/#tahun#/#kode_pn#';
		}
		$urutan = $this->perkara->getNomorUrutPerkara($idalurperkara,date("Y"));
		$kode = $this->perkara->getKodePerkara($idalurperkara);
		$kodePN = $this->perkara->getKodePN();
		$data['no_perkara'] = $this->parseFormat($format,$urutan,date("Y"),$kode,$kodePN,'AD',$this->convertToRomawi(date("m")));
		$data['no_perkara_manual'] = $this->parseFormat($format_tmp,$urutan,date("Y"),$kode,$kodePN,'AD',$this->convertToRomawi(date("m")));
		$data['no_urutan_perkara'] = $urutan;
		$data['no_urut'] = $this->perkara->getNomorUrutRegister($idalurperkara,date("Y-m"));
		$data['jenis_perkara'] = $this->perkara->getKlasifikasiPerkara($idalurperkara);
		$data['enc'] = base64_encode($this->encrypt->encode($idalurperkara));
		$this->load->vars($data);
		$this->load->view('header');
		$this->load->view('body/body_new');
	}

	function convertToRomawi($bulan){
		switch ($bulan) {
			case '01':
				$bulan='I';
			break;
			case '02':
				$bulan='II';
			break;
			case '03':
				$bulan='III';
			break;
			case '04':
				$bulan='IV';
			break;
			case '05':
				$bulan='V';
			break;	
			case '06':
				$bulan='VI';
			break;		
			case '07':
				$bulan='VII';
			break;
			case '08':
				$bulan='VIII';
			break;
			case '09':
				$bulan='IX';
			break;	
			case '10':
				$bulan='X';
			break;
			case '11':
				$bulan='XI';
			break;
			case '12':
				$bulan='XII';
			break;
		}
		return $bulan;
	}
	function getFormat(){
		$idalurperkara = $this->encrypt->decode(base64_decode($this->input->post('enc',TRUE)));
		$idjenisperkara = $this->input->post('val',TRUE);
		$date = $this->input->post('date',TRUE);
		$matra = $this->input->post('matra',TRUE);
		if ($matra!=''){
			switch ($matra) {
				case '1':
					$matra='AD';
					break;
				case '2':
					$matra='AL';
					break;
				case '3':
					$matra='AU';
					break;
			}
		}

		if(is_numeric($idalurperkara) AND $idalurperkara>0){
			$this->load->model('perkara/new_pidana','perkara');
			if($idjenisperkara=='-1'){
				if($this->session->userdata('jenis_pengadilan')==2){
					$format = '#nomor_urut_perkara#-#kode_alur_perkara#/#kode_pn#/#matra#/#bulan#/#tahun#';
				}elseif($this->session->userdata('jenis_pengadilan')==4){
					$format = '#nomor_urut_perkara#/#kode_alur_perkara#/#tahun#/#kode_pn#';
				}else{
					$format = '#nomor_urut_perkara#/#kode_alur_perkara#/#tahun#/PN #kode_pn#';
				}
				if($idalurperkara==118){
					$format = '#nomor_urut_perkara#/Pid.Sus-Anak/#tahun#/PN #kode_pn#';
					$format_tmp = '/Pid.Sus-Anak/#tahun#/PN #kode_pn#';
				}
			}else{
				$format = $this->perkara->getFormatPerkara($idjenisperkara);
				if($idalurperkara==118){
					$format = '#nomor_urut_perkara#/Pid.Sus-Anak/#tahun#/PN #kode_pn#';
					$format_tmp = '/Pid.Sus-Anak/#tahun#/PN #kode_pn#';
				}
			}
			$kode = $this->perkara->getKodePerkara($idalurperkara);
			$kodePN1 = $this->perkara->getKodePN();
			
			#parse tahun
			$tmp = explode("/", $date);
			$tahun = $tmp[2];

			$bulan = $tmp[1];
			
			$urutan = $this->perkara->getNomorUrutPerkara($idalurperkara,$tahun);
			#nomor_urut_perkara#/#kode_alur_perkara#/#tahun#/PN.#kode_pn#
			$tglNomor = $this->tanggalhelper->convertToMysqlDate($date);
			$selisih = $this->tanggalhelper->getSelisihHari($tglNomor,'2014-03-20');
			if ($selisih>0 AND $jenis_pengadilan==1){
				if (file_exists(FCPATH."resources/ini/pnformat.ini")){
		            $iniArray = parse_ini_file(FCPATH."resources/ini/pnformat.ini");
		            $kodepn = $iniArray[$kodePN1];
		            $kode = strtoupper($kode);
		            $format = str_replace('PN ', 'PN.', $format);
	        	}
			}else{
				$kodepn = $kodePN1;
			}
			
			$formatmanual = $this->parseFormatManual($format,$urutan,$tahun,$kode,$kodepn,$matra,$this->convertToRomawi($bulan));
			$format = $this->parseFormat($format,$urutan,$tahun,$kode,$kodepn,$matra,$this->convertToRomawi($bulan));
			$nourutregister= $this->perkara->getNomorUrutRegister($idalurperkara,$tahun.'-'.$bulan);
			echo json_encode(array('st'=>1,'msg'=>$format,'manual'=>$formatmanual,'nourutregister'=>$nourutregister));
			return;
		}else{
			echo json_encode(array('st'=>0,'msg'=>"Error, Please refresh your Page",'nourutregister'=>"Error, Please refresh your Page"));
			return;
		}
	}

	function parseFormat($format,$urutan,$tahun,$kode,$kodePN,$matra='',$bulan=''){
		$format = str_replace("#nomor_urut_perkara#",$urutan,$format);
		$format = str_replace("#kode_alur_perkara#",$kode,$format);
		$format = str_replace("#tahun#",$tahun,$format);
		$format = str_replace("#kode_pn#",$kodePN,$format);
		$format = str_replace("#matra#",$matra,$format);
		$format = str_replace("#bulan#",$bulan,$format);
		return $format;
	}

	function parseFormatManual($format,$urutan,$tahun,$kode,$kodePN,$matra='',$bulan=''){
		$format = str_replace("#nomor_urut_perkara#",'',$format);
		$format = str_replace("#kode_alur_perkara#",$kode,$format);
		$format = str_replace("#tahun#",$tahun,$format);
		$format = str_replace("#kode_pn#",$kodePN,$format);
		$format = str_replace("#matra#",$matra,$format);
		$format = str_replace("#bulan#",$bulan,$format);
		return $format;
	}

	function validateNomorPerkara(){
		$idalurperkara = $this->encrypt->decode(base64_decode($this->input->post('enc',TRUE)));
		$date = $this->tanggalhelper->convertToMysqlDate($this->input->post('date',TRUE));
		$urutan = $this->input->post('urutan',TRUE);
		$no_manual = $this->input->post('no_manual',TRUE);
		$no_urut_register = $this->input->post('no_urut_register',TRUE);
		$this->load->model('perkara/new_pidana','perkara');
		$nomor_perkara = $urutan.$no_manual;

		if($this->perkara->cekNomorUrut($date, $no_urut_register)->num_rows()==0 && $this->perkara->cekNomorPerkara($nomor_perkara)->num_rows()==0){
			echo json_encode(array('st'=>1,'msg'=>'Valid'));
		}else{
			echo json_encode(array('st'=>0,'msg'=>'ERROR, Nomor Perkara Sudah Terdaftar Di dalam Sistem. Periksa Kembali Nomor Yang Anda Masukan.'));
		}
	}

	function validateInput(){
		if($this->session->userdata('is_logged_in')==FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Anda Belum Login, Silahkan Login Terlebih Dahulu.'));
			return;
		}
		if(empty($_POST)){
			show_404();
		}
		$klas_perkara = $this->input->post('klas_perkara',TRUE);
		
			$matra=$this->input->post('matra',TRUE);
		
		if($klas_perkara==-1){
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Anda Belum Memilih Klasifikasi Perkara'));
			return;
		}
		$this->form_validation->set_rules('tgl_pendaftaran', 'Tanggal Pendaftaran', 'trim|required|xss_clean|exact_length[10]');
		$this->form_validation->set_rules('klas_perkara', 'Klasifikasi Perkara', 'trim|required|numeric|greater_than[0]|xss_clean');
		$this->form_validation->set_rules('no_urut', 'Nomor Urut', 'trim|required|numeric|xss_clean');
		
		$this->form_validation->set_rules('generate', 'Generate Nomor Perkara', 'trim|required|numeric|xss_clean');
		$generate = $this->input->post('generate',TRUE);
		if($generate==1){
			$this->form_validation->set_rules('no_perkara_auto', 'Nomor Perkara', 'trim|required|xss_clean|is_unique[perkara.nomor_perkara]');
		}elseif ($generate==0) {
			$this->form_validation->set_rules('no_urutan_manual', 'Nomor Urut Register', 'trim|required|numeric|xss_clean');
			$this->form_validation->set_rules('no_perkara_manual', 'Nomor Perkara', 'trim|required|xss_clean');
		}else{
			show_404();
		}

		if ($this->form_validation->run() == FALSE){
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Berhasil'.validation_errors()));
		}else{

			$tanggal = $this->input->post('tgl_pendaftaran',TRUE);
			$curr_date = date('Y-m-d');
			$todayDate = date('d/m/Y');

			$tanggal = $this->tanggalhelper->convertToMysqlDate($tanggal);
			if($tanggal==false){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Format Tanggal Tidak Benar. Format tanggal hari/bulan/tahun. Contoh 20/01/2015.'));
				return;
			}
			$selisih = $this->tanggalhelper->getSelisihHari($tanggal,$curr_date);
			if($selisih<0){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Tidak Boleh Melebihi Hari ini. Hari ini Tanggal,'.$todayDate));
				return;
			}
			
			$noUrutReg = $this->input->post('no_urut',TRUE);
			$this->load->model('perkara/new_pidana','perkara');
			$idalurperkara = $this->encrypt->decode(base64_decode($this->input->post('enc',TRUE)));
			$isNoUrutRegisterExists = $this->perkara->isNomorUrutRegisterExists($tanggal,$idalurperkara,$noUrutReg);
			if($isNoUrutRegisterExists==TRUE OR $isNoUrutRegisterExists==-2){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Nomor Urut Register Sudah Ada'.$tanggal));
				return;
			}

			if($generate==1){
				$noPerkara = $this->input->post('no_perkara_auto',TRUE);
			}elseif ($generate==0) {
				$noPerkara =$this->input->post('no_urutan_manual',TRUE).$this->input->post('no_perkara_manual',TRUE);
			}

			$tmp = explode("/", $noPerkara);
			if ($matra==''){
				if(count($tmp)!=4){
					echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Please Refresh Your Browser'));
					return;
				}
				#PN.BDG_2013_PID.LL_0071
				$nomor_urut_perkara = $tmp[0];
				$tmpIndexs = $tmp[0];
				if($tmpIndexs<10){
					$tmpIndexs = '000'.$tmpIndexs;
				}elseif($tmpIndexs>9 and $tmpIndexs <1000){
					$tmpIndexs = '00'.$tmpIndexs;
				}
				$nomorIndexs = $tmp[3].'_'.$tmp[2].'_'.$tmp[1].'_'.$tmpIndexs;
			}else{
				if(count($tmp)!=5){
					echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Please Refresh Your Browser'));
					return;
				}
				#PN.BDG_2013_PID.LL_0071
				#1-K/PM.III-12/AD/X/2015
				$arr_nomor_urut_perkara = explode('-',$tmp[0]);
				$nomor_urut_perkara = $arr_nomor_urut_perkara[0];
				$tmpIndexs = $nomor_urut_perkara;
				if($tmpIndexs<10){
					$tmpIndexs = '000'.$tmpIndexs;
				}elseif($tmpIndexs>9 and $tmpIndexs <1000){
					$tmpIndexs = '00'.$tmpIndexs;
				}
				$bulan=explode('-',$tanggal);
				$nomorIndexs = $tmp[1].'_'.$tmp[4].'_'.$bulan[1].'_'.$arr_nomor_urut_perkara[1].'_'.$tmpIndexs;
			}
			$isPerkaraExists = $this->perkara->isNomorPerkaraExist($noPerkara);
			if($isPerkaraExists===TRUE){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Nomor Perkara Sudah Ada Didalam System'));
				return;
			}
			$no_ref = $this->input->post('no_ref',TRUE);
			
			#masukan ke db
			#
			$jenisPerkara = $this->perkara->getJenisPerkaraNama($klas_perkara);
			if($jenisPerkara->num_rows>0){
				foreach ($jenisPerkara->result() as $row) {
					$kode = $row->kode;
					$jenisPerkaraNama = $row->nama;
					$jenisPerkaraText = $row->nama_lengkap;
				}
			}else{
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Please Refresh Your Browser'));
				return;
			}
			$dayName = $this->tanggalhelper->getDayName($tanggal);
			if($dayName=="Sunday" OR $dayName=="Saturday"){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Dapat memilih diluar hari kerja (Sabtu - Minggu).'));
				return;
			}

			$tglPendaftaran = $tanggal;
			
			$data_perkara = array(
				'nomor_perkara' => $noPerkara,
				'alur_perkara_id' => $idalurperkara,
				'tanggal_pendaftaran' => $tglPendaftaran,
				'jenis_perkara_id' => $klas_perkara,
				'jenis_perkara_kode' => $kode,
				'jenis_perkara_nama' => $jenisPerkaraNama,
				'jenis_perkara_text' => $jenisPerkaraText,
				'nomor_urut_register' => $noUrutReg,
				'nomor_urut_perkara' => $nomor_urut_perkara,
				'nomor_indeks' => $nomorIndexs,
				'tahapan_terakhir_id' => 10,
				'tahapan_terakhir_text' => 'Pendaftaran',
				'proses_terakhir_id' => 10,
				'proses_terakhir_text' => 'Pendaftaran Perkara',
				'diinput_oleh' => $this->session->userdata('username'),
				'diinput_tanggal' => date("Y-m-d h:i:s",time())
			);
			
			if ($matra==''){
				if($this->perkara->add_data($data_perkara)){
					echo json_encode(array('st'=>1,'msg'=>'Berhasil Disimpan'));
				}else{
					echo json_encode(array('st'=>0,'msg'=>'Database Error, Pendaftaran Perkara Tidak Berhasil'));
				}
			}else{
				if($this->perkara->add_data($data_perkara, $matra)){
					echo json_encode(array('st'=>1,'msg'=>'Berhasil Disimpan'));
				}else{
					echo json_encode(array('st'=>0,'msg'=>'Database Error, Pendaftaran Perkara Tidak Berhasil'));
				}
			}
						
		}
	}
}